//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

var gCanvas;
var gStartPos={x:0, y:0};
var gDrawInSession = false;

function initCanvas() {
  gCanvas = document.getElementById('canvasContainer');
  addEventHandlers();
  gCtx = $('image').getContext("2d");
  gCtx.fillStyle = 'rgba(20,22,255,.1)';
  gCtx.strokeStyle = '#000000';
  gCtx.lineWidth = 50;
  gCtx.lineJoin = 'bevel';
  //gCtx.globalAlpha = 0.6;
}

function addEventHandlers() {
  gCanvas.addEventListener("mousedown", onMouseDown, false);
  gCanvas.addEventListener("mousemove", onMouseMove, false);
  gCanvas.addEventListener("mouseup", onMouseUp, false);
  //gCanvas.addEventListener("mouseup", onMouseOut, false);     
}

function onMouseDown(e) {
  gCtx.beginPath();
  gDrawInSession = !gDrawInSession;
  gStartPos = getCurrentPosition(e); 
  dump(gStartPos.x + ":" + gStartPos.y + "\n");
  flock_cleanupCanvas();
}

function onMouseUp(e) {
  gDrawInSession = false;
 
  var width = Math.abs(getCurrentPosition(e).x - gStartPos.x);
  var height = Math.abs(getCurrentPosition(e).y - gStartPos.y);
 
  // bail with an invalid widht or height
  if (!width && !height) {
    $('bCasterPhotoPropsAction').setAttribute('disabled', true);
    return;
  }

  var params = {};
  params.x = Math.min(gStartPos.x, getCurrentPosition(e).x);
  params.y = Math.min(gStartPos.y, getCurrentPosition(e).y);
  params.width = width;
  params.height = height;

  // enable crop command
  flock_updatePhotoCommand('cropImage', params);
  flock_photoSetupImage();
  gCtx.closePath();
}
  
function onMouseMove(e) {
  if (!gDrawInSession)
    return;
  gCtx.clearRect(0,0,400,400);
  darkenEntireCanvas(gCtx);
  gCtx.fillStyle = 'rgba(255,255,255,.8)';
  drawRectangle(gStartPos, getCurrentPosition(e), gCtx);
}

function darkenEntireCanvas(aContext) {
  aContext.globalCompositeOperation = 'xor';
  aContext.fillStyle = 'rgba(0,0,0,0.8)';
  var startPos = {x:0, y:0};
  var endPos = {x:400, y:400};
  drawRectangle(startPos, endPos, aContext);
}

function drawRectangle(aStartPos, aEndPos, aContext) {
  aContext.fillRect(aStartPos.x,
                    aStartPos.y,
                    aEndPos.x - aStartPos.x,
                    aEndPos.y - aStartPos.y)
  //aContext.closePath();
}

function getCurrentPosition(e) {
  //return {x:(e.layerX), y:(e.layerY)};
  return {x:(e.clientX - gCanvas.boxObject.x), y:(e.clientY - gCanvas.boxObject.y)}
}

// raj - FIXME this *really* shouldn't be here.. need a better way for the UI
// to communicate with the canvas to reset itself...
function flock_cleanupCanvas() {
  gCtx.clearRect(0,0,400,400);
}
