//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL
//

// Constants for services we need
const PROFILER_FILENAME = "profiler.rdf"
const PROFILER_PAGELOAD_PREF = "flock.services.js_profiler.pageload";

var flockProfilerProgressListener = {
  flockProfilerService: null,
  STATE_STOP: Components.interfaces.nsIWebProgressListener.STATE_STOP,
  STATE_IS_NETWORK: Components.interfaces.nsIWebProgressListener.STATE_IS_NETWORK,
  STATE_START: Components.interfaces.nsIWebProgressListener.STATE_START,
  
  onStateChange: function(aWebProgress, aRequest, aStateFlags, aStatus) {
    if (aStateFlags & this.STATE_STOP && aStateFlags & this.STATE_IS_NETWORK) {
      this._stopLoad(aRequest);
    }
    else if (aStateFlags & this.STATE_START) {
      this._startLoad(aRequest);
    }
  },
  
  onProgressChange: function(aWebProgress, aRequest, aCurSelfProgress, aMaxSelfProgress, aCurTotalProgress, aMaxTotalProgress) { },

  onLocationChange: function(aWebProgress, aRequest, aLocation) { },
  
  onStatusChange: function(aWebProgress, aRequest, aStatus, aMessage) { },

  onSecurityChange: function(aWebProgress, aRequest, aStatus) { },

  _stopLoad: function(aRequest) {
    if (aRequest && this.flockProfilerService) {
      this.flockProfilerService.stop();
      
      var dirService = Components.classes['@mozilla.org/file/directory_service;1'].getService(Components.interfaces.nsIProperties);
      var profileDir = dirService.get('ProfD', Components.interfaces.nsILocalFile);
      var file = Components.classes['@mozilla.org/file/local;1'].createInstance(Components.interfaces.nsILocalFile);
      file.initWithPath(profileDir.path);
      file.append(PROFILER_FILENAME);
      if(!file.exists()) file.createUnique(0,0600);
      dump("****** File is: " + file.path + "\n");
      
      var rdfService = Components.classes["@mozilla.org/rdf/rdf-service;1"].getService(Components.interfaces.nsIRDFService);      
      var flockProfilerDatasource = rdfService.GetDataSourceBlocking("file://" + file.path);      
      
      this.flockProfilerService.getProfileData(flockProfilerDatasource);
      
      flockProfilerDatasource.QueryInterface(Components.interfaces.nsIRDFRemoteDataSource);
      flockProfilerDatasource.Flush();
      
      this.flockProfilerService = null;
    }
  },

  _startLoad: function(aRequest) {
    if(aRequest) {
      if (!this.flockProfilerService) {
        this.flockProfilerService = Components.classes["@flock.com/js/profiler;1"].getService(Components.interfaces.flockIJSProfiler);
      }
      this.flockProfilerService.start();
    }
  }
};

var flockProfilerPrefObserver = {
  observe             : function(subject, topic, data) {
    if (topic == "nsPref:changed"/* && data == PROFILER_PAGELOAD_PREF*/) {
      var mPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                           .getService(Components.interfaces.nsIPrefBranch);
      dump("****** data = " + data + ", topic = " + topic + "\n");
      if (mPrefService.getPrefType(PROFILER_PAGELOAD_PREF) &&
          mPrefService.getBoolPref(PROFILER_PAGELOAD_PREF) ) {
        enablePageLoadProfiler();
      } else {
        disablePageLoadProfiler();
      }
    }
  }
};

function enablePageLoadProfiler() {
  window.getBrowser().addProgressListener(flockProfilerProgressListener, Components.interfaces.nsIWebProgress.NOTIFY_STATE_ALL | Components.interfaces.nsIWebProgress.NOTIFY_LOCATION);
}

function disablePageLoadProfiler() {
  window.getBrowser().removeProgressListener(flockProfilerProgressListener); 
}

function flockProfilerOnLoad() {
  var mPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                       .getService(Components.interfaces.nsIPrefBranch);
  
  if (mPrefService.getPrefType(PROFILER_PAGELOAD_PREF) &&
      mPrefService.getBoolPref(PROFILER_PAGELOAD_PREF) ) {
    enablePageLoadProfiler();
  }
  
  // Register to receive notifications of preference changes
  var mBranch = mPrefService.getBranch(PROFILER_PAGELOAD_PREF);
  mBranch.QueryInterface(Components.interfaces.nsIPrefBranch2);
  mBranch.addObserver("", flockProfilerPrefObserver, false);
}

function flockProfilerOnUnLoad() {
  var mPrefService = Components.classes["@mozilla.org/preferences-service;1"]
                       .getService(Components.interfaces.nsIPrefBranch);
  
  if (mPrefService.getPrefType(PROFILER_PAGELOAD_PREF) &&
      mPrefService.getBoolPref(PROFILER_PAGELOAD_PREF) ) {
    disablePageLoadProfiler();
  }
}

window.addEventListener("load", flockProfilerOnLoad, false);
window.addEventListener("unload", flockProfilerOnUnLoad, false);
