// vim: foldmethod=marker
//
// BEGIN FLOCK GPL
//
// Copyright Flock Inc. 2005-2009
// http://flock.com
//
// This file may be used under the terms of the
// GNU General Public License Version 2 or later (the "GPL"),
// http://www.gnu.org/licenses/gpl.html
//
// Software distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
// for the specific language governing rights and limitations under the
// License.
//
// END FLOCK GPL

var gTopbarObserver = {
    init: function() {
        this.observerService = Components.classes["@mozilla.org/observer-service;1"]
            .getService(Components.interfaces.nsIObserverService);
        this.observerService.addObserver(this, "flock.topbar.open", false);
    },
    uninit: function() {
        this.observerService.removeObserver(this, "flock.topbar.open");
    },
    observe: function(aSubject,aTopic,aData) {
        var mostRecentNavigator = Components.classes["@mozilla.org/appshell/window-mediator;1"]
             .getService(Components.interfaces.nsIWindowMediator)
             .getMostRecentWindow("navigator:browser");
        if(mostRecentNavigator == top) {
            if(aTopic=="flock.topbar.open") {
                FlockTopbar.selectById(aData);
            }
        }
    }
};

top.addEventListener("load", function() {
    gTopbarObserver.init();
    window.setTimeout("FlockTopbar.load()", 0);
}, false);

top.addEventListener("unload", function() {
    gTopbarObserver.uninit();
}, false);
