/*
 *
 * PIRATESHIP
 * Verbs file
 * (c) by Robin Johnson - robindouglasjohnson@gmail.com - twitter.com/rdouglasjohnson
 * Copy and distribute freely in unmodified form, preserving this licence.
 * No commercial use without permission of the author.
 *
 */


Verbs = {
	
	// take, drop and look come first, in that order
	take: {
		deactivate_when_carried: true,
		
		func: function(thing) {
			
			Game.things[thing].location = '';
			
			say('Taken.');
			hold(thing);
			
			//activate_verb(thing, 'drop');
			
			if(Game.things[thing].wearable) {
				activate_verb(thing, 'wear');
			}
			
			for(var verb in Verbs) {
				if(Verbs[verb].activate_when_carried) {
					activate_verb(thing, verb);
				}
				if(Game.things[thing].active_when_carried) {
					if(Game.things[thing].active_when_carried.indexOf(verb) != -1) {
						activate_verb(thing, verb);
					}
				}
				if(Verbs[verb].deactivate_when_carried) {
					deactivate_verb(thing, verb);
				}
			}
			
			
		}
	},
	
	drop: {
		activate_when_carried: true,
		deactivate_when_dropped: true,
		
		func: function(thing) {
			if(thing==Game.held) {
				unhold(true);
			}
			Game.things[thing].carried = false;
			Game.things[thing].location = Game.hero_location;
			
			if(Game.things[thing].portable) {
				activate_verb(thing, 'take');
			}
			
			//console.log('active_verbs are ' + Game.things[thing].active_verbs.join(','));
			var active_verbs = Game.things[thing].active_verbs;
			for(var i=active_verbs.length-1; i>=0; --i) {
				var verb = active_verbs[i];
				if(Verbs[verb] && Verbs[verb].deactivate_when_dropped ||
				   Game.things[thing].active_when_carried.indexOf(verb) != -1) {
					//console.log('it has deactivate_when_dropped');
					deactivate_verb(thing, verb);
				}
			}
			
			removeFrom(Game.inventory, thing);
			
			say('Dropped.');
		}
		
	},
	
	look: {
		//display: "&#x1F50D;", // magnifying glass symbol
		phrasing: function(thing) {
			return "look at " + name(thing);
		},
		func: function(thing) {
			/* if(Looks[thing]) {
				if(typeof Looks[thing] === 'function') {
					Looks[thing]();
				} else {
					say(Looks[thing]);
				}
			} else */ if(Game.things[thing].longdesc) {
				say(Game.things[thing].longdesc);
			} else {
				say("You see nothing special.");
			}
		}
	},
	
	look_through: {
		display: "look",
		phrasing: function(thing) {
			return "look through " + name(thing);
		},
		func: function(thing) {
			say("You see nothing special.")
		}
	},
	
	examine: {
		phrasing: function(thing) {
			return "look at " + name(thing);
		},
		func: function(thing) {
			
			if(Game.hero_blind) { // special for this game
				say("Maybe try taking the box off your head first.");
				return true;
			}
			
			if(!is_lit(Game.hero_location)) {
				say("It's too dark to see clearly.");
				return true;
			}
			
			if(Game.things[thing].longdesc) {
				say(Game.things[thing].longdesc);
			} else if (Longdesc[thing]) {
				say(Longdesc[thing]);
			} else if (has_active_verb(thing, 'read') || Game.things[thing].writing) {
				do_verb('read', thing, true);
			} else {
				say("You see nothing special about " + the_thing(thing) + ".");
			}
		}
	},
	
	unlock: {
		func: function(thing) {
			say("Click!");
			Game.things[thing].locked = false;
		}
	},
	
	wear: {
		deactivate_when_dropped: true,
		
		func: function(thing) {
			unhold();
			Game.things[thing].worn = true;
			deactivate_verb(thing, 'drop');
			deactivate_verb(thing, 'wear');
			activate_verb(thing, 'remove');
			//Game.things[thing].description += " (I'm wearing " + pronoun(thing, 1) + ")";
			
			if(!Game.things[thing].suppress_wear_message) { // special case for this game
				say("OK, you're wearing " + pronoun(thing, 1) + ".");
			}
		}
		
	},
	
	remove: {
		func: function(thing) {
			Game.things[thing].worn = false;
			activate_verb(thing, 'drop');
			activate_verb(thing, 'wear'); // assume it's wearable, else how are you removing it?
			deactivate_verb(thing, 'remove');
			hold(thing);
			
			/*if(Game.things[thing].description.indexOf(" (I'm wearing"	) != -1) {
				Game.things[thing].description =
				 Game.things[thing].description.substring(0, Game.things[thing].description.indexOf(" (I'm wearing"));
			}*/
			if(thing!='tea_crate') { // special case for this game
				say("OK, you've taken " + pronoun(thing, 1) + " off.");
			}
		}
	},
	
	read: {
		func: function(thing) {
			
			if(Game.hero_blind) {
				say("You don't read so well when you've got a box on your head.");
			} else if(!is_lit(Game.hero_location)) {
				say("It's too dark to read!");
			} else {
				say(pronoun(thing, 0, true) + " read" + s(thing) + ":");
				say('"' + Game.things[thing].writing + '"');
				Game.things[thing].read = true;
			}
		}
	},
	
	light: {
		deactivate_when_dropped: true,
		func: function(thing) {
			Game.things[thing].is_lit = true;
			Game.things[thing].description += " (lit)";
			deactivate_verb(thing, 'light');
			activate_verb(thing, 'unlight');
			say("OK, it's lit.");
		}
	},
	
	unlight: {
		deactivate_when_dropped: true,
		func: function(thing) {
			Game.things[thing].is_lit = false;
			var ixof = Game.things[thing].description.indexOf(" (lit)");
			if(ixof != -1) {
				Game.things[thing].description = Game.things[thing].description.substring(0, ixof);
			}
			deactivate_verb(thing, 'unlight');
			activate_verb(thing, 'light');
			say("OK, you've put it out.");
		}
	},
	
	open: {
		func: function(thing) {
			//console.log('Game.things[thing].contents is ' + Game.things[thing].contents);
			if(!Game.things[thing].contents.length) {
				say("There's nothing inside.");
			} else {
				var l = Game.things[thing].contents.length;
				say((l==1 ? "Something falls" : "Some things fall") + " out.");
				
				Game.things[thing].contents.forEach(function(thing) {
					put(thing, Game.hero_location);
				});
				
				Game.things[thing].contents = [];
			}
			
		}
	},
	
	close: {
		func: function(thing) {
			say("OK, it's closed.");
			Game.things[thing].open = false;
		}
	},
	
	move: {
		func: function(thing) {
			say("Nothing happens.");
		}
	},
	
	enter: {
		func: function(thing) {
			if(Game.suppress_ok) {
				delete Game.suppress_ok;
			} else if(Game.things[thing].enter_message) {
				say(Game.things[thing].enter_message);
			} else {
				say("OK");
			}
			Game.hero_location = Game.things[thing].enter_to;
		}
	},
	
	exit: {
		phrasing: function(thing) {
			return "exit through " + name(thing);
		},
		func: function(thing) {
			say("OK");
			Game.hero_location = Game.things[thing].exit_to;
		}
	},
	
	climb: {
		func: function(thing) {
			say("Up you go...");
			Game.hero_location = Game.things[thing].climb_to;
		}
	},
	
	descend: {
		func: function(thing) {
			say("Down you go...");
			Game.hero_location = Game.things[thing].descend_to;
		}
	},
	
	cross: {
		func: function(thing) {
			if(Game.things[thing].cross_message) {
				say(Game.things[thing].cross_message);
			} else {
				say("Over you go...");
			}
			Game.hero_location = Game.things[thing].cross_to;
		}
	},
	
	pick_berries: {
		display: "pick",
		phrasing: function(thing) {
			return "pick berries";
		},
		func: function(thing) {
			if(thing != 'berry_bush') {
				console.log("Tried to pick something other than berries??");
				return;
			}
			if(!Game.things.berry_bush.picked) {
				say("Ok. You picked a handful of berries.");
				give_hero('berries');
				get_point_for('picked_berries');
				Game.things.berry_bush.picked = true;
			} else {
				say("There aren't enough berries on the bush just now.");
			}
		}
	},
	
	pick: {
		func: function(thing) {
			clear_status(thing);
			deactivate_verb(thing, 'pick');
			Game.things[thing].portable = true;
			give_hero(thing);
			say("Taken.");
		}
	},
	
	drink: {
		func: function(thing) {
			say("Glug, glug...");
			take_away(thing);
		}
	},
	
	talk: {
		phrasing: function(thing) {
			return "talk to " + name(thing);
		},
		func: function(thing) {
			
			// PIRATE GAME ONLY - copper helmet stops you talking
			if(worn('diving_helmet')) {
				say("You can't talk to anyone while wearing this heavy helmet.");
				return;
			}
			
			if(Game.talking_to == thing) {
				say("You're already talking to " + the_thing(thing) + ".");
				return;
			}
			
			if(Game.talking_to != thing) {
				hide_conversation();
			}
			
			if(Game.things[thing].conversifier) {
				start_conversation(thing);
			} else if(Game.things[thing].says) {
				say(Game.things[thing].says);
			} else {
				say(the_thing(thing, true) + " isn't very talkative.");
			}
		}
	},
	
	give: {
		func: function(thing) {
			for(var recipient in Game.things) {
				if(in_scope(recipient) && Game.things[recipient].wants && Game.things[recipient].wants.indexOf(thing)!=-1) {
					say('<span class="prompt">(to ' + name(recipient) + ')</span>');
					Game.things[recipient].receive(thing);
					return;
				}
			}
			// didn't find anyone to give it to
			say("Nobody seems to want it.");
		}
	},
	
	wait: {
		intransitive: true,
		func: function(thing) {
			say("Time passes...");
		}
	},
	
	dig: {
		intransitive: true,
		func: function(thing) {
			say("Dig, dig...");
			if(Game.rooms[Game.hero_location].buried) {
				var n = Game.rooms[Game.hero_location].buried.length;
				Game.rooms[Game.hero_location].buried.forEach(function(thing) {
					put(thing, Game.hero_location);
				});
				Game.rooms[Game.hero_location].buried = [];
				if(n==0) {
					say("You didn't find anything.");
				} else if(n==1) {
					say("You found something!");
				} else {
					say("You found something!");
				}
			} else {
				say("You didn't find anything.");
			}
		}
	},
	
	show: {
		func: function(thing) {
			// find an NPC
			var found_npc = false;
			for(var npc in Game.things) {
				if(Game.things[npc].is_alive && location_of(npc) == Game.hero_location) {
					if(!found_npc) {
						say("You show " + the_thing(thing) + " to " + the_thing(npc) + ".");
					} else {
						say("Then you show " + pronoun(thing, 1) + " to " + the_thing(npc) + ".");
					}
					if(Game.things[npc].reacts) {
						Game.things[npc].reacts(thing);
					} else {
						say(the_thing(npc, true) + " take" + s(npc) + " no notice.");
					}
					found_npc = true;
				}
			}
			if(!found_npc) {
				say("I don't know who to show " + pronoun(thing, 1) + " to.");
			}
		}
	},
	
	load: {},
	
	throw: {
		func: function(thing) {
			say("OK");
			do_verb('drop', thing, true);
			//put(thing, Game.hero_location);
		}
	},

	eat: {
		func: function(thing) {
			say("Delicious!");
			take_away(thing);
		}
	},
	
	dip_in_tea: {
		display: "dip in tea",
		phrasing: function(thing) {
			return "dip " + name(thing) + " in tea";
		}
	},
	
	put_in_tea: {
		display: "put in tea",
		phrasing: function(thing) {
			return "put " + name(thing) + " in tea";
		}
	},
	
	put_in_sea: {
		display: "put in sea",
		phrasing: function(thing) {
			return "put " + name(thing) + " in sea";
		}
	},
	
	pull: {
		phrasing: function(thing) {
			if(thing=='exam_machine') {
				return 'pull lever';
			} else {
				return 'pull ' + name(thing)
			}
		},
		func: function(thing) {
			say("Pulling " + the_thing(thing) + " has no effect.");
		}
	},
		
	get_in: {
		display: "get in",
		func: function(thing) {
			say("You can't get in that.");
		}
	},
	
	push: {
		phrasing: function(thing) {
			if(thing=='jukebox'||thing=='spanner_finder'||thing=='mail_pod') {
				return "push button";
			} else {
				return 'push ' + name(thing);
			}
		},
		func: function(thing) {
			say("That doesn't achieve anything.");
		}
	},
	
	
	search: {
		func: function() {
			say("You don't find anything.");
		},
	},
	
	wake: {
		func: function(thing) {
			if(!Game.things[thing].asleep) {
				say(the_thing(thing, true) + " isn't asleep!");
			} else {
				say(the_thing(thing, true) + " won't wake up.");
			}
		}
	},
	
	steer: {
		intransitive: true,
		phrasing: function() {
			return "steer ship";
		},
		func: function() {
			say("You correct the course a little.");
		}
	},
	
	press: {
		func: function(thing) {
			say("Click!");
		}
	},
	
	load: {},
	fire: {},
	burst: {},
	jettison: {},
	watch: {},
	
	wave: {
		func: function(thing) {
			say("You wave " + the_thing(thing) + " about.");
		}
	},
	zap: {
		func: function(thing) {
			if(!held('wand')) {
				say("You're not holding something you can zap with.");
				console.log("Tried to zap while not holding wand??");
				return;
			}
			if(Game.hero_blind) {
				say("It's hard to aim properly with a box on your head.");
				return;
			}
			say('<span class="prompt">(with wand)</span>');
			say('ZAP!');
			if(!Game.things[thing].is_zoo_animal) {
				say('Nothing happens.');
			} else {
				zap(thing);
			}
		}
	},
	
	sit: {
		phrasing: function(thing) {
			return "sit on " + name(thing);
		},
		func: function(thing) {
			say("That doesn't look very comfortable.");
		},
	},

	turn_windlass: {
		intransitive: true,
		display: "turn windlass",
		func: function(thing) {
			var wasStill = (Game.things.air_compressor.winds==0);
			Game.things.air_compressor.winds += Game.things.air_compressor.winds_per_windlass_turn;
			if(Game.things.air_compressor.winds >= Game.things.air_compressor.max_winds) {
				Game.things.air_compressor.winds = Game.things.air_compressor.max_winds;
				say("You give the windlass a few turns clockwise, until it won't go any further, then let go.");
			} else {
				say("You turn the windlass several times clockwise, then let go.");
			}
			if(wasStill) {
				say("The windlass starts turning slowly backward. With a loud hiss, \
				the concertina part of the mechanism starts rising and falling like a giant bellows.");
				say("You feel an air flow inside the copper helmet.");
			} else {
				say("The windlass continues turning slowly backwards, the concertina bellows \
				rising and falling rhythmically.");
			}
			add_status('air_compressor', 'working');
		}
	},
	
	iron: {
		func: function(thing) {
			say('You put ' + the_thing(thing) + ' on the ironing board and pass the hot iron \
			over it a few times.');
			Game.things[thing].ironed = true;
			bring(thing);
		}
	},
	
	wind: {},
	flip: {},
	smell: {
		func: function(thing) {
			say(the_thing(thing, true) + ' doesn\'t smell very interesting.');
		}
	},
	put_in_vat: {
		display: "put in vat",
		phrasing: function(thing) {
			return "put " + name(thing) + " in vat";
		},
		func: function(thing) {
			say('That would be pointless.');
		},
	},
	unbolt: {
		func: function(thing) {
			say('You can\'t unbolt that.');
		}
	},
	jump: {
		intransitive: true,
		func: function(thing) {
			hero_location().parachute_jump();
		},
	},
	jump_through: {
		display: "jump",
		phrasing: function(thing) {
			return "jump through " + name(thing);
		},
	},
	land: {
		phrasing: function(thing) {
			return "land on " + name(thing);
		},
	},
	
	saw: {},
	
}


