/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.vm;

import java.util.ArrayList;
import java.util.List;
import org.zmpp.base.MemoryAccess;
import org.zmpp.iff.Chunk;
import org.zmpp.iff.DefaultChunk;
import org.zmpp.iff.FormChunk;
import org.zmpp.iff.WritableFormChunk;
import org.zmpp.vm.Cpu;
import org.zmpp.vm.Machine;
import org.zmpp.vm.RoutineContext;
import org.zmpp.vm.StoryFileHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortableGameState {
    public static final int DISCARD_RESULT = -1;
    private int release;
    private int checksum;
    private byte[] serialBytes = new byte[6];
    private int pc;
    private byte[] dynamicMem;
    private byte[] delta;
    private List<StackFrame> stackFrames = new ArrayList<StackFrame>();

    public int getRelease() {
        return this.release;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public String getSerialNumber() {
        return new String(this.serialBytes);
    }

    public int getProgramCounter() {
        return this.pc;
    }

    public List<StackFrame> getStackFrames() {
        return this.stackFrames;
    }

    public byte[] getDeltaBytes() {
        return this.delta;
    }

    public byte[] getDynamicMemoryDump() {
        return this.dynamicMem;
    }

    public void setRelease(int n) {
        this.release = n;
    }

    public void setChecksum(int n) {
        this.checksum = n;
    }

    public void setSerialNumber(String string) {
        this.serialBytes = string.getBytes();
    }

    public void setProgramCounter(int n) {
        this.pc = n;
    }

    public void setDynamicMem(byte[] byArray) {
        this.dynamicMem = byArray;
    }

    public boolean readSaveGame(FormChunk formChunk) {
        this.stackFrames.clear();
        if (formChunk != null && new String(formChunk.getSubId()).equals("IFZS")) {
            this.readIfhdChunk(formChunk);
            this.readStacksChunk(formChunk);
            this.readMemoryChunk(formChunk);
            return true;
        }
        return false;
    }

    private void readIfhdChunk(FormChunk formChunk) {
        Chunk chunk = formChunk.getSubChunk("IFhd".getBytes());
        MemoryAccess memoryAccess = chunk.getMemoryAccess();
        int n = 8;
        this.release = memoryAccess.readUnsignedShort(n);
        n += 2;
        for (int i = 0; i < 6; ++i) {
            this.serialBytes[i] = memoryAccess.readByte(n + i);
        }
        this.checksum = memoryAccess.readUnsignedShort(n += 6);
        this.pc = this.decodePcBytes(memoryAccess.readByte(n += 2), memoryAccess.readByte(n + 1), memoryAccess.readByte(n + 2));
    }

    private void readStacksChunk(FormChunk formChunk) {
        Chunk chunk = formChunk.getSubChunk("Stks".getBytes());
        MemoryAccess memoryAccess = chunk.getMemoryAccess();
        int n = 8;
        int n2 = chunk.getSize() + 8;
        while (n < n2) {
            StackFrame stackFrame = new StackFrame();
            n = this.readStackFrame(stackFrame, memoryAccess, n);
            this.stackFrames.add(stackFrame);
        }
    }

    public int readStackFrame(StackFrame stackFrame, MemoryAccess memoryAccess, int n) {
        int n2;
        int n3 = n;
        stackFrame.pc = this.decodePcBytes(memoryAccess.readByte(n3), memoryAccess.readByte(n3 + 1), memoryAccess.readByte(n3 + 2));
        n3 += 3;
        byte by = memoryAccess.readByte(n3++);
        int n4 = by & 0xF;
        boolean bl = (by & 0x10) > 0;
        stackFrame.locals = new short[n4];
        byte by2 = memoryAccess.readByte(n3++);
        stackFrame.returnVariable = bl ? -1 : (int)by2;
        byte by3 = memoryAccess.readByte(n3++);
        stackFrame.args = this.getArgs(by3);
        int n5 = memoryAccess.readUnsignedShort(n3);
        stackFrame.evalStack = new short[n5];
        n3 += 2;
        for (n2 = 0; n2 < n4; ++n2) {
            stackFrame.locals[n2] = memoryAccess.readShort(n3);
            n3 += 2;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            stackFrame.evalStack[n2] = memoryAccess.readShort(n3);
            n3 += 2;
        }
        return n3;
    }

    private void readMemoryChunk(FormChunk formChunk) {
        Chunk chunk = formChunk.getSubChunk("CMem".getBytes());
        Chunk chunk2 = formChunk.getSubChunk("UMem".getBytes());
        if (chunk != null) {
            this.readCMemChunk(chunk);
        }
        if (chunk2 != null) {
            this.readUMemChunk(chunk2);
        }
    }

    private void readCMemChunk(Chunk chunk) {
        int n;
        MemoryAccess memoryAccess = chunk.getMemoryAccess();
        int n2 = 8;
        int n3 = chunk.getSize() + 8;
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        while (n2 < n3) {
            byte by;
            if ((by = memoryAccess.readByte(n2++)) == 0) {
                n = memoryAccess.readUnsignedByte(n2++);
                for (int i = 0; i <= n; ++i) {
                    arrayList.add((byte)0);
                }
                continue;
            }
            arrayList.add(by);
        }
        this.delta = new byte[arrayList.size()];
        for (n = 0; n < this.delta.length; ++n) {
            this.delta[n] = (Byte)arrayList.get(n);
        }
    }

    private void readUMemChunk(Chunk chunk) {
        MemoryAccess memoryAccess = chunk.getMemoryAccess();
        int n = chunk.getSize();
        this.dynamicMem = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.dynamicMem[i] = memoryAccess.readByte(i + 8);
        }
    }

    public void captureMachineState(Machine machine, int n) {
        StoryFileHeader storyFileHeader = machine.getGameData().getStoryFileHeader();
        this.release = storyFileHeader.getRelease();
        this.checksum = storyFileHeader.getChecksum();
        this.serialBytes = storyFileHeader.getSerialNumber().getBytes();
        this.pc = n;
        MemoryAccess memoryAccess = machine.getGameData().getMemoryAccess();
        int n2 = storyFileHeader.getStaticsAddress();
        this.dynamicMem = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            this.dynamicMem[i] = memoryAccess.readByte(i);
        }
        this.captureStackFrames(machine);
    }

    private void captureStackFrames(Machine machine) {
        int n;
        Cpu cpu = machine.getCpu();
        List<RoutineContext> list = cpu.getRoutineContexts();
        StackFrame stackFrame = new StackFrame();
        stackFrame.args = new int[0];
        stackFrame.locals = new short[0];
        int n2 = this.calculateNumStackElements(machine, list, 0, 0);
        stackFrame.evalStack = new short[n2];
        for (n = 0; n < n2; ++n) {
            stackFrame.evalStack[n] = cpu.getStackElement(n);
        }
        this.stackFrames.add(stackFrame);
        for (n = 0; n < list.size(); ++n) {
            int n3;
            RoutineContext routineContext = list.get(n);
            StackFrame stackFrame2 = new StackFrame();
            stackFrame2.pc = routineContext.getReturnAddress();
            stackFrame2.returnVariable = routineContext.getReturnVariable();
            stackFrame2.locals = new short[routineContext.getNumLocalVariables()];
            for (n3 = 0; n3 < stackFrame2.locals.length; ++n3) {
                stackFrame2.locals[n3] = routineContext.getLocalVariable(n3);
            }
            stackFrame2.args = new int[routineContext.getNumArguments()];
            for (n3 = 0; n3 < stackFrame2.args.length; ++n3) {
                stackFrame2.args[n3] = n3;
            }
            n3 = routineContext.getInvocationStackPointer();
            n2 = this.calculateNumStackElements(machine, list, n + 1, n3);
            stackFrame2.evalStack = new short[n2];
            for (int i = 0; i < n2; ++i) {
                stackFrame2.evalStack[i] = cpu.getStackElement(n3 + i);
            }
            this.stackFrames.add(stackFrame2);
        }
    }

    private int calculateNumStackElements(Machine machine, List<RoutineContext> list, int n, int n2) {
        if (n < list.size()) {
            RoutineContext routineContext = list.get(n);
            return routineContext.getInvocationStackPointer() - n2;
        }
        return machine.getCpu().getStackPointer() - n2;
    }

    public WritableFormChunk exportToFormChunk() {
        byte[] byArray = "IFZS".getBytes();
        WritableFormChunk writableFormChunk = new WritableFormChunk(byArray);
        writableFormChunk.addChunk(this.createIfhdChunk());
        writableFormChunk.addChunk(this.createUMemChunk());
        writableFormChunk.addChunk(this.createStksChunk());
        return writableFormChunk;
    }

    private Chunk createIfhdChunk() {
        byte[] byArray = "IFhd".getBytes();
        byte[] byArray2 = new byte[13];
        DefaultChunk defaultChunk = new DefaultChunk(byArray, byArray2);
        MemoryAccess memoryAccess = defaultChunk.getMemoryAccess();
        memoryAccess.writeUnsignedShort(8, (short)this.release);
        for (int i = 0; i < this.serialBytes.length; ++i) {
            memoryAccess.writeByte(10 + i, this.serialBytes[i]);
        }
        memoryAccess.writeUnsignedShort(16, this.checksum);
        memoryAccess.writeByte(18, (byte)(this.pc >>> 16 & 0xFF));
        memoryAccess.writeByte(19, (byte)(this.pc >>> 8 & 0xFF));
        memoryAccess.writeByte(20, (byte)(this.pc & 0xFF));
        return defaultChunk;
    }

    private Chunk createUMemChunk() {
        byte[] byArray = "UMem".getBytes();
        return new DefaultChunk(byArray, this.dynamicMem);
    }

    private Chunk createStksChunk() {
        byte[] byArray = "Stks".getBytes();
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (StackFrame stackFrame : this.stackFrames) {
            this.writeStackFrameToByteBuffer(arrayList, stackFrame);
        }
        Object object = new byte[arrayList.size()];
        for (int i = 0; i < ((Object)object).length; ++i) {
            object[i] = (Byte)arrayList.get(i);
        }
        return new DefaultChunk(byArray, (byte[])object);
    }

    public void writeStackFrameToByteBuffer(List<Byte> list, StackFrame stackFrame) {
        int n = stackFrame.pc;
        list.add((byte)(n >>> 16 & 0xFF));
        list.add((byte)(n >>> 8 & 0xFF));
        list.add((byte)(n & 0xFF));
        boolean bl = stackFrame.returnVariable == -1;
        byte by = (byte)(stackFrame.locals.length & 0xF);
        if (bl) {
            by = (byte)(by | 0x10);
        }
        list.add(by);
        list.add((byte)(bl ? 0 : stackFrame.returnVariable));
        list.add(this.createArgSpecByte(stackFrame.args));
        int n2 = stackFrame.evalStack.length;
        this.addUnsignedShortToByteBuffer(list, n2);
        for (short s : stackFrame.locals) {
            this.addShortToByteBuffer(list, s);
        }
        for (short s : stackFrame.evalStack) {
            this.addShortToByteBuffer(list, s);
        }
    }

    private void addUnsignedShortToByteBuffer(List<Byte> list, int n) {
        list.add((byte)((n & 0xFF00) >> 8));
        list.add((byte)(n & 0xFF));
    }

    private void addShortToByteBuffer(List<Byte> list, short s) {
        list.add((byte)((s & 0xFF00) >>> 8));
        list.add((byte)(s & 0xFF));
    }

    private byte createArgSpecByte(int[] nArray) {
        byte by = 0;
        for (int n : nArray) {
            by = (byte)(by | 1 << n);
        }
        return by;
    }

    public void transferStateToMachine(Machine machine) {
        int n;
        MemoryAccess memoryAccess = machine.getGameData().getMemoryAccess();
        for (int i = 0; i < this.dynamicMem.length; ++i) {
            memoryAccess.writeByte(i, this.dynamicMem[i]);
        }
        ArrayList<RoutineContext> arrayList = new ArrayList<RoutineContext>();
        if (this.stackFrames.size() > 0) {
            StackFrame stackFrame = this.stackFrames.get(0);
            for (int i = 0; i < stackFrame.getEvalStack().length; ++i) {
                machine.getCpu().setVariable(0, stackFrame.getEvalStack()[i]);
            }
        }
        for (n = 1; n < this.stackFrames.size(); ++n) {
            int n2;
            StackFrame stackFrame = this.stackFrames.get(n);
            RoutineContext routineContext = new RoutineContext(0, stackFrame.locals.length);
            routineContext.setReturnVariable(stackFrame.returnVariable);
            routineContext.setReturnAddress(stackFrame.pc);
            routineContext.setNumArguments(stackFrame.args.length);
            for (n2 = 0; n2 < stackFrame.locals.length; ++n2) {
                routineContext.setLocalVariable(n2, stackFrame.locals[n2]);
            }
            for (n2 = 0; n2 < stackFrame.evalStack.length; ++n2) {
                machine.getCpu().setVariable(0, stackFrame.evalStack[n2]);
            }
            arrayList.add(routineContext);
        }
        machine.getCpu().setRoutineContexts(arrayList);
        n = this.getProgramCounter();
        if (machine.getGameData().getStoryFileHeader().getVersion() <= 3) {
            n += PortableGameState.getBranchOffsetLength(machine.getGameData().getMemoryAccess(), n);
        } else if (machine.getGameData().getStoryFileHeader().getVersion() >= 4) {
            ++n;
        }
        machine.getCpu().setProgramCounter(n);
    }

    public int getStoreVariable(Machine machine) {
        int n = this.getProgramCounter();
        return machine.getGameData().getMemoryAccess().readUnsignedByte(n);
    }

    private static int getBranchOffsetLength(MemoryAccess memoryAccess, int n) {
        short s = memoryAccess.readUnsignedByte(n);
        return (s & 0x40) > 0 ? 1 : 2;
    }

    private int[] getArgs(byte by) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < 7; ++i) {
            int n = 1 << i;
            if ((n & by) <= 0) continue;
            arrayList.add(i);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return nArray;
    }

    private int decodePcBytes(byte by, byte by2, byte by3) {
        return (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
    }

    public static class StackFrame {
        int pc;
        int returnVariable;
        short[] locals;
        short[] evalStack;
        int[] args;

        public int getProgramCounter() {
            return this.pc;
        }

        public int getReturnVariable() {
            return this.returnVariable;
        }

        public short[] getEvalStack() {
            return this.evalStack;
        }

        public short[] getLocals() {
            return this.locals;
        }

        public int[] getArgs() {
            return this.args;
        }

        public void setProgramCounter(int n) {
            this.pc = n;
        }

        public void setReturnVariable(int n) {
            this.returnVariable = n;
        }

        public void setEvalStack(short[] sArray) {
            this.evalStack = sArray;
        }

        public void setLocals(short[] sArray) {
            this.locals = sArray;
        }

        public void setArgs(int[] nArray) {
            this.args = nArray;
        }
    }
}

