/*
 * Decompiled with CFR 0.152.
 */
package Modules.Consumers;

import Modules.Consumers.AbstractConsumer;
import Modules.Errors.ErrorsFactory;
import Modules.Errors.IErrorModule;
import Modules.Queues.IMessage;
import Modules.TextAnalizer.Phrase;

public class SemanticError
extends AbstractConsumer {
    protected String name;

    public SemanticError(String name) {
        this.name = name;
    }

    public SemanticError() {
        this.name = "Errors";
    }

    public boolean consumeMessage(IMessage message) {
        if (!(message.messageIs("COMMAND") || message.messageIs("COMPNEEDE") || message.messageIs("COMPNOTHERE"))) {
            return true;
        }
        Phrase p = (Phrase)message.getAttrib();
        IErrorModule em = ErrorsFactory.GetErrorModule("SINTACERROR");
        if (em == null) {
            em = ErrorsFactory.CreateModule("SINTACERROR", "errores.xml", this.salida);
        }
        if (p.unknowVerb()) {
            em.showError("VERBUNKNOWN", p.getVerb());
            return false;
        }
        if (message.messageIs("COMPNEEDE")) {
            em.showError("COMPNEEDE", p.getVerb());
            return false;
        }
        if (message.messageIs("COMPNOTHERE")) {
            em.showError("COMPUNKNOWN", p.getComp());
            return false;
        }
        return true;
    }

    public String toString() {
        return this.name;
    }

    public static void main(String[] args) {
    }
}

