/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.trex.ng.comp;

import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.relaxng.RELAXNGGrammar;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.reader.GrammarReader;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.State;
import com.sun.msv.reader.trex.ng.RELAXNGReader;
import com.sun.msv.reader.trex.ng.comp.CompAttributeState;
import com.sun.msv.reader.trex.ng.comp.DefAttCompatibilityChecker;
import com.sun.msv.reader.trex.ng.comp.IDCompatibilityChecker;
import com.sun.msv.util.LightStack;
import com.sun.msv.util.StartTagInfo;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RELAXNGCompReader
extends RELAXNGReader {
    private final Map defaultedAttributes = new HashMap();
    public static final String AnnotationNamespace = "http://relaxng.org/ns/compatibility/annotations/1.0";
    private final LightStack lastRNGElement = new LightStack();
    private boolean inAnnotation = false;
    public static final String CERR_ANN_CHILD_ELEMENT = "RELAXNGReader.Compatibility.Annotation.ChildElement";
    public static final String CERR_ANN_MISPLACED = "RELAXNGReader.Compatibility.Annotation.Misplaced";
    public static final String CERR_ANN_INVALID_ATTRIBUTE = "RELAXNGReader.Compatibility.Annotation.InvalidAttribute";

    public static TREXGrammar parse(String grammarURL, GrammarReaderController controller) {
        RELAXNGCompReader reader = new RELAXNGCompReader(controller);
        reader.parse(grammarURL);
        return reader.getResult();
    }

    public static TREXGrammar parse(InputSource grammar, GrammarReaderController controller) {
        RELAXNGCompReader reader = new RELAXNGCompReader(controller);
        reader.parse(grammar);
        return reader.getResult();
    }

    public RELAXNGCompReader(GrammarReaderController controller) {
        this(controller, GrammarReader.createParserFactory(), new ExpressionPool());
    }

    public RELAXNGCompReader(GrammarReaderController controller, SAXParserFactory parserFactory, ExpressionPool pool) {
        this(controller, parserFactory, new StateFactory(), pool);
    }

    public RELAXNGCompReader(GrammarReaderController controller, SAXParserFactory parserFactory, StateFactory stateFactory, ExpressionPool pool) {
        super(controller, parserFactory, stateFactory, pool);
        this.lastRNGElement.push(null);
    }

    protected final void addDefaultValue(AttributeExp exp, String value) {
        this.setDeclaredLocationOf(exp);
        if (this.defaultedAttributes.put(exp, value) != null) {
            throw new Error();
        }
    }

    protected TREXGrammar getGrammar() {
        return this.grammar;
    }

    protected String localizeMessage(String propertyName, Object[] args) {
        String format;
        try {
            format = ResourceBundle.getBundle("com.sun.msv.reader.trex.ng.comp.Messages").getString(propertyName);
        }
        catch (Exception e) {
            return super.localizeMessage(propertyName, args);
        }
        return MessageFormat.format(format, args);
    }

    public void wrapUp() {
        super.wrapUp();
        if (!this.controller.hadError()) {
            new DefAttCompatibilityChecker(this, this.defaultedAttributes).test();
            new IDCompatibilityChecker(this).test();
        }
    }

    public void startElement(String uri, String local, String qname2, Attributes atts) throws SAXException {
        super.startElement(uri, local, qname2, atts);
        if (this.inAnnotation) {
            this.reportWarning(CERR_ANN_CHILD_ELEMENT, null, new Locator[]{this.locator});
            ((RELAXNGGrammar)this.grammar).isAnnotationCompatible = false;
        }
        if (uri.equals(AnnotationNamespace) && local.equals("annotation")) {
            int i = 0;
            while (i < atts.getLength()) {
                String attUri = atts.getURI(i);
                if (attUri.equals("") || attUri.equals(AnnotationNamespace) || attUri.equals("http://relaxng.org/ns/structure/1.0")) {
                    this.reportWarning(CERR_ANN_INVALID_ATTRIBUTE, new Object[]{atts.getQName(i)}, new Locator[]{this.locator});
                    ((RELAXNGGrammar)this.grammar).isAnnotationCompatible = false;
                    break;
                }
                ++i;
            }
            if (!(this.lastRNGElement.size() == 0 || this.lastRNGElement.top() == null || "value".equals(this.lastRNGElement.top()) || "param".equals(this.lastRNGElement.top()) || "name".equals(this.lastRNGElement.top()))) {
                this.reportWarning(CERR_ANN_MISPLACED, new Object[]{this.lastRNGElement.top()}, new Locator[]{this.locator});
                ((RELAXNGGrammar)this.grammar).isAnnotationCompatible = false;
            }
            this.inAnnotation = true;
        }
        this.lastRNGElement.push(null);
    }

    public void endElement(String uri, String local, String qname2) throws SAXException {
        super.endElement(uri, local, qname2);
        this.inAnnotation = false;
        this.lastRNGElement.pop();
        if (uri.equals("http://relaxng.org/ns/structure/1.0")) {
            this.lastRNGElement.pop();
            this.lastRNGElement.push(local);
        }
    }

    static {
        AnnotationNamespace = AnnotationNamespace;
        CERR_ANN_CHILD_ELEMENT = CERR_ANN_CHILD_ELEMENT;
        CERR_ANN_MISPLACED = CERR_ANN_MISPLACED;
        CERR_ANN_INVALID_ATTRIBUTE = CERR_ANN_INVALID_ATTRIBUTE;
    }

    public static class StateFactory
    extends RELAXNGReader.StateFactory {
        public State attribute(State parent, StartTagInfo tag) {
            return new CompAttributeState();
        }

        public TREXGrammar createGrammar(ExpressionPool pool, TREXGrammar parent) {
            return new RELAXNGGrammar(pool, parent);
        }
    }
}

