/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.helpers;

import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.Messages;

public class DefaultValidationEventHandler
implements ValidationEventHandler {
    public boolean handleEvent(ValidationEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        String severity = null;
        boolean retVal = false;
        switch (event.getSeverity()) {
            case 0: {
                severity = Messages.format("DefaultValidationEventHandler.Warning");
                retVal = true;
                break;
            }
            case 1: {
                severity = Messages.format("DefaultValidationEventHandler.Error");
                retVal = false;
                break;
            }
            case 2: {
                severity = Messages.format("DefaultValidationEventHandler.FatalError");
                retVal = false;
                break;
            }
            default: {
                DefaultValidationEventHandler._assert(false, Messages.format("DefaultValidationEventHandler.UnrecognizedSeverity", new Integer(event.getSeverity())));
            }
        }
        System.out.println(Messages.format("DefaultValidationEventHandler.SeverityMessage", severity, event.getMessage()));
        return retVal;
    }

    private static void _assert(boolean b, String msg) {
        if (!b) {
            throw new InternalError(msg);
        }
    }
}

