/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class AddGameWindow
extends JDialog {
    private DefaultListModel gamesVector = new DefaultListModel();
    private JList gamesList = new JList(this.gamesVector);
    private JTextPane gameInfoArea = new JTextPane();
    private JTextField gameNameTextField = new JTextField("Partida");
    private JTextField maxPlayersTextField = new JTextField("9999");
    private JCheckBox passwordRequiredBox = new JCheckBox("Contrase\u00f1a de servidor:");
    private JTextField passwordTextField = new JTextField("alohomora");
    private JCheckBox cbAge = new JCheckBox("AGE");
    private JCheckBox cbTelnet = new JCheckBox("Telnet");
    private JCheckBox cbIrc = new JCheckBox("IRC");
    private JButton botonAceptar = new JButton("Aceptar");
    private JButton botonCancelar = new JButton("Cancelar");
    private ServerConfigurationWindow madre;
    private GameInfo informacionJuego;
    boolean editMode = false;

    private void updateGameInfoArea() {
        this.gameInfoArea.setText(this.informacionJuego.toLongString());
        this.gameNameTextField.setText("Partida de " + this.gamesList.getSelectedValue().toString());
    }

    public AddGameWindow(final ServerConfigurationWindow madre) {
        this.madre = madre;
        this.setTitle("Partida dedicada");
        this.setSize(600, 400);
        GameInfo[] gi = GameInfo.getListOfGames();
        int i = 0;
        while (i < gi.length) {
            this.gamesVector.addElement(gi[i]);
            ++i;
        }
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelPrincipal = new JPanel(new GridLayout(3, 1));
        JPanel subPan1 = new JPanel();
        this.gamesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                AddGameWindow.this.informacionJuego = (GameInfo)AddGameWindow.this.gamesList.getSelectedValue();
                AddGameWindow.this.updateGameInfoArea();
            }
        });
        this.gamesList.setSelectedIndex(0);
        subPan1.setLayout(new GridLayout(1, 2));
        subPan1.add(new JScrollPane(this.gamesList, 20, 30));
        JPanel ctl = new JPanel(new BorderLayout());
        this.gamesList.setBackground(Color.black);
        this.gamesList.setForeground(Color.white);
        this.gameInfoArea.setBackground(Color.black);
        this.gameInfoArea.setForeground(Color.white);
        subPan1.add(new JScrollPane(this.gameInfoArea, 20, 30));
        JPanel subPan2 = new JPanel(new GridLayout(3, 1));
        JPanel subPan21 = new JPanel();
        subPan21.add(new JLabel("Nombre de la partida:"));
        subPan21.add(this.gameNameTextField);
        JPanel subPan22 = new JPanel();
        subPan22.add(new JLabel("M\u00e1ximo de jugadores:"));
        subPan22.add(this.maxPlayersTextField);
        JPanel subPan23 = new JPanel();
        subPan23.add(this.passwordRequiredBox);
        subPan23.add(this.passwordTextField);
        subPan2.add(subPan21);
        subPan2.add(subPan22);
        subPan2.add(subPan23);
        JPanel subPan3 = new JPanel();
        subPan3.setLayout(new GridLayout(2, 1));
        JPanel subPan31 = new JPanel();
        subPan3.setBorder(BorderFactory.createTitledBorder("Servir por:"));
        subPan31.add(this.cbAge);
        subPan31.add(this.cbTelnet);
        subPan31.add(this.cbIrc);
        subPan3.add(subPan31);
        subPan3.add(new JLabel("(s\u00f3lo si dichos servidores est\u00e1n activos)", 0));
        panelPrincipal.add(subPan1);
        panelPrincipal.add(subPan2);
        panelPrincipal.add(subPan3);
        JPanel panelBotones = new JPanel(new GridLayout(1, 4));
        panelBotones.add(new JPanel());
        panelBotones.add(new JPanel());
        panelBotones.add(this.botonAceptar);
        panelBotones.add(this.botonCancelar);
        panelPrincipal.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)panelPrincipal, "Center");
        this.getContentPane().add((Component)panelBotones, "South");
        this.botonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AddGameWindow.this.dispose();
            }
        });
        this.botonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PartidaEntry pe = AddGameWindow.this.getEntrada();
                madre.addPartidaEntry(pe);
                AddGameWindow.this.dispose();
            }
        });
    }

    public AddGameWindow(final ServerConfigurationWindow madre, final PartidaEntry aEditar) {
        this.madre = madre;
        this.editMode = true;
        this.setTitle("Partida dedicada");
        this.setSize(600, 400);
        GameInfo[] gi = GameInfo.getListOfGames();
        int i = 0;
        while (i < gi.length) {
            this.gamesVector.addElement(gi[i]);
            ++i;
        }
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panelPrincipal = new JPanel(new GridLayout(3, 1));
        JPanel subPan1 = new JPanel();
        this.gamesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                AddGameWindow.this.informacionJuego = (GameInfo)AddGameWindow.this.gamesList.getSelectedValue();
                AddGameWindow.this.updateGameInfoArea();
            }
        });
        int i2 = 0;
        while (i2 < this.gamesVector.size()) {
            System.out.println("Infos for index " + i2 + ": ");
            System.out.println("" + (GameInfo)this.gamesVector.get(i2));
            System.out.println("" + aEditar.getGameInfo());
            if (((GameInfo)this.gamesVector.get(i2)).equals(aEditar.getGameInfo())) break;
            ++i2;
        }
        if (i2 < this.gamesVector.size()) {
            this.gamesList.setSelectedIndex(i2);
        } else {
            this.gamesList.setSelectedIndex(0);
        }
        subPan1.setLayout(new GridLayout(1, 2));
        subPan1.add(new JScrollPane(this.gamesList, 20, 30));
        JPanel ctl = new JPanel(new BorderLayout());
        this.gamesList.setBackground(Color.black);
        this.gamesList.setForeground(Color.white);
        this.gameInfoArea.setBackground(Color.black);
        this.gameInfoArea.setForeground(Color.white);
        subPan1.add(new JScrollPane(this.gameInfoArea, 20, 30));
        JPanel subPan2 = new JPanel(new GridLayout(3, 1));
        JPanel subPan21 = new JPanel();
        subPan21.add(new JLabel("Nombre de la partida:"));
        this.gameNameTextField.setText(aEditar.getName());
        subPan21.add(this.gameNameTextField);
        JPanel subPan22 = new JPanel();
        subPan22.add(new JLabel("M\u00e1ximo de jugadores:"));
        this.maxPlayersTextField.setText(String.valueOf(aEditar.getMaxPlayers()));
        subPan22.add(this.maxPlayersTextField);
        JPanel subPan23 = new JPanel();
        subPan23.add(this.passwordRequiredBox);
        this.passwordTextField.setText(String.valueOf(aEditar.getPassword()));
        subPan23.add(this.passwordTextField);
        subPan2.add(subPan21);
        subPan2.add(subPan22);
        subPan2.add(subPan23);
        JPanel subPan3 = new JPanel();
        subPan3.setLayout(new GridLayout(2, 1));
        JPanel subPan31 = new JPanel();
        subPan3.setBorder(BorderFactory.createTitledBorder("Servir por:"));
        this.cbAge.setSelected(aEditar.sirveAge());
        this.cbTelnet.setSelected(aEditar.sirveTelnet());
        this.cbIrc.setSelected(aEditar.sirveIrc());
        subPan31.add(this.cbAge);
        subPan31.add(this.cbTelnet);
        subPan31.add(this.cbIrc);
        subPan3.add(subPan31);
        subPan3.add(new JLabel("(s\u00f3lo si dichos servidores est\u00e1n activos)", 0));
        panelPrincipal.add(subPan1);
        panelPrincipal.add(subPan2);
        panelPrincipal.add(subPan3);
        JPanel panelBotones = new JPanel(new GridLayout(1, 4));
        panelBotones.add(new JPanel());
        panelBotones.add(new JPanel());
        panelBotones.add(this.botonAceptar);
        panelBotones.add(this.botonCancelar);
        panelPrincipal.setBorder(BorderFactory.createEtchedBorder());
        this.getContentPane().add((Component)panelPrincipal, "Center");
        this.getContentPane().add((Component)panelBotones, "South");
        this.botonCancelar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (AddGameWindow.this.editMode) {
                    madre.addPartidaEntry(aEditar);
                }
                AddGameWindow.this.dispose();
            }
        });
        this.botonAceptar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PartidaEntry pe = AddGameWindow.this.getEntrada();
                madre.addPartidaEntry(pe);
                AddGameWindow.this.dispose();
            }
        });
    }

    public PartidaEntry getEntrada() {
        try {
            return new PartidaEntry((GameInfo)this.gamesList.getSelectedValue(), this.gameNameTextField.getText(), this.maxPlayersTextField.getText(), this.passwordRequiredBox.isSelected() ? this.passwordTextField.getText() : null, this.cbAge.isSelected(), this.cbTelnet.isSelected(), this.cbIrc.isSelected());
        }
        catch (NumberFormatException nfe) {
            return new PartidaEntry((GameInfo)this.gamesList.getSelectedValue(), this.gameNameTextField.getText(), 9999, this.passwordRequiredBox.isSelected() ? this.passwordTextField.getText() : null, this.cbAge.isSelected(), this.cbTelnet.isSelected(), this.cbIrc.isSelected());
        }
    }
}

