/*
 * Decompiled with CFR 0.152.
 */
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Path
extends Entity
implements Descriptible {
    public static final int NORTE = 0;
    public static final int SUR = 1;
    public static final int OESTE = 2;
    public static final int ESTE = 3;
    public static final int NOROESTE = 4;
    public static final int NORDESTE = 5;
    public static final int SUROESTE = 6;
    public static final int SUDESTE = 7;
    public static final int ARRIBA = 8;
    public static final int ABAJO = 9;
    protected byte exitTime;
    protected Description[] descriptionList;
    String[] exitCommand;
    int destination;
    protected boolean peerable;
    protected boolean isStandard;
    Inventory keys;
    protected Item associatedItem = null;

    public static final String directionName(int dir2) {
        String s;
        switch (dir2) {
            case 0: {
                s = "norte";
                break;
            }
            case 1: {
                s = "sur";
                break;
            }
            case 2: {
                s = "oeste";
                break;
            }
            case 3: {
                s = "este";
                break;
            }
            case 4: {
                s = "noroeste";
                break;
            }
            case 5: {
                s = "nordeste";
                break;
            }
            case 6: {
                s = "suroeste";
                break;
            }
            case 7: {
                s = "sudeste";
                break;
            }
            case 8: {
                s = "arriba";
                break;
            }
            default: {
                s = "abajo";
            }
        }
        return s;
    }

    public static final int nameToDirection(String nombre) {
        String name = nombre.toLowerCase();
        if (name.equalsIgnoreCase("norte")) {
            return 0;
        }
        if (name.equalsIgnoreCase("sur")) {
            return 1;
        }
        if (name.equalsIgnoreCase("este")) {
            return 3;
        }
        if (name.equalsIgnoreCase("oeste")) {
            return 2;
        }
        if (name.equalsIgnoreCase("noroeste")) {
            return 4;
        }
        if (name.equalsIgnoreCase("nordeste")) {
            return 5;
        }
        if (name.equalsIgnoreCase("suroeste")) {
            return 6;
        }
        if (name.equalsIgnoreCase("sudeste")) {
            return 7;
        }
        if (name.equalsIgnoreCase("arriba")) {
            return 8;
        }
        if (name.equalsIgnoreCase("abajo")) {
            return 9;
        }
        System.out.println("Found strange std. path direction: " + name);
        new Exception().printStackTrace();
        return 10;
    }

    public void setDestination(Room r) {
        this.destination = r.getID();
    }

    public Object clone() {
        Path p = new Path();
        p.exitTime = this.exitTime;
        p.descriptionList = new Description[this.descriptionList.length];
        p.isStandard = this.isStandard;
        p.destination = this.destination;
        p.associatedItem = this.associatedItem;
        p.peerable = this.peerable;
        p.keys = this.keys != null ? (Inventory)this.keys.clone() : this.keys;
        int i = 0;
        while (i < this.descriptionList.length) {
            p.descriptionList[i] = (Description)this.descriptionList[i].clone();
            ++i;
        }
        if (this.exitCommand != null) {
            p.exitCommand = new String[this.exitCommand.length];
            i = 0;
            while (i < this.exitCommand.length) {
                p.exitCommand[i] = this.exitCommand[i];
                ++i;
            }
        } else {
            p.exitCommand = null;
        }
        return p;
    }

    Path() {
    }

    Path(World mundo, boolean isStandard, String curToken) {
        byte ntokens = (byte)StringMethods.numToks(curToken, '$');
        this.isStandard = isStandard;
        try {
            this.destination = Integer.valueOf(StringMethods.getTok(curToken, 1, '$'));
        }
        catch (NumberFormatException NumExc) {
            this.destination = 0;
        }
        this.descriptionList = Utility.loadDescriptionListFromString(StringMethods.getTok(curToken, 2, '$'));
        if (ntokens > 2) {
            this.exitTime = Byte.valueOf(StringMethods.getTok(curToken, 3, '$'));
        }
        if (isStandard) {
            String thetoken;
            if (ntokens > 3) {
                this.peerable = Boolean.valueOf(StringMethods.getTok(curToken, 4, '$'));
            }
            if (ntokens > 4) {
                thetoken = StringMethods.getTok(curToken, 5, '$');
                if (thetoken.length() > 4 && thetoken.substring(0, 4).equalsIgnoreCase("item")) {
                    this.associatedItem = mundo.getItem(thetoken.substring(4));
                } else {
                    this.setNewState(Integer.valueOf(StringMethods.getTok(curToken, 5, '$')));
                }
            }
            if (ntokens > 5) {
                thetoken = StringMethods.getTok(curToken, 6, '$');
                int nKeys = StringMethods.numToks(thetoken, '&');
                this.keys = new Inventory(10000000, 10000000);
                int i = 0;
                while (i < nKeys) {
                    try {
                        if (Integer.valueOf(StringMethods.getTok(thetoken, i + 1, '&')) > 0) {
                            this.keys.addItem(mundo.getItem(StringMethods.getTok(thetoken, i + 1, '&')));
                        }
                    }
                    catch (Exception exc) {
                        mundo.escribir("Excepci\u00f3n absurda. \u00bfHabr\u00e1 alguna llave muy pesada?");
                        System.out.println(exc);
                    }
                    ++i;
                }
            } else {
                this.keys = new Inventory(10000000, 10000000);
            }
        } else {
            String thetoken;
            if (ntokens > 3) {
                String commandList = StringMethods.getTok(curToken, 4, '$');
                this.exitCommand = new String[StringMethods.numToks(commandList, '&')];
                int j = 0;
                while (j < this.exitCommand.length) {
                    this.exitCommand[j] = StringMethods.getTok(commandList, j + 1, '&');
                    ++j;
                }
            }
            if (ntokens > 4) {
                this.peerable = Boolean.valueOf(StringMethods.getTok(curToken, 5, '$'));
            }
            if (ntokens > 5) {
                thetoken = StringMethods.getTok(curToken, 6, '$');
                if (thetoken.length() > 4 && thetoken.substring(0, 4).equalsIgnoreCase("item")) {
                    this.associatedItem = mundo.getItem(thetoken.substring(4));
                } else {
                    this.setNewState(Integer.valueOf(StringMethods.getTok(curToken, 6, '$')));
                }
            }
            if (ntokens > 6) {
                thetoken = StringMethods.getTok(curToken, 7, '$');
                int nKeys = StringMethods.numToks(thetoken, '&');
                this.keys = new Inventory(10000000, 10000000);
                int i = 0;
                while (i < nKeys) {
                    try {
                        if (Integer.valueOf(StringMethods.getTok(thetoken, i + 1, '&')) > 0) {
                            this.keys.addItem(mundo.getItem(StringMethods.getTok(thetoken, i + 1, '&')));
                        }
                    }
                    catch (Exception exc) {
                        mundo.escribir("Excepci\u00f3n absurda. \u00bfHabr\u00e1 alguna llave muy pesada?");
                    }
                    ++i;
                }
            } else {
                this.keys = new Inventory(10000000, 10000000);
            }
        }
    }

    public boolean isValid() {
        return this.destination != 0;
    }

    public int getDestinationID() {
        return this.destination;
    }

    public String getDescription(long comparand) {
        String desString = "";
        int i = 0;
        while (i < this.descriptionList.length) {
            if (this.descriptionList[i].matches(comparand)) {
                desString = String.valueOf(desString) + this.descriptionList[i].getText();
            }
            ++i;
        }
        return desString;
    }

    public String getDescription(Entity viewer) {
        String desString = "";
        int i = 0;
        while (i < this.descriptionList.length) {
            if (this.descriptionList[i].matchesConditions(this, viewer)) {
                desString = String.valueOf(desString) + this.descriptionList[i].getText();
            }
            ++i;
        }
        return desString;
    }

    public boolean matchExitCommand(String toParse) {
        int i = 0;
        while (i < this.exitCommand.length) {
            if (this.exitCommand[i].equalsIgnoreCase(toParse)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getNonStandardName() {
        System.out.println("Path: " + this.destination + " " + this.isStandard);
        return this.exitCommand[0];
    }

    void go(Mobile c) {
        c.setNewState(2, this.exitTime * 12 / c.getStat("velocidad"));
        c.setNewTarget(this.destination);
        System.out.println("Target is: " + c.getTarget());
        System.out.println("Entity is: " + c.getID());
        System.out.println("Exit time: " + this.exitTime);
    }

    public void changeState(World mundo) {
    }

    public int getState() {
        if (this.associatedItem == null) {
            return super.getState();
        }
        return this.associatedItem.getState();
    }

    public boolean getPropertyValueAsBoolean(String propName) {
        if (propName.equals("closed") || propName.equals("locked")) {
            if (this.associatedItem == null) {
                return super.getPropertyValueAsBoolean(propName);
            }
            return this.associatedItem.getPropertyValueAsBoolean(propName);
        }
        return super.getPropertyValueAsBoolean(propName);
    }

    public boolean isOpen() {
        return (0x100 & this.getState()) == 0 && !this.getPropertyValueAsBoolean("closed");
    }

    public boolean isClosed() {
        return !this.isOpen();
    }

    public boolean isLocked() {
        return !this.isUnlocked();
    }

    public boolean isUnlocked() {
        return (0x200 & this.getState()) == 0 && !this.getPropertyValueAsBoolean("locked");
    }

    public boolean unlocksWithKey(Item key) {
        if (this.associatedItem != null) {
            return this.associatedItem.unlocksWithKey(key);
        }
        int i = 0;
        while (i < this.keys.size()) {
            if (this.keys.elementAt(i).equals(key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isStandard() {
        return this.isStandard;
    }

    public boolean isExtended() {
        return this.exitCommand != null && this.exitCommand.length > 0;
    }

    public static String invert(String s) {
        String temp = StringMethods.textualSubstitution(s, "norte", "$%%N%%$");
        temp = StringMethods.textualSubstitution(temp, "sur", "$%%S%%$");
        temp = StringMethods.textualSubstitution(temp, "oeste", "$%%W%%$");
        temp = StringMethods.textualSubstitution(temp, "este", "$%%E%%$");
        temp = StringMethods.textualSubstitution(temp, "arriba", "$%%U%%$");
        temp = StringMethods.textualSubstitution(temp, "abajo", "$%%D%%$");
        temp = StringMethods.textualSubstitution(temp, "dentro", "$%%I%%$");
        temp = StringMethods.textualSubstitution(temp, "fuera", "$%%O%%$");
        temp = StringMethods.textualSubstitution(temp, "$%%N%%$", "sur");
        temp = StringMethods.textualSubstitution(temp, "$%%S%%$", "norte");
        temp = StringMethods.textualSubstitution(temp, "$%%E%%$", "oeste");
        temp = StringMethods.textualSubstitution(temp, "$%%W%%$", "este");
        temp = StringMethods.textualSubstitution(temp, "$%%U%%$", "abajo");
        temp = StringMethods.textualSubstitution(temp, "$%%D%%$", "arriba");
        temp = StringMethods.textualSubstitution(temp, "$%%I%%$", "fuera");
        temp = StringMethods.textualSubstitution(temp, "$%%O%%$", "dentro");
        return temp;
    }

    public Path(World mundo, Node n) throws XMLtoWorldException {
        NodeList assocItemNodes;
        NodeList keyListNodes;
        NodeList cmdListNodes;
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Path node not Element");
        }
        this.peerable = false;
        this.isStandard = false;
        Element e = (Element)n;
        try {
            if (!e.hasAttribute("destination")) {
                throw new XMLtoWorldException("Destination attribute missing at path. Node is " + n);
            }
            this.destination = Integer.valueOf(e.getAttribute("destination"));
        }
        catch (NumberFormatException nfe) {
            int dest = mundo.roomNameToID(e.getAttribute("destination"));
            if (dest >= 0) {
                this.destination = dest;
            }
            throw new XMLtoWorldException("Destination attribute invalid at path. Value found is \"" + e.getAttribute("destination") + "\"");
        }
        try {
            this.exitTime = !e.hasAttribute("exitTime") ? (byte)30 : Byte.valueOf(e.getAttribute("exitTime"));
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("exitTime attribute invalid at path");
        }
        if (e.hasAttribute("peerable")) {
            this.peerable = Boolean.valueOf(e.getAttribute("peerable"));
        }
        if (e.hasAttribute("standard")) {
            this.isStandard = Boolean.valueOf(e.getAttribute("standard"));
        }
        this.readPropListFromXML(mundo, n);
        NodeList descrListNodes = e.getElementsByTagName("DescriptionList");
        if (descrListNodes.getLength() > 0) {
            Element descrListNode = (Element)descrListNodes.item(0);
            NodeList descrNodes = descrListNode.getElementsByTagName("Description");
            this.descriptionList = new Description[descrNodes.getLength()];
            int i = 0;
            while (i < descrNodes.getLength()) {
                Element descrNode = (Element)descrNodes.item(i);
                try {
                    this.descriptionList[i] = new Description(mundo, descrNode);
                }
                catch (XMLtoWorldException xe) {
                    throw new XMLtoWorldException("Error at path description: " + xe.getMessage());
                }
                ++i;
            }
        }
        if ((cmdListNodes = e.getElementsByTagName("CommandList")).getLength() > 0) {
            Element cmdListNode = (Element)cmdListNodes.item(0);
            NodeList cmdNodes = cmdListNode.getElementsByTagName("Command");
            this.exitCommand = new String[cmdNodes.getLength()];
            int i = 0;
            while (i < cmdNodes.getLength()) {
                Element cmdNode = (Element)cmdNodes.item(i);
                if (!cmdNode.hasAttribute("name")) {
                    throw new XMLtoWorldException("Error at path: exit command without a name");
                }
                this.exitCommand[i] = cmdNode.getAttribute("name");
                ++i;
            }
        }
        if ((keyListNodes = e.getElementsByTagName("KeyList")).getLength() > 0) {
            Element keyListNode = (Element)keyListNodes.item(0);
            NodeList keyInvList = keyListNode.getElementsByTagName("Inventory");
            if (keyInvList.getLength() > 0) {
                Element keyInvElt = (Element)keyInvList.item(0);
                try {
                    this.keys = new Inventory(mundo, keyInvElt);
                }
                catch (XMLtoWorldException xe) {
                    throw new XMLtoWorldException("Error at path key ID's inventory: " + xe.getMessage());
                }
            } else {
                this.keys = new Inventory(10000, 10000);
            }
        }
        if ((assocItemNodes = e.getElementsByTagName("AssociatedItem")).getLength() > 0) {
            Element assocItemNode = (Element)assocItemNodes.item(0);
            if (assocItemNode.hasAttribute("id")) {
                this.associatedItem = mundo.getItem(assocItemNode.getAttribute("id"));
            } else {
                throw new XMLtoWorldException("Error at path, associated item has no attribute named id.");
            }
        }
    }

    public Node getXMLRepresentation(Document doc, String standardExitNameAttr) {
        Node n = this.getXMLRepresentation(doc);
        if (n instanceof Element) {
            ((Element)n).setAttribute("direction", standardExitNameAttr);
        }
        return n;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("Path");
        suElemento.setAttribute("destination", String.valueOf(this.destination));
        suElemento.setAttribute("exitTime", String.valueOf(this.exitTime));
        suElemento.setAttribute("peerable", String.valueOf(this.peerable));
        suElemento.setAttribute("standard", String.valueOf(this.isStandard));
        suElemento.appendChild(this.getPropListXMLRepresentation(doc));
        Element listaDesc = doc.createElement("DescriptionList");
        int i = 0;
        while (i < this.descriptionList.length) {
            Description nuestraDescripcion = this.descriptionList[i];
            listaDesc.appendChild(nuestraDescripcion.getXMLRepresentation(doc));
            ++i;
        }
        suElemento.appendChild(listaDesc);
        if (this.exitCommand != null) {
            Element listaCmd = doc.createElement("CommandList");
            int i2 = 0;
            while (i2 < this.exitCommand.length) {
                String comandoSalida = this.exitCommand[i2];
                Element elementoComando = doc.createElement("Command");
                elementoComando.setAttribute("name", this.exitCommand[i2]);
                listaCmd.appendChild(elementoComando);
                ++i2;
            }
            suElemento.appendChild(listaCmd);
        }
        if (this.keys != null) {
            Element eltLlaves = doc.createElement("KeyList");
            Node listaLlaves = this.keys.getXMLRepresentation(doc);
            eltLlaves.appendChild(listaLlaves);
            suElemento.appendChild(eltLlaves);
        }
        if (this.associatedItem != null) {
            Element item = doc.createElement("AssociatedItem");
            item.setAttribute("id", String.valueOf(this.associatedItem.getID()));
            suElemento.appendChild(item);
        }
        return suElemento;
    }

    public int getID() {
        return -1;
    }
}

