/*
 * Decompiled with CFR 0.152.
 */
package jurt;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import jurt.Action;
import jurt.Factor;
import jurt.Grammar;
import jurt.IO;
import jurt.Nomen;
import jurt.Rebuff;
import jurt.Refusal;
import jurt.ScopeMethod;
import jurt.Vicinity;

public class Concept
implements Serializable {
    public static final int VERBOSELOOK = 0;
    public static final int BRIEFLOOK = 1;
    public static final int NOLOOK = 2;
    public static final int INCIDENTALLOOK = 4;
    static Hashtable plurals = new Hashtable();
    private Vector children;
    private Concept parent;
    protected Hashtable properties = new Hashtable();
    protected String rootname;

    public Concept(String string) {
        this.rootname = string;
    }

    public Concept(String string, Concept concept) {
        this(string);
        this.setParent(concept);
    }

    public String toString() {
        return this.rootname;
    }

    public String name() {
        return this.rootname;
    }

    public Nomen indef(int n) {
        if (n == 1) {
            return this.indef();
        }
        if (0 <= n && n < IO.NUMBERS.length) {
            return new Nomen(IO.NUMBERS[n] + " " + this.get("species"), true);
        }
        return new Nomen(IO.NUMBERFORMAT.format(n) + " " + this.get("species"), true);
    }

    public Nomen indef() {
        String string = this.name();
        if (!this.has("proper")) {
            string = this.has("plural") || this.has("fluid") ? "some " + string : ("aeiouAEIOU".indexOf(this.rootname.charAt(0)) >= 0 ? "an " + string : "a " + string);
        }
        return new Nomen(string, this.has("plural"));
    }

    public Nomen def() {
        String string = this.name();
        if (!this.has("proper")) {
            string = "the " + string;
        }
        return new Nomen(string, this.has("plural"));
    }

    public Nomen sdef() {
        return this.def();
    }

    public Nomen cdef() {
        String string = this.name();
        if (!this.has("proper")) {
            string = "The " + string;
        }
        return new Nomen(string, this.has("plural"));
    }

    public Nomen them() {
        if (this.has("plural")) {
            return new Nomen("them", true);
        }
        if (this.has("male")) {
            return new Nomen("him", false);
        }
        if (this.has("female")) {
            return new Nomen("her", false);
        }
        return new Nomen("it", false);
    }

    public Nomen those() {
        if (this.has("plural")) {
            return new Nomen("those", true);
        }
        if (this.has("male")) {
            return new Nomen("he", false);
        }
        if (this.has("female")) {
            return new Nomen("she", false);
        }
        return new Nomen("that", false);
    }

    public Nomen cthose() {
        if (this.has("plural")) {
            return new Nomen("Those", true);
        }
        if (this.has("male")) {
            return new Nomen("He", false);
        }
        if (this.has("female")) {
            return new Nomen("She", false);
        }
        return new Nomen("That", false);
    }

    public Nomen they() {
        if (this.has("plural")) {
            return new Nomen("they", true);
        }
        if (this.has("male")) {
            return new Nomen("he", false);
        }
        if (this.has("female")) {
            return new Nomen("she", false);
        }
        return new Nomen("it", false);
    }

    public Nomen cthey() {
        if (this.has("plural")) {
            return new Nomen("They", true);
        }
        if (this.has("male")) {
            return new Nomen("He", false);
        }
        if (this.has("female")) {
            return new Nomen("She", false);
        }
        return new Nomen("It", false);
    }

    public final Object get(Object object) {
        return this.properties.get(object);
    }

    public final boolean has(Object object) {
        if (object == null) {
            return false;
        }
        return this.properties.containsKey(object);
    }

    public final void put(Object object, Object object2) {
        if (object2 == null) {
            this.properties.remove(object);
        } else {
            this.properties.put(object, object2);
        }
    }

    public final void give(Object object) {
        this.properties.put(object, "t");
    }

    public final void remove(Object object) {
        this.properties.remove(object);
    }

    public boolean isSpecies(Object object) {
        return object.equals(this.get("species"));
    }

    public Concept findChild(Object object) {
        int n = 0;
        while (n < this.getNumChildren()) {
            Concept concept = this.getChild(n);
            if (concept.isSpecies(object)) {
                return concept;
            }
            ++n;
        }
        return null;
    }

    public int findChild(int n, Object object) {
        int n2 = n;
        while (n2 < this.getNumChildren()) {
            if (this.getChild(n2).isSpecies(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final void setParent(Concept concept) {
        if (this.parent != null) {
            this.parent.children.removeElement(this);
            this.parent = null;
        }
        if (concept != null) {
            if (concept.isWithin(this)) {
                throw new IllegalArgumentException("loop in Concept tree");
            }
            if (concept.children == null) {
                concept.children = new Vector();
            }
            concept.children.addElement(this);
            this.parent = concept;
        }
    }

    public final Concept getParent() {
        return this.parent;
    }

    public final boolean isIn(Concept concept) {
        return this.parent == concept;
    }

    public final boolean isWithin(Concept concept) {
        Concept concept2 = this;
        while (concept2 != concept) {
            if (concept2 == null) {
                return false;
            }
            concept2 = concept2.parent;
        }
        return true;
    }

    public final boolean isInside(Concept concept) {
        if (concept == null) {
            return false;
        }
        Concept concept2 = this.parent;
        while (concept2 != concept) {
            if (concept2 == null) {
                return false;
            }
            concept2 = concept2.parent;
        }
        return true;
    }

    public final int getNumChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public final Concept getChild(int n) {
        return (Concept)this.children.elementAt(n);
    }

    public final Vector getChildren() {
        if (this.children != null) {
            return (Vector)this.children.clone();
        }
        return new Vector();
    }

    public void scopeSingle(ScopeMethod scopeMethod) throws Refusal {
        scopeMethod.scopeMethod(this);
    }

    public void scopeAttachments(ScopeMethod scopeMethod) throws Refusal {
        int n = 0;
        while (n < this.getNumChildren()) {
            Concept concept = this.getChild(n);
            if (concept.has("attachment")) {
                concept.scopeSingle(scopeMethod);
                concept.scopeAttachments(scopeMethod);
                if (concept.isSeeThru()) {
                    concept.scopeWithin(scopeMethod);
                }
            }
            ++n;
        }
    }

    public void scopeWithin(ScopeMethod scopeMethod) throws Refusal {
        int n = 0;
        while (n < this.getNumChildren()) {
            Concept concept = this.getChild(n);
            if (!concept.has("attachment")) {
                concept.scopeSingle(scopeMethod);
                concept.scopeAttachments(scopeMethod);
                if (concept.isSeeThru()) {
                    concept.scopeWithin(scopeMethod);
                }
            }
            ++n;
        }
    }

    public boolean isSeeThru() {
        return this.has("transparent") || this.has("supporter") || this.has("container") && this.has("open");
    }

    public boolean isUnlisted() {
        return this.has("unlisted") || this.has("scenery") || this.has("attachment") || this.has("reach-hid");
    }

    public boolean isReachThru() {
        return this.has("supporter") || this.has("container") && this.has("open");
    }

    public boolean isGoThru() {
        return this.has("enterable") && this.isReachThru();
    }

    public boolean isStatic() {
        return this.has("static") || this.has("scenery");
    }

    public Concept getReachLevel() {
        Concept concept = this;
        while (concept.has("attachment")) {
            concept = concept.getParent();
        }
        return concept.getParent();
    }

    public static Nomen getList(Vector vector) {
        Nomen nomen = null;
        StringBuffer stringBuffer = null;
        int n = 0;
        while (n < vector.size()) {
            int n2 = Concept.collectSpecies(vector, n);
            Concept concept = (Concept)vector.elementAt(n);
            Nomen nomen2 = concept.getListItem(n2);
            if (nomen2 != null) {
                if (nomen != null) {
                    if (stringBuffer != null) {
                        stringBuffer.append(", ");
                    } else {
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(nomen);
                }
                nomen = nomen2;
            }
            n += n2;
        }
        if (stringBuffer == null) {
            return nomen;
        }
        stringBuffer.append(" and ");
        stringBuffer.append(nomen);
        return new Nomen(stringBuffer, true);
    }

    public Nomen getChildList() {
        return Concept.getList(this.getChildren());
    }

    public void printLook(Vicinity vicinity, int n) {
        if (n == 2) {
            return;
        }
        if (vicinity.isDark()) {
            if (n == 4) {
                vicinity.io.println("It's now too dark to see!");
            } else {
                vicinity.io.println("Darkness");
                vicinity.io.println("It's too dark to see anything!");
            }
            return;
        }
        if (vicinity.location == this) {
            vicinity.io.print(this.name());
        } else {
            vicinity.io.print(vicinity.ceiling.prepCIn());
        }
        Concept concept = vicinity.actor.getReachLevel();
        Object var4_4 = null;
        if (concept != this) {
            concept.give("reach-hid");
        }
        Concept concept2 = concept;
        while (concept2 != this) {
            vicinity.io.print(" (" + concept2.prepIn() + ")");
            concept2 = concept2.getReachLevel();
        }
        vicinity.io.println();
        if (this.has("roomdesc") && (n == 0 || !this.has("visited"))) {
            vicinity.io.println(this.get("roomdesc"));
        }
        this.give("visited");
        int n2 = 0;
        while (n2 < this.getNumChildren()) {
            this.getChild(n2).printInitial(vicinity.io);
            ++n2;
        }
        Nomen nomen = this.getChildList();
        if (nomen != null) {
            vicinity.io.println();
            vicinity.io.println("You see " + nomen + " here.");
        }
        if (concept != this) {
            concept.remove("reach-hid");
            concept.printReachSearch(vicinity.io);
        }
    }

    public Nomen getListItem(int n) {
        if (this.isUnlisted()) {
            return null;
        }
        if (this.isSeeThru()) {
            Nomen nomen = this.getChildList();
            String string = null;
            if (nomen != null) {
                string = this.has("supporter") ? "supporting " : (this.has("openable") ? (this.has("open") ? "open, containing " : "closed, containing ") : "containing ");
                string = string + nomen;
            } else if (this.has("openable") && this.has("container")) {
                string = this.has("open") ? "open and empty" : "closed and empty";
            }
            if (string != null) {
                nomen = this.indef();
                return new Nomen(nomen + " (" + string + ")", nomen.isPlural());
            }
        } else if (this.has("openable")) {
            String string = "closed";
            if (this.has("open")) {
                string = "open";
            }
            Nomen nomen = this.indef();
            return new Nomen(nomen + " (" + string + ")", nomen.isPlural());
        }
        return this.indef(n);
    }

    public void printInitial(IO iO) {
        Nomen nomen;
        if (this.has("supporter") && this.isUnlisted() && !this.has("reach-hid") && (nomen = this.getChildList()) != null) {
            iO.println();
            iO.println(this.prepCIn() + " " + nomen.pis() + ".");
        }
    }

    public void printReachSearch(IO iO) {
        Nomen nomen = this.getChildList();
        if (nomen != null) {
            iO.println();
            iO.println(this.prepCIn() + " " + nomen.pis() + ".");
        }
    }

    public boolean isLit() {
        return this.has("light");
    }

    public Vicinity getVicinity(IO iO) {
        Vicinity vicinity = new Vicinity();
        vicinity.io = iO;
        this.fillVicinity(vicinity);
        return vicinity;
    }

    public void fillVicinity(Vicinity vicinity) {
        vicinity.actor = this;
        Concept concept = this.getParent();
        while (concept.getParent() != null) {
            concept = concept.getParent();
        }
        vicinity.location = concept;
        concept = this;
        while ((concept = concept.getReachLevel()) != vicinity.location && concept.isSeeThru()) {
        }
        vicinity.ceiling = concept;
        try {
            vicinity.scopeLoop(new ScopeMethod(){

                public void scopeMethod(Concept concept) throws Refusal {
                    if (concept.isLit()) {
                        throw new Refusal();
                    }
                }
            });
            vicinity.ceiling = vicinity.actor;
        }
        catch (Refusal refusal) {
            // empty catch block
        }
    }

    public static int collectSpecies(Vector vector, int n) {
        Concept concept = (Concept)vector.elementAt(n);
        Object object = concept.get("species");
        if (object == null) {
            return 1;
        }
        int n2 = 1;
        int n3 = 1;
        while (n + n3 < vector.size()) {
            Concept concept2 = (Concept)vector.elementAt(n + n3);
            if (object.equals(concept2.get("species"))) {
                if (n3 > n2) {
                    vector.removeElementAt(n + n3);
                    vector.insertElementAt(concept2, n + n2);
                }
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public void identifyEvery(Factor factor) {
        if (!this.isUnlisted() && this.has("ID")) {
            factor.nominate(this);
        }
    }

    public void identify(Factor factor) {
        int n;
        int n2;
        String[] stringArray = (String[])this.get("ID");
        if (stringArray == null) {
            return;
        }
        boolean bl = false;
        String string = factor.getArticle();
        if (string != null) {
            n2 = 0;
            while (n2 < stringArray.length) {
                if (string.equalsIgnoreCase(stringArray[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        n2 = 0;
        factor.resetBody();
        block1: while (factor.hasMoreWords()) {
            string = factor.getNextWord();
            n = 0;
            while (n < stringArray.length) {
                if (string.equalsIgnoreCase(stringArray[n])) {
                    ++n2;
                    continue block1;
                }
                ++n;
            }
            break block1;
        }
        n = 0;
        Number number = (Number)this.get("ID-rank");
        if (number != null) {
            n = number.intValue();
        }
        factor.nominate(this, bl, n2, n);
    }

    public String prepIn() {
        String string = "in ";
        if (this.has("supporter")) {
            string = "on ";
        }
        return string + this.def();
    }

    public String prepCIn() {
        String string = "In ";
        if (this.has("supporter")) {
            string = "On ";
        }
        return string + this.def();
    }

    public String prepOutOf() {
        String string = "out of ";
        if (this.has("supporter")) {
            string = "off ";
        }
        return string + this.def();
    }

    public String prepInto() {
        String string = "into ";
        if (this.has("supporter")) {
            string = "onto ";
        }
        return string + this.def();
    }

    public void printSearchDesc(IO iO) {
        if (this.isSeeThru()) {
            if (this.has("supporter")) {
                Nomen nomen = this.getChildList();
                if (nomen != null) {
                    iO.println("On " + this.them() + " " + nomen.pis() + ".");
                } else {
                    iO.println("There's nothing on " + this.them() + ".");
                }
            } else {
                Nomen nomen = this.getChildList();
                if (nomen != null) {
                    iO.println("Inside " + this.them() + " " + nomen.pis() + ".");
                } else {
                    iO.println("There's nothing inside " + this.them() + ".");
                }
            }
        } else if (this.has("openable") && this.has("container")) {
            iO.println("You can't see inside " + this.def() + " since it's not open.");
        } else {
            iO.println("You find nothing unusual.");
        }
    }

    public void printItemDesc(IO iO) {
        if (this.has("itemdesc")) {
            iO.println(this.get("itemdesc"));
        } else if (this.isSeeThru()) {
            if (this.has("supporter")) {
                Nomen nomen = this.getChildList();
                if (nomen != null) {
                    iO.println("On " + this.them() + " " + nomen.pis() + ".");
                } else {
                    iO.println("There's nothing on " + this.them() + ".");
                }
            } else {
                Nomen nomen = this.getChildList();
                if (nomen != null) {
                    iO.println("Inside " + this.them() + " " + nomen.pis() + ".");
                } else {
                    iO.println("There's nothing inside " + this.them() + ".");
                }
            }
        } else if (this.has("openable") && this.has("container")) {
            iO.println("You can't see inside " + this.def() + " since it's not open.");
        } else if (this.has("switchable")) {
            String string = "off";
            if (this.has("on")) {
                string = "on";
            }
            iO.println(this.cthose().is() + " currently switched " + string + ".");
        } else {
            iO.println("Nothing unusual.");
        }
    }

    public static boolean isPlural(String string) {
        return plurals.containsKey(string);
    }

    public static void setPlural(String string) {
        plurals.put(string, "t");
    }

    public void checkGotoable(Action action) throws Refusal {
        Concept concept = action.vic.actor;
        if (!this.isWithin(concept)) {
            concept = concept.getReachLevel();
            while (!this.isWithin(concept)) {
                if (!concept.isGoThru()) {
                    throw new Rebuff("You can't get through " + concept.def() + ".");
                }
                concept = concept.getReachLevel();
            }
        }
        if (concept == null) {
            throw new Rebuff("You can't reach " + concept.def() + ".");
        }
        Concept concept2 = null;
        Concept concept3 = this;
        if (concept3 != concept) {
            concept3 = concept3.getReachLevel();
            while (!concept.isWithin(concept3)) {
                if (!concept3.isGoThru()) {
                    concept2 = concept;
                }
                concept3 = concept3.getReachLevel();
            }
            if (concept3 != concept && !concept.isReachThru()) {
                concept2 = concept;
            }
        }
        if (concept2 != null) {
            throw new Refusal("You can't get through " + concept2.def() + ".");
        }
    }

    public void checkReachable(Action action) throws Refusal {
        Concept concept = action.vic.actor;
        if (!this.isWithin(concept)) {
            concept = concept.getReachLevel();
            while (!this.isWithin(concept)) {
                if (!concept.isReachThru()) {
                    throw new Rebuff("You can't reach through " + concept.def() + ".");
                }
                concept = concept.getReachLevel();
            }
        }
        if (concept == null) {
            throw new Rebuff("You can't reach " + concept.def() + ".");
        }
        Concept concept2 = null;
        Concept concept3 = this;
        if (concept3 != concept) {
            concept3 = concept3.getReachLevel();
            while (!concept.isWithin(concept3)) {
                if (!concept3.isReachThru()) {
                    concept2 = concept3;
                }
                concept3 = concept3.getReachLevel();
            }
            if (concept3 != concept && !concept.isReachThru()) {
                concept2 = concept;
            }
        }
        if (concept2 != null) {
            throw new Refusal("You can't reach through " + concept2.def() + ".");
        }
    }

    public void checkTakable(Action action) throws Refusal {
        this.checkReachable(action);
        if (this == action.vic.actor) {
            throw new Rebuff("Cut that out!");
        }
        if (action.vic.actor.isInside(this)) {
            throw new Rebuff("You'll have to move into N-space to do that.");
        }
        if (this.isStatic()) {
            if (this.has("attachment")) {
                throw new Rebuff(this.cdef().is() + " apparently part of " + this.getParent().def() + ".");
            }
            throw new Rebuff("You can't pick up " + this.def() + ".");
        }
    }

    public void checkDropable(Action action) throws Refusal {
        if (!this.isInside(action.vic.actor)) {
            throw new Rebuff("But you aren't carrying " + this.def() + ".");
        }
        if (this.has("attachment")) {
            throw new Rebuff(this.cdef().is() + " apparently part of " + this.getParent().def() + ".");
        }
        if (!this.isIn(action.vic.actor)) {
            throw new Rebuff("You need to be holding " + this.def() + " before you can put " + this.them() + " down.");
        }
    }

    public void reactBefore(Action action) throws Refusal {
    }

    public void before(Action action) throws Refusal {
    }

    public void reactAfter(Action action) throws Refusal {
    }

    public void after(Action action) throws Refusal {
    }

    public void eachTurn(Vicinity vicinity) throws Refusal {
    }

    public void daemon(Vicinity vicinity) throws Refusal {
    }

    public void runDaemonList(Vicinity vicinity) throws Refusal {
        Vector vector = (Vector)this.get("daemon-list");
        int n = 0;
        while (n < vector.size()) {
            Concept concept = (Concept)vector.elementAt(n);
            concept.daemon(vicinity);
            ++n;
        }
    }

    public void addDaemon(Concept concept) {
        Vector<Concept> vector = (Vector<Concept>)this.get("daemon-list");
        if (vector == null) {
            vector = new Vector<Concept>();
            this.put("daemon-list", vector);
        }
        vector.addElement(concept);
    }

    public boolean isKey(Concept concept) {
        return concept.has(this.get("key"));
    }

    public Grammar getGrammar() {
        if (this.has("stopped")) {
            return (Grammar)this.get("stopped-grammar");
        }
        return (Grammar)this.get("grammar");
    }

    public void stopGame(IO iO, String string) throws Refusal {
        this.give("stopped");
        iO.println();
        iO.println("    ** " + string + " **");
        iO.println();
        throw new Refusal(this.get("stopped-message").toString());
    }
}

