/*
 * File: AdvObject.java
 * --------------------
 * This file defines a class that models an object in the
 * Adventure game.
 */

import acm.util.*;

import java.io.*;

/* Class: AdvObject */
/**
 * This class defines an object in the Adventure game.  An object is
 * characterized by the following properties:
 *
 * <ul>
 * <li>Its name, which is the noun used to refer to the object
 * <li>Its description, which is a string giving a short description
 * <li>The room number in which the object initially lives
 * </li>
 *
 * The external format of the objects file is described in the
 * assignment handout.  The comments on the methods exported by
 * this class show how to use the initialized data structure.
 */

public class AdvObject {

/* Method: getName() */
/**
 * Returns the object name, which is the word used to refer to it.
 *
 * @usage String name = obj.getName();
 * @return The name of the object
 */
	public String getName() {
		return objectName;
	}

/* Method: getDescription() */
/**
 * Returns the one-line description of the object.  This description
 * should start with an article, as in "a set of keys" or "an emerald
 * the size of a plover's egg."
 *
 * @usage String name = obj.getDescription();
 * @return The description of the object
 */
	public String getDescription() {
		return objectDescription;
	}


/* Method: getInitialLocation() */
/**
 * Returns the initial location of the object.
 *
 * @usage int roomNumber = obj.getInitialLocation();
 * @return The room number in which the object initially resides
 */
	public int getInitialLocation() {
		return objectLocation;
	}
// Returns whether or not the object can be taken by a player
	public boolean canMove() {
		return moveable;
	}
// Returns whether or not the object appears in the list of objects after the general 
//	description of each room room
	public boolean isVisible() {
		return visible;
	}
// Sets the visibility of an object. Used to make hidden objects visible, usually.
	public void setVisible(boolean flag) {
		visible = flag;
	}
// Sets whether an object can be picked up by the user
	public void setMoveable(boolean flag) {
		moveable = flag;
	}
/* Method: readFromFile(rd) */
/**
 * Reads the data for this object from the BufferedReader rd, which
 * must have been opened by the caller.  This method returns true
 * if the object initialization is successful; if there are no more
 * objects to read, readFromFile returns false without initializing
 * the current object. 
 *
 * @usage boolean ok = room.readFromFile(rd);
 * @param rd A bufferedReader open on the objects data file
 * @return true if an object is successfully read; false at end of file
 */
	public boolean readFromFile(BufferedReader rd) {
		try { 
			String line; 
			while (true) { 
				line = rd.readLine(); 
				if (line == null) return false; 
				if (line.length() > 0) break; 
			} 
			objectName = line; 
			while (true) {
				line = rd.readLine(); 
				if (line == null) return false; 
				if (line.length() > 0) break; 
			}
			objectDescription = line; 
			while (true) { 
				line = rd.readLine(); 
				if (line == null) return false; 
				if (line.length() > 0) break;
			}
			objectLocation = Integer.parseInt(line);
// Reads in the moveability of the object. If the line is "NOT," moveable is set to false. 
			while (true) { 
				line = rd.readLine(); 
				if (line == null) return false; 
				if (line.length() > 0) break;
			}
			if (line.equals("NOT")) {
				moveable = false;
			}
// Reads in the visibility of the object. If the line is "NOT," visible is set to false.
			while (true) { 
				line = rd.readLine(); 
				if (line == null) return false; 
				if (line.length() > 0) break;
			}
			if (line.equals("NOT")) {
				visible = false;
			}
			return true; 
		} catch (IOException ex) { 
			throw new ErrorException(ex); 
		} catch (NumberFormatException ex) { 
			throw new ErrorException("Illegal question number"); 
		} 	
	}

/* Private instance variables */

	String objectName;
	String objectDescription;
	int objectLocation;
	boolean moveable = true;
	boolean visible = true;
}

