/*
 * Decompiled with CFR 0.152.
 */
package acm.graphics;

import acm.graphics.DrawLineElement;
import acm.graphics.EndRegionElement;
import acm.graphics.FinalPathElement;
import acm.graphics.GObject;
import acm.graphics.GRectangle;
import acm.graphics.PathElement;
import acm.graphics.PathState;
import acm.graphics.PenImage;
import acm.graphics.SetColorElement;
import acm.graphics.SetLocationElement;
import acm.graphics.StartRegionElement;
import acm.util.Animator;
import acm.util.ErrorException;
import acm.util.MediaTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;

public class GPen
extends GObject {
    private static PathElement finalElement = new FinalPathElement();
    private Animator animator;
    private double xScale;
    private double yScale;
    private boolean regionOpen;
    private boolean regionStarted;
    private boolean penVisible = false;
    private ArrayList path = new ArrayList();
    private Image penImage;
    private int delayCount;
    private Color fillColor;

    public GPen() {
        this.animator = new Animator();
        this.setSpeed(1.0);
        this.erasePath();
    }

    public GPen(double x, double y) {
        this();
        this.setLocation(x, y);
    }

    public void erasePath() {
        this.path = new ArrayList();
        this.xScale = 1.0;
        this.yScale = 1.0;
        this.regionOpen = false;
        this.regionStarted = false;
        this.repaint();
    }

    public void setLocation(double x, double y) {
        if (this.regionStarted) {
            throw new ErrorException("It is illegal to move the pen while you are defining a filled region.");
        }
        super.setLocation(x, y);
        this.animator.delay();
    }

    public void drawLine(double dx, double dy) {
        double x = this.getX();
        double y = this.getY();
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            if (!this.regionStarted) {
                this.path.add(new SetLocationElement(x, y));
                this.regionStarted = this.regionOpen;
            }
            this.path.add(new DrawLineElement(dx, dy));
        }
        super.setLocation(x + dx, y + dy);
        this.animator.delay();
    }

    public final void drawPolarLine(double r, double theta) {
        double radians = theta * Math.PI / 180.0;
        this.drawLine(r * Math.cos(radians), -r * Math.sin(radians));
    }

    public void setColor(Color color) {
        if (this.regionStarted) {
            throw new ErrorException("It is illegal to change the color while you are defining a filled region.");
        }
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            this.path.add(new SetColorElement(color));
        }
        super.setColor(color);
    }

    public void setFillColor(Color color) {
        if (this.regionStarted) {
            throw new ErrorException("It is illegal to change the fill color while you are defining a filled region.");
        }
        this.fillColor = color;
    }

    public Color getFillColor() {
        return this.fillColor == null ? this.getColor() : this.fillColor;
    }

    public void startFilledRegion() {
        if (this.regionOpen) {
            throw new ErrorException("You are already filling a region.");
        }
        this.regionOpen = true;
        this.regionStarted = false;
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            this.path.add(new StartRegionElement(this.fillColor));
        }
    }

    public void endFilledRegion() {
        if (!this.regionOpen) {
            throw new ErrorException("You need to call startFilledRegion before you call endFilledRegion.");
        }
        this.regionOpen = false;
        this.regionStarted = false;
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            this.path.add(new EndRegionElement());
        }
        this.repaint();
    }

    public void showPen() {
        this.penVisible = true;
        this.repaint();
        this.animator.delay();
    }

    public void hidePen() {
        this.penVisible = false;
        this.repaint();
        this.animator.delay();
    }

    public boolean isPenVisible() {
        return this.penVisible;
    }

    public void setSpeed(double speed) {
        this.animator.setSpeed(speed);
    }

    public double getSpeed() {
        return this.animator.getSpeed();
    }

    public void scale(double sx, double sy) {
        this.xScale = sx;
        this.yScale = sy;
        this.repaint();
    }

    public void paint(Graphics g) {
        PathState state = new PathState();
        state.sx = this.xScale;
        state.sy = this.yScale;
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            int nElements = this.path.size();
            int i = 0;
            while (i < nElements) {
                PathElement element = (PathElement)this.path.get(i);
                element.paint(g, state);
                ++i;
            }
        }
        finalElement.paint(g, state);
        if (this.penVisible) {
            this.drawPen(g);
        }
    }

    public GRectangle getBounds() {
        PathState state = new PathState();
        GRectangle bounds = new GRectangle(-1.0, -1.0, -1.0, -1.0);
        state.sx = this.xScale;
        state.sy = this.yScale;
        ArrayList arrayList = this.path;
        synchronized (arrayList) {
            int nElements = this.path.size();
            int i = 0;
            while (i < nElements) {
                PathElement element = (PathElement)this.path.get(i);
                element.updateBounds(bounds, state);
                ++i;
            }
        }
        return bounds;
    }

    public boolean contains(double x, double y) {
        return false;
    }

    public void setPenImage(Image image) {
        this.penImage = MediaTools.loadImage(image);
    }

    public Image getPenImage() {
        if (this.penImage == null) {
            this.penImage = PenImage.getImage();
        }
        return this.penImage;
    }

    protected void drawPen(Graphics g) {
        Component comp = this.getComponent();
        if (comp == null) {
            return;
        }
        if (this.penImage == null) {
            this.penImage = PenImage.getImage();
        }
        int width = this.penImage.getWidth(comp);
        int height = this.penImage.getHeight(comp);
        int x = (int)Math.round(this.getX());
        int y = (int)Math.round(this.getY());
        g.drawImage(this.penImage, x - width / 2, y - height / 2, comp);
    }

    protected Rectangle getPenBounds() {
        Component comp = this.getComponent();
        if (comp == null) {
            return new Rectangle();
        }
        if (this.penImage == null) {
            this.penImage = PenImage.getImage();
        }
        int width = this.penImage.getWidth(comp);
        int height = this.penImage.getHeight(comp);
        int x = (int)Math.round(this.getX());
        int y = (int)Math.round(this.getY());
        return new Rectangle(x - width / 2, y - height / 2, width, height);
    }

    private Rectangle getAWTRectangle(double x, double y, double dx, double dy) {
        return new Rectangle((int)Math.min(x, x + dx), (int)Math.min(y, y + dy), (int)Math.abs(dx), (int)Math.abs(dy));
    }
}

