/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.util.ErrorException;
import acm.util.OptionTable;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Map;

public class TableConstraints
extends GridBagConstraints {
    public int width;
    public int height;
    private static final int MY_PAGE_START = 19;
    private static final int MY_PAGE_END = 20;
    private static final int MY_LINE_START = 21;
    private static final int MY_LINE_END = 22;
    private static final int MY_FIRST_LINE_START = 23;
    private static final int MY_FIRST_LINE_END = 24;
    private static final int MY_LAST_LINE_START = 25;
    private static final int MY_LAST_LINE_END = 26;
    protected static final String[] LEGAL_KEYS = new String[]{"anchor", "bottom", "colspan", "fill", "gridwidth", "gridheight", "gridx", "gridy", "height", "ipadx", "ipady", "left", "right", "rowspan", "top", "weightx", "weighty", "width"};

    public TableConstraints() {
        this("");
    }

    public TableConstraints(String str) {
        this(new OptionTable(str.toLowerCase(), LEGAL_KEYS));
    }

    public TableConstraints(Map map) {
        String colSpan;
        OptionTable constraintTable = map instanceof OptionTable ? (OptionTable)map : new OptionTable(map);
        this.gridx = this.parseXYConstraint(constraintTable.getOption("gridx"));
        this.gridy = this.parseXYConstraint(constraintTable.getOption("gridy"));
        String rowSpan = constraintTable.getOption("gridwidth");
        if (rowSpan == null) {
            rowSpan = constraintTable.getOption("rowspan");
        }
        if ((colSpan = constraintTable.getOption("gridheight")) == null) {
            colSpan = constraintTable.getOption("colspan");
        }
        this.gridwidth = this.parseSpanConstraint(rowSpan);
        this.gridheight = this.parseSpanConstraint(colSpan);
        this.fill = this.parseFillConstraint(constraintTable.getOption("fill"));
        this.anchor = this.parseAnchorConstraint(constraintTable.getOption("anchor"));
        this.ipadx = constraintTable.getIntOption("ipadx", 0);
        this.ipady = constraintTable.getIntOption("ipady", 0);
        this.weightx = constraintTable.getDoubleOption("weightx", 0.0);
        this.weighty = constraintTable.getDoubleOption("weighty", 0.0);
        this.insets.left = constraintTable.getIntOption("left", 0);
        this.insets.right = constraintTable.getIntOption("right", 0);
        this.insets.top = constraintTable.getIntOption("top", 0);
        this.insets.bottom = constraintTable.getIntOption("bottom", 0);
        this.width = constraintTable.getIntOption("width", 0);
        this.height = constraintTable.getIntOption("height", 0);
        if (this.gridwidth != 1 && this.width != 0) {
            throw new ErrorException("TableConstraints: Cannot specify both width and gridwidth");
        }
        if (this.gridheight != 1 && this.height != 0) {
            throw new ErrorException("TableConstraints: Cannot specify both height and gridheight");
        }
    }

    public TableConstraints(GridBagConstraints gbc) {
        this.gridx = gbc.gridx;
        this.gridy = gbc.gridy;
        this.gridwidth = gbc.gridwidth;
        this.gridheight = gbc.gridheight;
        this.fill = gbc.fill;
        this.anchor = gbc.anchor;
        this.ipadx = gbc.ipadx;
        this.ipady = gbc.ipady;
        this.weightx = gbc.weightx;
        this.weighty = gbc.weighty;
        this.insets.left = gbc.insets.left;
        this.insets.right = gbc.insets.right;
        this.insets.top = gbc.insets.top;
        this.insets.bottom = gbc.insets.bottom;
        if (gbc instanceof TableConstraints) {
            TableConstraints tc = (TableConstraints)gbc;
            this.width = tc.width;
            this.height = tc.height;
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getFill() {
        return this.fill;
    }

    public int getGridX() {
        return this.gridx;
    }

    public int getGridY() {
        return this.gridy;
    }

    public int getGridWidth() {
        return this.gridwidth;
    }

    public int getGridHeight() {
        return this.gridheight;
    }

    public int getIPadX() {
        return this.ipadx;
    }

    public int getIPadY() {
        return this.ipady;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public double getWeightX() {
        return this.weightx;
    }

    public double getWeightY() {
        return this.weighty;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        String str = this.getClass().getName();
        str = String.valueOf(str) + "[gridx=" + this.gridx + ",gridy=" + this.gridy;
        switch (this.fill) {
            case 3: {
                str = String.valueOf(str) + ",fill=VERTICAL";
                break;
            }
            case 2: {
                str = String.valueOf(str) + ",fill=HORIZONTAL";
                break;
            }
            case 1: {
                str = String.valueOf(str) + ",fill=BOTH";
            }
        }
        switch (this.anchor) {
            case 11: {
                str = String.valueOf(str) + ",anchor=NORTH";
                break;
            }
            case 15: {
                str = String.valueOf(str) + ",anchor=SOUTH";
                break;
            }
            case 13: {
                str = String.valueOf(str) + ",anchor=EAST";
                break;
            }
            case 17: {
                str = String.valueOf(str) + ",anchor=WEST";
                break;
            }
            case 12: {
                str = String.valueOf(str) + ",anchor=NORTHEAST";
                break;
            }
            case 18: {
                str = String.valueOf(str) + ",anchor=NORTHWEST";
                break;
            }
            case 14: {
                str = String.valueOf(str) + ",anchor=SOUTHEAST";
                break;
            }
            case 16: {
                str = String.valueOf(str) + ",anchor=SOUTHWEST";
                break;
            }
            case 19: {
                str = String.valueOf(str) + ",anchor=PAGE_START";
                break;
            }
            case 20: {
                str = String.valueOf(str) + ",anchor=PAGE_END";
                break;
            }
            case 21: {
                str = String.valueOf(str) + ",anchor=LINE_START";
                break;
            }
            case 22: {
                str = String.valueOf(str) + ",anchor=LINE_END";
                break;
            }
            case 23: {
                str = String.valueOf(str) + ",anchor=FIRST_LINE_START";
                break;
            }
            case 24: {
                str = String.valueOf(str) + ",anchor=FIRST_LINE_END";
                break;
            }
            case 25: {
                str = String.valueOf(str) + ",anchor=LAST_LINE_START";
                break;
            }
            case 26: {
                str = String.valueOf(str) + ",anchor=LAST_LINE_END";
            }
        }
        if (this.gridwidth != 1) {
            str = String.valueOf(str) + ",gridwidth=" + this.gridwidth;
        }
        if (this.gridheight != 1) {
            str = String.valueOf(str) + ",gridheight=" + this.gridheight;
        }
        if (this.ipadx != 0) {
            str = String.valueOf(str) + ",ipadx=" + this.ipadx;
        }
        if (this.ipady != 0) {
            str = String.valueOf(str) + ",ipady=" + this.ipady;
        }
        if (this.insets.left != 0) {
            str = String.valueOf(str) + ",left=" + this.insets.left;
        }
        if (this.insets.right != 0) {
            str = String.valueOf(str) + ",right=" + this.insets.right;
        }
        if (this.insets.top != 0) {
            str = String.valueOf(str) + ",top=" + this.insets.top;
        }
        if (this.insets.bottom != 0) {
            str = String.valueOf(str) + ",bottom=" + this.insets.bottom;
        }
        if (this.width != 0) {
            str = String.valueOf(str) + ",width=" + this.width;
        }
        if (this.height != 0) {
            str = String.valueOf(str) + ",height=" + this.height;
        }
        str = String.valueOf(str) + "]";
        return str;
    }

    private int parseXYConstraint(String str) {
        if (str == null) {
            return -1;
        }
        if (str.equals("relative")) {
            return -1;
        }
        try {
            return Integer.decode(str);
        }
        catch (NumberFormatException ex) {
            throw new ErrorException("TableConstraints: Illegal grid coordinate");
        }
    }

    private int parseSpanConstraint(String str) {
        if (str == null) {
            return 1;
        }
        if (str.equals("relative")) {
            return -1;
        }
        if (str.equals("remainder")) {
            return 0;
        }
        try {
            return Integer.decode(str);
        }
        catch (NumberFormatException ex) {
            throw new ErrorException("TableConstraints: Illegal span constraint");
        }
    }

    private int parseAnchorConstraint(String str) {
        if (str == null) {
            return 10;
        }
        if (str.equals("center")) {
            return 10;
        }
        if (str.equals("north")) {
            return 11;
        }
        if (str.equals("south")) {
            return 15;
        }
        if (str.equals("east")) {
            return 13;
        }
        if (str.equals("west")) {
            return 17;
        }
        if (str.equals("northeast") || str.equals("ne")) {
            return 12;
        }
        if (str.equals("northwest") || str.equals("nw")) {
            return 18;
        }
        if (str.equals("southeast") || str.equals("se")) {
            return 14;
        }
        if (str.equals("southwest") || str.equals("sw")) {
            return 16;
        }
        if (str.equals("page_start")) {
            return 19;
        }
        if (str.equals("page_end")) {
            return 20;
        }
        if (str.equals("line_start")) {
            return 21;
        }
        if (str.equals("line_end")) {
            return 22;
        }
        if (str.equals("first_line_start")) {
            return 23;
        }
        if (str.equals("first_line_end")) {
            return 24;
        }
        if (str.equals("last_line_start")) {
            return 25;
        }
        if (str.equals("last_line_end")) {
            return 26;
        }
        throw new ErrorException("TableConstraints: Illegal anchor specification");
    }

    private int parseFillConstraint(String str) {
        if (str == null || str.equals("none")) {
            return 0;
        }
        if (str.equals("horizontal")) {
            return 2;
        }
        if (str.equals("vertical")) {
            return 3;
        }
        if (str.equals("both")) {
            return 1;
        }
        throw new ErrorException("TableConstraints: Illegal fill specification");
    }
}

