package mechanique;

 

/*    
    
    MechaniQue, the programming language for Interactive Fiction
    Copyright (C) 2008  G.J.G.T. (Gabor) de Mooij

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation (highest version applies !!).

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
    ---MECHANIQUESOFT/GABOR DE MOOIJ

*/
 
import java.io.*;
import java.util.*;
import java.util.regex.*;
import java.applet.*;
import java.io.Serializable;
import java.lang.Math;
;
public class ManagerFacade
{
    private Printable GUI = new Terminal();
    private String StoryFileName;
    private String ParserFileName;
    private StoryInterface webstory;
    private Website website;
        
    public void compileStory(String fileName,String parserName)
    {
        if (!fileName.endsWith(".book"))
        {
            toolbox.say("Invalid file extension. Use .book");
            System.exit(0);
        }
            
        StoryFactory sf = new StoryFactory((Commandline) new Terminal());
        StoryInterface s = sf.make(toolbox.fromFile(fileName));
        if (!parserName.equals(""))
        {
            toolbox.say("Found parser:"+parserName);
            ParserFactory pf = new ParserFactory();
            Parser p = pf.make(toolbox.fromFile(parserName));
            s.setParser(p);
        }
        
        toolbox.serialize(fileName.replace(".book",".roll"),(Story) s);
        toolbox.say("Compiled...");
    }
    
	public void runXBookStory(String fileName, boolean debugMode, Printable term)
	{
	
		if (!fileName.endsWith(".xbook"))
        {
            toolbox.say("Invalid file extension. Use .xbook");
            System.exit(0);
        }
		
		String newSource = toolbox.rot13(toolbox.fromFile(fileName));
			
		
		String[] parts = newSource.split("###%%%BOUNDARY%%%###");
		
		//toolbox.toFile("test.txt",newSource);
		
		StoryFactory sf = new StoryFactory((Commandline) new Terminal());
        StoryInterface s = sf.make(parts[0]);
        if (parts.length > 1)
        {
            toolbox.say("Found parser in XBook...");
            ParserFactory pf = new ParserFactory();
            Parser p = pf.make(parts[1]);
            s.setParser(p);
        }
        
        //toolbox.serialize(fileName.replace(".book",".roll"),(Story) s);
        toolbox.say("Compiled...");
        
        toolbox.say("Prepare to Run XBook.. ");
		
        if (debugMode) s.setDebugFlag(true);
        s.setDisplayUnit(term);
            
        term.print("user interface created.. -------------;-)");
        
        s.run(false);
        
        term.print("--------------------------------------;-)");
        term.print("Thanks for playing, Bye..!");
		
	
	}
	
	
    public void obfuscateStory(String fileName,String parserName)
	{
		if (!fileName.endsWith(".book"))
        {
            toolbox.say("Invalid file extension. Use .book");
            System.exit(0);
        }
		
		String bookSource = toolbox.fromFile(fileName);
		String parserSource = "";
		
		if (!parserName.equals("")) 
		{
			parserSource = toolbox.fromFile(parserName);
		}
		
		String totalSource = bookSource + "###%%%BOUNDARY%%%###" + parserSource;
		
		//Obfuscator o = new Obfuscator(totalSource);
		
		toolbox.toFile(fileName.replace(".book","")+".xbook",toolbox.rot13(totalSource));
		
		  		
		toolbox.say("Obfuscated... ");
		
	}
    
    public void runStory(String fileName, boolean debugMode, Printable term)
    {
    
        if (!fileName.endsWith(".roll"))
        {
            toolbox.say("Invalid file extension. Use .roll");
            System.exit(0);
        }
        
        StoryInterface s = (StoryInterface) toolbox.deserialize(fileName);
        
        toolbox.say(fileName+" loaded..");
        if (debugMode) s.setDebugFlag(true);
        
        
        s.setDisplayUnit(term);
     
        
        term.print("user interface created.. -------------;-)");
        
        s.run(false);
        
        term.print("--------------------------------------;-)");
        term.print("Thanks for playing, Bye..!");
    }
    
    public void tellStory(String fileName)
    {
    
        if (!fileName.endsWith(".roll"))
        {
            toolbox.speak("Invalid file extension. Use .roll");
            System.exit(0);
        }
        
        StoryInterface s = (StoryInterface) toolbox.deserialize(fileName);
                
        s.setDisplayUnit(new SpeechDecorator(new Terminal()));
        
        s.run(false);
        toolbox.speak("exit. Thanks for playing.");
       
    }
    
    
    public void continueStory(String fileName)
    {
    
        StoryInterface s = (StoryInterface) toolbox.deserialize(fileName);
        toolbox.say(fileName+" loaded..");
                
        s.setDisplayUnit(new Terminal());
        
        toolbox.say("Story RELOADED ;-)");
        
        s.run(true);
        
        Commandline term = new Terminal();
       // term.print("--------------------------------------;-)");
       // term.print("Thanks for playing, Bye..!");
    }
    
    public void compileAndRun(String text, String parser, m2a program, boolean audio)
    {
        this.website = new Website(program,audio);
        StoryFactory sf = new StoryFactory((Commandline) this.website);
        
        this.webstory = sf.make(text);
        
        if (!parser.equals(""))
        {
            ParserFactory pf = new ParserFactory();
            Parser p = pf.make(parser);
            this.webstory.setParser(p);
        }
        
        this.webstory.setDisplayUnit(this.website);
        this.webstory.run(false);
      
    }
    
    public void setAnswer(String s)
    {
        this.website.answer(s);
    }
    
 
    public void showInfo()
    {
        toolbox.say("MechaniQue/J 2.0.4  Compiler Version 0.2008Q2 ");
        toolbox.say("USAGE:");
        toolbox.say("COMPILE   : java m2 -o <bookfile> [optional parserfile]");
	    toolbox.say("PLAY xbook: java m2 -p <xbookfile> ");
        toolbox.say("COMPILE   : java m2 -c <bookfile> [optional parserfile]");
        toolbox.say("PLAY      : java m2 -r <rollfile> ");
        toolbox.say("AUDIO     : java m2 -s <rollfile> ");
        toolbox.say("AUD.xbook : java m2 -sp <rollfile> ");
        toolbox.say("LOAD GAME : java m2 -l <rollfile> ");
        toolbox.say("DEBUG     : java m2 -d <rollfile> ");
        toolbox.say("MechaniQue2/J has been written by Gabor de Mooij GPL3 LICENSE.");
        
    }
    
}
