class AR::Events::CharacterTalked < AR::Events::Event

  attr_participant :character
  attr_accessor :speech

  def initialize params
    super params
    self.speech = params[:speech]
  end 

  def resolve!
    self.engine.world.player.printer.new_line!
  end

  def story
    "#{character.name.split(" ").map(&:capitalize).join(" ")}: #{speech}"
  end


end
