module AR::Game::Dexterity 
  
  #add attr_accessor properties here... 
  #if you don't need them serialized on save

  #...initialize them here
  def self.init ar_object 
    ar_object.register_gauge "dexterity"
    ar_object.register_gauge "avoidance"
    ar_object.register_gauge "accuracy"
    ar_object.after_gauges_init do |obj|
      dex = obj.gauge("dexterity")
      av = obj.gauge("avoidance")
      acc = obj.gauge("accuracy")
      dex.parents! av, with: AR::Game::GaugeBehavior::LinearGaugeRelation, data: {factor: 2}
      dex.parents! acc, with: AR::Game::GaugeBehavior::LinearGaugeRelation, data: {factor: 2}
      dex.change_current_and_max 1
      dex.manual_child_sync
    end
  end


  def self.extended ar_object
    self.init ar_object
    
    #add to object's event subscriptions and resolutions here...

  end 


  #add more methods here

end
