class AR::Events::NarrationEvent < AR::Events::Event

  attr_accessor :narration
  attr_accessor :new_paragraph

  def initialize params
    super params
    self.narration = params[:narration]
    self.new_paragraph = params[:new_paragraph]
  end 

  def story
    self.narration
  end

  def resolve!
    if new_paragraph
      engine.world.player.printer.new_paragraph!
    end
    nil
  end 

end
