module AR
  module Game

    class Forest05 < Scene
      def initialize id=nil
        super 
        self.noun = "forest"
        self.add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "Birds fly across your field of vision, singing as you walk in between old willow trees."
            else 
              ret = ""
            end
            ret 

          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The trees in this area seem old and wise, shaggy as they are. To the north, there is a calm brook that bubbles below an embankment."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end

      end

    end


  end
end
