
module AR
  module Game

    class PoisonousRedShroom < Item
      def initialize id=nil
        super 
        self.noun = "red mushroom"
        self.add_story_implement StoryImplement.new

        #poison on picked up
        r = AR::Events::Resolution.new event_class: AR::Events::ItemAddedToInventory, as: "item" do |e|
          c = e.inventory_owner
          buff = PoisonBuff.new.subscribe!
          buff.strength = rand(1..3)
          buff.character = c
          AR::Events::BuffApplied.new buff: buff, subject: c
        end

        self.resolutions << r
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories = []
          super
          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              if e.discovered.parent.class == AR::Game::MoldyLog
                ret = "There is a particularly large mushroom in the patch."
              else
                ret = "#{e.discovered.placement.capitalize}, you discover a red mushroom."
              end
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story = Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              "Its cap is about 3 inches in diameter, and is crimson red.  At a closer look, you see rough, white specks on the cap."
            end
          end
          add_story story
        end

      end

    end



  end
end

