module AR
  module Game

    class BodyArmor < PieceOfEquipment 
      attr_accessor :armor_rating
      attr_accessor :avoidance_penalty
      def initialize id=nil
        super 


        self.armor_rating  = 0
        self.avoidance_penalty = 0

        penalty  = AR::Game::GaugeBehavior::Modifier.new source: "armor_avoidance_penalty"
        armor_bonus = AR::Game::GaugeBehavior::Modifier.new source: "armor_resist_bonus"


        self.on_equipped = Proc.new do |equipper|
          armor_bonus.value = self.armor_rating
          penalty.value = -self.avoidance_penalty
          resist = equipper.gauge("damage_resist")
          avoidance = equipper.gauge("avoidance")

          resist.add_modifier armor_bonus
          avoidance.add_modifier penalty 

          nil
        end

        self.on_unequipped = Proc.new do |equipper|
          resist = equipper.gauge("damage_resist")
          avoidance = equipper.gauge("avoidance")

          resist.rem_modifier armor_bonus
          avoidance.rem_modifier penalty
          nil
        end


        add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end
      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          #add stories like this:
          #s = Story.new when: AR::Events::Event, as: "participant" do |e|
          #end
          #add_story s
        end
      end

    end



  end
end
