require_relative "../classes.rb"

class TestGaugeBehavior < BaseBehaviorTestCase

  def setup
    super
    @gauge = AR::Game::Gauge.new
    @gauge2 = AR::Game::Gauge.new
    @gauge.change_current_and_max 10
    @gauge.manual_child_sync

    #parent the gauge 2
    @gauge.parents! @gauge2, with: AR::Game::GaugeBehavior::LinearGaugeRelation, data: {factor: -1}
  end

  def test_gauge_children_ids_include_child
    assert @gauge.children_ids.include? @gauge2.id
  end

  def test_cant_change_gauge_value_outside_min_max
    min = -@gauge.modifier_total
    max = @gauge.modified_max
    @gauge.change_current 20000
    assert_equal max, @gauge.modified_current
    @gauge.change_current -200000
    assert_equal min, @gauge.modified_current
  end



  def test_gauge_value_changes_after_gauge_changed
    prev_val = @gauge.value
    e = AR::Events::GaugeChanged.new gauge: @gauge, change: 2
    e.resolve!
    assert_equal prev_val + 2, @gauge.value
  end


  def test_gauge_releases_gauge_change_for_children
    prev_value = @gauge2.modified_value

    e = AR::Events::GaugeChanged.new gauge: @gauge, change: 2 
    results = e.resolve!
    e = results.first

    #should be the modifier of the child
    assert_not_nil e.modifier
    e.resolve!
    assert_equal prev_value - 2, @gauge2.modified_value 
  end

  def test_gauge_can_load_and_unload
    d1 = world.unload_data
    world.save_to_file world.world_name
    d = File.open("saves/test_world_data.yml", "r").read

    d = Psych.load(d).to_hash
    d = AR.recursive_symbolize(d)
    world.load_data d

    e = AR::Events::GaugeChanged.new gauge: @gauge, change: -2 
    results = e.resolve!
    assert results.map(&:class).include? AR::Events::GaugeChanged
  end


end

