module AR
  module Game

    class BeetleCorpse < LootableThing
      def initialize id=nil
        super 
        self.noun = "giant beetle corpse"
        self.add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories = []
          super
          s =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "The beetle leaves behind it's large, lifeless body."
            else 
              ret = ""
            end
            ret 
          end
          add_story s

          s = Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              if e.discoverable.inventory_item_ids.empty?
                "All that remains are the useless bits of the antannae and joints."
              else
                "The husk of the beetle is very strong, and might be fashioned into tools.  In addition, the meat of it might be edible."
              end
            end
          end
          add_story s

 
        end
      end

    end



  end
end
