module AR
  module Game

    class Cave02PassageEast < PhysicalObject 
      def initialize id=nil
        super 
        self.noun = "passage east (deeper into the cavern)"
        add_behavior Gateway
        add_story_implement StoryImplement.new
        self.discovery_threshold = 3
        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...

      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement

        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The passage goes deeper into the cavern.  The opening is only about 4 feet, so you will need to crouch down to get through."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "On the east wall of the chamber, you notice a short passage leading into another chamber of the cave."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::ARObjectTravelledEvent, as: "gateway" do |e|
            if e.traveller == e.engine.world.player
              ret = "You crouch down and crawl through the shallow space, you try not to burn yourself with your torch. As the entrance widens, it seems as though the edges of the passage are beginning to stick to you.  To your horror, it is the web of a spider that is catching your skin."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end#initialize

      end#StoryImplement



    end#Gateway class



  end#Game
end#AR
