module AR
  module Game

    class Skeleton < Scene

      def initialize id=nil
        super 
        self.noun = "dry skeleton"
        self.discovery_threshold = 2
        add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories = []
          super

          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "#{e.discovered.placement.capitalize}, a dry, motionless skeleton sits with it's jaw wide open."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story = Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              "This skeleton must have been here for ages.  The bones are black, and moldy."
            end
          end
          add_story story
        end
      end

    end



  end
end
