module AR
  module Game
    class SiaslWorld < World
      def initialize id=nil
        super 
        instantiate_game_objects do |world|
          p = Player.new "player"

          c = Clearing.new "clearing"

          initial_scene = forest = Forest.new "forest"

          w = AR::Game::Window.new "inn_window"
          door_inside = AR::Game::Door.new "inn_door_leading_in"
          blocker = AR::Game::GuardPike.new "guard_block"
          inn = AR::Game::Inn.new "inn"

          h = AR::Game::Horsey.new "your_horse"
          sword = AR::Game::Sword.new "sword"
          h_clone = AR::Game::Horsey.new "your_horse_clone"
          guard = AR::Game::Guard.new "inn_guard"

          trees = AR::Game::Trees.new "forest_trees"
          branches = AR::Game::Branches.new "branches"
          shadows = AR::Game::Shadows.new "shadows"
          path_to_clearing = AR::Game::PathToClearing.new "path_to_clearing"
          path_to_clearing.destination = c 
          path_to_darkness = AR::Game::PathToDarkness.new "path_to_darkness"


          forest.add_inhabitant(branches, "at the top of the trees") 
          forest.add_inhabitant(shadows, "behind some trees")
          forest.add_inhabitant(sword, "lying on the ground")

          forest.add_inhabitant(path_to_darkness, "behind you, fading into the harsh belly of forest")
          forest.add_inhabitant(path_to_clearing, "ahead of you, broadening toward the clearing.")
          c.add_inhabitant(w, "on the inn")
          c.add_inhabitant(h, "next to you")
          c.add_inhabitant(door_inside, "leading into the inn")  
          c.add_inhabitant(guard, "by the door")  
          door_inside.destination = inn
          door_inside.add_blocker blocker, "in front of the door"

          forest.add_inhabitant(h_clone, "next to you")


          e = AR::Events::ARObjectEnteredInhabitableEvent.new placement: "on a narrow path in the thicket", enterer: world.player, inhabitable: forest
          world.new_game_event = e
        end 
 
      end


    end
  end
end



