require "./lib/apocrodentia"
require "test/unit"

class TestInhabitant < BaseBehaviorTestCase 

  def setup
    super
    @char = Traveller.new
    @char2 = Traveller.new
    @char.known_object_ids.push @char2.id
    @any_old_thing = AR::Game::ARObject.new
    @char.known_object_ids.push @any_old_thing.id
    @test_data = {parent_id: "tFj Amjfa uas!"}
  end


  def test_character_known_objects_is_reset_on_travelled_event
     
    evt = AR::Events::ARObjectEnteredInhabitableEvent.new enterer: @char, inhabitable: @any_old_thing
    results = evt.resolve!

    expected = results.select{|e| e.class == AR::Events::DiscoveryLostEvent}.first

    assert_equal @char2, expected.undiscovered
  end
end
