/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.List;
import java.util.stream.Collectors;

public class PutCommand
extends AbstractCommand {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0) {
            return null;
        }
        if (!words[0].toLowerCase().equals("put")) {
            return null;
        }
        if (words.length == 1) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        int idx = 1;
        Frame frame = context.simulation.getCurrentFrame();
        List<Noun> accessibleNouns = this.getAccessibleNouns(context);
        List<TextMatcher.ResultWithData<Noun>> thingToPutResults = PutCommand.matchOne(words, idx, accessibleNouns, context.player, frame);
        if (thingToPutResults.isEmpty()) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        List results = thingToPutResults.stream().map(result -> this.parseStartingWithPreposition(words, idx + result.getNumWordsMatched(), (Noun)result.data, context)).filter(result -> result != null).collect(Collectors.toList());
        if (results.isEmpty()) {
            Noun thingToPutRepresentative = (Noun)thingToPutResults.get((int)0).data;
            return ActionsAndHints.hint("Where are you trying to put " + NounPhraseWithArticle.the(thingToPutRepresentative.getDefaultPerception(frame)) + "?");
        }
        ActionsAndHints allResults = new ActionsAndHints();
        allResults.addAll(results);
        return allResults;
    }

    private ActionsAndHints parseStartingWithPreposition(String[] words, int idx, Noun nounToPut, Command.Context context) {
        if (idx >= words.length) {
            return null;
        }
        Frame frame = context.simulation.getCurrentFrame();
        String maybePreposition = words[idx].toLowerCase();
        List<Preposition> allPrepositions = Prepositions.getAllPrepositions();
        List matches = allPrepositions.stream().filter(prep -> prep.toString().equals(maybePreposition.toString())).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            throw new IllegalStateException("MORE THAN ONE PREPOSITION WITH SAME STRING?!?!");
        }
        Preposition matchingPreposition = (Preposition)matches.get(0);
        if (++idx >= words.length) {
            return null;
        }
        List<Noun> accessibleNouns = this.getAccessibleNouns(context);
        accessibleNouns.remove(nounToPut);
        List<TextMatcher.ResultWithData<Noun>> spotToPutResults = PutCommand.matchOne(words, idx, accessibleNouns, context.player, frame);
        if (spotToPutResults.isEmpty()) {
            return null;
        }
        ActionsAndHints resultsAndHints = new ActionsAndHints();
        int fIdx = idx;
        spotToPutResults.forEach(result -> {
            if (fIdx + result.getNumWordsMatched() == words.length) {
                resultsAndHints.addAction(new Result(nounToPut, matchingPreposition, (Noun)result.data, context));
            }
        });
        return resultsAndHints;
    }

    private List<Noun> getAccessibleNouns(Command.Context context) {
        return context.player.getPerceivableNouns(context.simulation.getCurrentFrame());
    }

    @Override
    public String getHelpString() {
        return "The 'put' command lets you explicitly place objects.  Examples include 'put key in lock', 'put gold on scale', 'put wood in lean-to'.  In general, 'put <thing> <preposition> <spot>'.  Use your imagination.";
    }

    @Override
    public String getNameString() {
        return "put";
    }

    @Override
    public String getPurposeString() {
        return "Put something somewhere.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    public static final class Result
    implements UserAction {
        private final Noun nounToPut;
        private final Preposition preposition;
        private final Noun spotToPutIt;
        private final Command.Context context;

        public Result(Noun nounToPut, Preposition preposition, Noun spotToPutIt, Command.Context context) {
            this.nounToPut = nounToPut;
            this.preposition = preposition;
            this.spotToPutIt = spotToPutIt;
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to put " + this.nounToPut.getContextFreeDescription() + " " + this.preposition + " " + NounPhraseWithArticle.a(this.spotToPutIt.getContextFreeDescription());
        }

        @Override
        public void execute(TextAppController controller) {
            InventoryState.requestRemoveItem(this.context.player, this.nounToPut, this.context.simulation);
            PositionState.requestPlayerPut(this.context.player, this.nounToPut, this.preposition, this.spotToPutIt, this.context.simulation);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

