/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.capability;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.AbstractCapabilityState;
import com.fabriziopolo.textcraft.states.capability.Capability;
import com.fabriziopolo.textcraft.states.capability.ResourceStateBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ResourceState
extends AbstractCapabilityState {
    @Override
    protected Class getStateKey() {
        return ResourceState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        ResourceStateBuilder builder = ResourceState.builder(this);
        builder.applyUpdates(simulation);
        return builder.build();
    }

    public static ResourceState get(Frame frame) {
        return (ResourceState)frame.states.get(ResourceState.class);
    }

    public static ResourceStateBuilder builder() {
        return new ResourceStateBuilder();
    }

    public static ResourceStateBuilder builder(ResourceState ResourceState2) {
        ResourceStateBuilder builder = new ResourceStateBuilder();
        ResourceState2.copyStateToBuilder(builder);
        return builder;
    }

    public static void requestAddCapability(Noun resource, Capability capability, Simulation simulation) {
        ResourceState resourceState = ResourceState.get(simulation.getCurrentFrame());
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        capabilities.add(capability);
        resourceState.requestChange(simulation, resource, capabilities);
    }

    public static boolean resourceSatisfiesCapability(Noun resource, Capability capability, Frame frame) {
        return ResourceState.get(frame).itemSatisfiesCapability(resource, capability, frame);
    }

    public static <T extends Capability> List<T> getSatisfyingInstances(Noun noun, T requirement, Frame frame) {
        List<Capability> capabilities = ResourceState.get(frame).getCapabilities(noun);
        if (capabilities == null) {
            return new ArrayList();
        }
        return capabilities.stream().filter(capability -> requirement.getClass().isAssignableFrom(capability.getClass())).map(capability -> capability).filter(capability -> requirement.isSatisfiedBy((Noun)noun, (Capability)capability, (Frame)frame).isSatisfied).collect(Collectors.toList());
    }
}

