/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.takeable;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.objects.GroupedCollectionNoun;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.encumbrance.EncumbranceState;
import com.fabriziopolo.textcraft.states.inventory.InventoryAddItemsRequest;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.structure.StructureAlgorithms;
import com.fabriziopolo.timecraft.world.constants.Encumbrances;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public interface TakeHandler
extends Serializable {
    default public void handleTake(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        Frame frame = simulation.getCurrentFrame();
        if (!this.isProducible(player, nounToTake, tool, frame)) {
            this.onNotProducible(player, nounToTake, tool, simulation, partialState);
            return;
        }
        List<Noun> nounsProduced = this.willProduce(player, nounToTake, tool, simulation, partialState);
        if (!this.isConsumableOrHandleNot(player, nounsProduced, tool, simulation)) {
            return;
        }
        this.doProduce(player, nounToTake, nounsProduced, tool, simulation, partialState);
        this.consume(player, nounsProduced, tool, simulation, partialState);
    }

    default public boolean isProducible(Player player, Noun nounToTake, Noun tool, Frame frame) {
        return !PositionState.get(frame).getDesendentsOf(nounToTake).contains(player);
    }

    default public void onNotProducible(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        PlayerNotificationEvent.post((Noun)player, simulation, "You cannot take " + NounPhraseWithArticle.the(player.getPerceptionOf(nounToTake, simulation.getCurrentFrame())) + ".");
    }

    default public Noun willProduceOne(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        return nounToTake;
    }

    default public void onDoProduceHandleChildren(Player player, Noun tool, Simulation simulation, PositionStateBuilder partialState, Noun nounToTake) {
        Frame frame = simulation.getCurrentFrame();
        Set<Noun> nonintegralChildren = StructureAlgorithms.getNonintegralChildren(nounToTake, frame);
        partialState.putNounsWhereThingIs(nonintegralChildren, nounToTake, frame);
    }

    default public List<Noun> willProduce(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        ArrayList<Noun> nounsToTake = new ArrayList<Noun>();
        nounsToTake.add(this.willProduceOne(player, nounToTake, tool, simulation, partialState));
        return nounsToTake;
    }

    default public void doProduce(Player player, Noun originalNounToTake, List<Noun> producedNouns, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        this.onDoProduceHandleChildren(player, tool, simulation, partialState, originalNounToTake);
        producedNouns.forEach(nounToTake -> partialState.disconnect((Noun)nounToTake));
    }

    default public boolean isConsumableOrHandleNot(Player player, List<Noun> nounsToTake, Noun tool, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        double encumbrance = InventoryState.getEncumbrance(player, frame);
        double totalEncumbranceOfItems = nounsToTake.stream().mapToDouble(item -> EncumbranceState.get(item, frame)).sum();
        GroupedCollectionNoun nounsAsOne = new GroupedCollectionNoun(nounsToTake);
        if (totalEncumbranceOfItems > Encumbrances.MAX) {
            PlayerNotificationEvent.post((Noun)player, simulation, "You are not physically capable of taking " + NounPhraseWithArticle.a(nounsAsOne.getDefaultPerception(frame)) + ".");
            return false;
        }
        if (encumbrance + totalEncumbranceOfItems > Encumbrances.MAX) {
            PlayerNotificationEvent.post((Noun)player, simulation, "You are carrying too much to take " + NounPhraseWithArticle.a(nounsAsOne.getDefaultPerception(frame)) + ".");
            return false;
        }
        return true;
    }

    default public void consume(Player player, List<Noun> nounsToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        nounsToTake.forEach(noun -> InventoryAddItemsRequest.post(player, noun, simulation));
    }
}

