/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByCategoryPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiControl.OutputOptionDialogControl;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiLib.GridBag;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OutputOptionDialog
extends JDialog {
    private static final long serialVersionUID = 5L;
    private static int FORMAT_SIZE = 4;
    public static final int LEXICAL_RECORD_FORMAT = 0;
    public static final int BASE_FORMAT = 1;
    public static final int SPELLING_VARS_FORMAT = 2;
    public static final int INFLECTION_VARS_FORMAT = 3;
    private static JRadioButton[] formatRb_ = new JRadioButton[FORMAT_SIZE];
    private static ButtonGroup formatBGroup_ = null;
    private static JComboBox[] formatCb_ = new JComboBox[FORMAT_SIZE];
    private static JCheckBox[] categoryCb_ = new JCheckBox[11];
    public static final String B_OK = "OK";
    public static final String B_CANCEL = "CANCEL";
    public static final String B_RESET = "RESET";
    public static final String B_CLEAR_CATEGORY = "CLEAR_CATEGORY";
    public static final String B_ALL_CATEGORY = "ALL_CATEGORY";
    public static final String B_DEFAULT = "DEFAULT";
    private static JButton okB_ = new JButton("Ok");
    private static JButton cancelB_ = new JButton("Cancel");
    private static JButton resetB_ = new JButton("Reset");
    private static JButton clearCategoryB_ = new JButton("Clear All");
    private static JButton allCategoryB_ = new JButton("Select All");
    private static JButton defaultB_ = new JButton("Default");
    private OutputOptionDialogControl outputOptionDialogControl_ = null;

    public OutputOptionDialog(LaFrame owner) {
        this.InitGuiControllers(owner);
    }

    public static JDialog GetDialog(LaFrame owner) {
        JDialog outputOptionDialog = new JDialog();
        outputOptionDialog.setModal(true);
        outputOptionDialog.setLocationRelativeTo(owner);
        outputOptionDialog.setSize(550, 330);
        outputOptionDialog.add((Component)OutputOptionDialog.CreateFormatPanel(), "North");
        outputOptionDialog.add((Component)OutputOptionDialog.CreateFilterPanel(), "Center");
        outputOptionDialog.add((Component)OutputOptionDialog.CreateButtonPanel(), "South");
        return outputOptionDialog;
    }

    public static void SetFont(Font font, Font guiFont) {
        int i;
        for (i = 0; i < FORMAT_SIZE; ++i) {
            formatRb_[i].setFont(guiFont);
            formatCb_[i].setFont(guiFont);
        }
        for (i = 0; i < 11; ++i) {
            categoryCb_[i].setFont(guiFont);
        }
        okB_.setFont(guiFont);
        cancelB_.setFont(guiFont);
        resetB_.setFont(guiFont);
        clearCategoryB_.setFont(guiFont);
        allCategoryB_.setFont(guiFont);
        defaultB_.setFont(guiFont);
    }

    public static int GetFormat() {
        int format = 0;
        if (formatRb_[0].isSelected()) {
            format = 0 + formatCb_[0].getSelectedIndex();
        } else if (formatRb_[1].isSelected()) {
            format = 3 + formatCb_[1].getSelectedIndex();
        } else if (formatRb_[2].isSelected()) {
            format = 5 + formatCb_[2].getSelectedIndex();
        } else if (formatRb_[3].isSelected()) {
            format = 7 + formatCb_[3].getSelectedIndex();
        }
        return format;
    }

    public static void SetFormat(int format) {
        switch (format) {
            case 0: {
                formatRb_[0].setSelected(true);
                formatCb_[0].setSelectedIndex(0);
                break;
            }
            case 1: {
                formatRb_[0].setSelected(true);
                formatCb_[0].setSelectedIndex(1);
                break;
            }
            case 2: {
                formatRb_[0].setSelected(true);
                formatCb_[0].setSelectedIndex(2);
                break;
            }
            case 3: {
                formatRb_[1].setSelected(true);
                formatCb_[1].setSelectedIndex(0);
                break;
            }
            case 4: {
                formatRb_[1].setSelected(true);
                formatCb_[1].setSelectedIndex(1);
                break;
            }
            case 5: {
                formatRb_[2].setSelected(true);
                formatCb_[2].setSelectedIndex(0);
                break;
            }
            case 6: {
                formatRb_[2].setSelected(true);
                formatCb_[2].setSelectedIndex(1);
                break;
            }
            case 7: {
                formatRb_[3].setSelected(true);
                formatCb_[3].setSelectedIndex(0);
                break;
            }
            case 8: {
                formatRb_[3].setSelected(true);
                formatCb_[3].setSelectedIndex(1);
            }
        }
    }

    public static void DefaultFormat() {
        formatRb_[0].setSelected(true);
        formatCb_[0].setSelectedIndex(0);
        formatCb_[1].setSelectedIndex(0);
        formatCb_[2].setSelectedIndex(0);
        formatCb_[3].setSelectedIndex(0);
    }

    public static Vector<Boolean> GetOutCategoryValues() {
        Vector<Boolean> outCategoryValues = new Vector<Boolean>();
        for (int i = 0; i < 11; ++i) {
            boolean value = categoryCb_[i].isSelected();
            outCategoryValues.add(new Boolean(value));
        }
        return outCategoryValues;
    }

    public static void SetCategoryCheckBox(long outCat) {
        for (int i = 0; i < 11; ++i) {
            boolean value = Bit.Contain(outCat, ByCategoryPanel.CATEGORY_VALUE[i]);
            categoryCb_[i].setSelected(value);
        }
    }

    public static void ClearAllCategoryCheckBoxes() {
        for (int i = 0; i < 11; ++i) {
            categoryCb_[i].setSelected(false);
        }
    }

    public static void SelectAllCategoryCheckBoxes() {
        for (int i = 0; i < 11; ++i) {
            categoryCb_[i].setSelected(true);
        }
    }

    private static JPanel CreateFormatPanel() {
        JPanel formatP = new JPanel();
        formatP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Format: "));
        formatP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        gbc.anchor = 17;
        GridBag.SetWeight(gbc, 100, 100);
        for (int i = 0; i < FORMAT_SIZE; ++i) {
            GridBag.SetPosSize(gbc, 0, i, 1, 1);
            formatP.add((Component)formatRb_[i], gbc);
            GridBag.SetPosSize(gbc, 1, i, 1, 1);
            formatP.add((Component)formatCb_[i], gbc);
        }
        return formatP;
    }

    private static JPanel CreateFilterPanel() {
        int i;
        JPanel filterP = new JPanel();
        filterP.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Output Category Filter: "));
        filterP.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 3, 5, 3);
        gbc.fill = 0;
        gbc.anchor = 17;
        GridBag.SetWeight(gbc, 100, 100);
        for (i = 0; i < 6; ++i) {
            GridBag.SetPosSize(gbc, i, 0, 1, 1);
            filterP.add((Component)categoryCb_[i], gbc);
        }
        for (i = 6; i < 11; ++i) {
            int ii = i - 6;
            GridBag.SetPosSize(gbc, ii, 1, 1, 1);
            filterP.add((Component)categoryCb_[i], gbc);
        }
        return filterP;
    }

    private static JPanel CreateButtonPanel() {
        JPanel buttonP = new JPanel();
        buttonP.add(okB_);
        buttonP.add(cancelB_);
        buttonP.add(resetB_);
        buttonP.add(clearCategoryB_);
        buttonP.add(allCategoryB_);
        buttonP.add(defaultB_);
        return buttonP;
    }

    private void InitGuiControllers(LaFrame owner) {
        this.outputOptionDialogControl_ = new OutputOptionDialogControl(owner);
        okB_.setActionCommand(B_OK);
        cancelB_.setActionCommand(B_CANCEL);
        resetB_.setActionCommand(B_RESET);
        clearCategoryB_.setActionCommand(B_CLEAR_CATEGORY);
        allCategoryB_.setActionCommand(B_ALL_CATEGORY);
        defaultB_.setActionCommand(B_DEFAULT);
        okB_.addActionListener(this.outputOptionDialogControl_);
        cancelB_.addActionListener(this.outputOptionDialogControl_);
        resetB_.addActionListener(this.outputOptionDialogControl_);
        clearCategoryB_.addActionListener(this.outputOptionDialogControl_);
        allCategoryB_.addActionListener(this.outputOptionDialogControl_);
        defaultB_.addActionListener(this.outputOptionDialogControl_);
    }

    static {
        OutputOptionDialog.formatRb_[0] = new JRadioButton("Lexical Records:");
        OutputOptionDialog.formatRb_[1] = new JRadioButton("Bases:");
        OutputOptionDialog.formatRb_[2] = new JRadioButton("Spelling Variants:");
        OutputOptionDialog.formatRb_[3] = new JRadioButton("Inflectional Variants:");
        formatRb_[0].setSelected(true);
        formatBGroup_ = new ButtonGroup();
        for (int i = 0; i < FORMAT_SIZE; ++i) {
            formatBGroup_.add(formatRb_[i]);
        }
        OutputOptionDialog.formatCb_[0] = new JComboBox();
        formatCb_[0].addItem("Text format");
        formatCb_[0].addItem("XML format");
        formatCb_[0].addItem("Text & XML format");
        formatCb_[0].setSelectedIndex(0);
        OutputOptionDialog.formatCb_[1] = new JComboBox();
        formatCb_[1].addItem("Base only");
        formatCb_[1].addItem("Base with detail information");
        formatCb_[1].setSelectedIndex(0);
        OutputOptionDialog.formatCb_[2] = new JComboBox();
        formatCb_[2].addItem("Spelling variants only");
        formatCb_[2].addItem("Spelling variants with detail information");
        formatCb_[2].setSelectedIndex(0);
        OutputOptionDialog.formatCb_[3] = new JComboBox();
        formatCb_[3].addItem("Inflectional variants only");
        formatCb_[3].addItem("Inflectional variants with detail information");
        formatCb_[3].setSelectedIndex(0);
        OutputOptionDialog.categoryCb_[0] = new JCheckBox("Adj");
        OutputOptionDialog.categoryCb_[1] = new JCheckBox("Adv");
        OutputOptionDialog.categoryCb_[2] = new JCheckBox("Aux");
        OutputOptionDialog.categoryCb_[3] = new JCheckBox("Compl");
        OutputOptionDialog.categoryCb_[4] = new JCheckBox("Conj");
        OutputOptionDialog.categoryCb_[5] = new JCheckBox("Det");
        OutputOptionDialog.categoryCb_[6] = new JCheckBox("Modal");
        OutputOptionDialog.categoryCb_[7] = new JCheckBox("Noun");
        OutputOptionDialog.categoryCb_[8] = new JCheckBox("Prep");
        OutputOptionDialog.categoryCb_[9] = new JCheckBox("Pron");
        OutputOptionDialog.categoryCb_[10] = new JCheckBox("Verb");
    }
}

