/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Tools;

import gov.nih.nlm.nls.lexCheck.Api.ToJavaObjApi;
import gov.nih.nlm.nls.lexCheck.Lib.CheckContent;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;

public class ValidateContentFromTextFile {
    public static void main(String[] argv) {
        String inFile = "LEXICON";
        String outFile = "LEXICON.fix";
        boolean fixFlag = false;
        if (argv.length == 1) {
            inFile = argv[0];
        } else if (argv.length == 2) {
            inFile = argv[0];
            outFile = argv[1];
        } else if (argv.length == 3) {
            inFile = argv[0];
            outFile = argv[1];
            if (argv[2].equals("-f")) {
                fixFlag = true;
            }
        } else {
            System.err.println("** Usage: java ValidateContentFromTextFile <inFile(Text)> <outFile> <-f>");
            System.err.println("  inFile: LEXICON in text format");
            System.err.println("  outFile: output LEXICON in text format");
            System.err.println("  -f: auto-fix content for LEXICON");
            System.exit(1);
        }
        ValidateContentFromTextFile.CheckContentFromLexicon(inFile, fixFlag, outFile);
    }

    public static void CheckContentFromLexicon(String inFile, boolean fixFlag, String outFile) {
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
            Vector<LexRecord> lexRecords = ToJavaObjApi.ToJavaObjsFromTextFile(inFile);
            int recSize = lexRecords.size();
            if (lexRecords.size() > 0) {
                boolean validateFlag = true;
                for (int i = 0; i < recSize; ++i) {
                    LexRecord lexRecord = lexRecords.elementAt(i);
                    if (CheckContent.Check(lexRecord, fixFlag) == 2) {
                        validateFlag = false;
                        System.out.println(CheckContent.GetErrMsg());
                    }
                    LexRecord fixedLexRecord = CheckContent.GetFixedLexRecord();
                    String text = fixedLexRecord.GetText();
                    out.write(text);
                }
                if (validateFlag) {
                    System.out.println("-- All lexRecords (" + recSize + ") validated, no content error found!");
                }
            }
            System.out.println("-- Checked Content for all lexRecords: " + recSize);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

