function theme_switch(id)
  if id == "game" then
    enable_theme_game()
  elseif id == "author" then
    enable_theme_author()
  elseif id == "source" then
    enable_theme_source()
  elseif id == "pc" then
    enable_theme_pc()
  elseif id == "diary" then
    enable_theme_diary()
  elseif id == "finale" then
    enable_theme_finale()
  elseif id == "titles" then
    enable_theme_titles()
  end
  G_current_theme = id
end

function enable_theme_game()
  theme.win.geom(40, 20, 660, 490)
  theme.inv.geom(760, 20, 185, 480)
  theme.win.color('#000000', '#143887', '#cb4b16')
  theme.inv.color('#000000', '#143887', '#cb4b16')
  theme.gfx.bg('theme/gamebg.jpg')
  theme.win.font('theme/{Roboto-Regular,Roboto-Bold,Roboto-Italic,Roboto-BoldItalic}.ttf', 20, 0.95)
  theme.inv.font('theme/{Roboto-Regular,Roboto-Bold,Roboto-Italic,Roboto-BoldItalic}.ttf', 20, 0.95)
  theme.win.gfx.up('theme/aup.png', -1, -1)
  theme.win.gfx.down('theme/adown.png', -1, -1)
end

function enable_theme_author()
  theme.win.geom(140, 20, 660, 490)
  theme.inv.geom(0, 0, 1, 1)
  theme.win.color('#000000', '#073642', '#cb4b16')
  theme.inv.color('#000000', '#073642', '#cb4b16')
  theme.gfx.bg('theme/minimal-std.png')
  theme.win.font('theme/{PTF55F,PTF75F,PTF56F,PTF76F}.ttf', 20, 0.95)
  theme.inv.font('theme/{PTF55F,PTF75F,PTF56F,PTF76F}.ttf', 20, 0.95)
  theme.win.gfx.up('theme/aup.png', -1, -1)
  theme.win.gfx.down('theme/adown.png', -1, -1)
end

function enable_theme_source()
  theme.win.geom(40, 60, 850, 450)
  theme.inv.geom(423, 25, 100, 25)
  theme.win.color('#eee8d5', '#ff55ff', '#00ff00')
  theme.inv.color('#eee8d5', '#ff55ff', '#00ff00')
  theme.gfx.bg('theme/blue.png')
  theme.win.font('theme/{PxPlus_IBM_VGA8,PxPlus_IBM_VGA8,PxPlus_IBM_VGA8,PxPlus_IBM_VGA8}.ttf', 24, 0.95)
  theme.inv.font('theme/{PxPlus_IBM_VGA8,PxPlus_IBM_VGA8,PxPlus_IBM_VGA8,PxPlus_IBM_VGA8}.ttf', 24, 0.95)
  theme.win.gfx.up('theme/aup-w.png', -1, -1)
  theme.win.gfx.down('theme/adown-w.png', -1, -1)
end

function enable_theme_pc()
  theme.win.geom(75, 40, 550, 420)
  theme.inv.geom(0, 0, 1, 1)
  theme.win.color('#33FF33', '#FFFFFF', '#FFB000')
  theme.inv.color('#33FF33', '#FFFFFF', '#FFB000')
  theme.gfx.bg('theme/pc.png')
  theme.win.font('theme/{PxPlus_IBM_VGA8,PxPlus_IBM_VGA8,PxPlus_IBM_VGA8,PxPlus_IBM_VGA8}.ttf', 24, 0.95)
  theme.inv.font('theme/{PxPlus_IBM_VGA8,PxPlus_IBM_VGA8,PxPlus_IBM_VGA8,PxPlus_IBM_VGA8}.ttf', 24, 0.95)
  theme.win.gfx.up('theme/aup.png', -1, -1)
  theme.win.gfx.down('theme/adown.png', -1, -1)
end

function enable_theme_diary()
  theme.win.geom(40, 20, 850, 490)
  theme.inv.geom(0, 0, 1, 1)
  theme.win.color('#000000', '#143887', '#cb4b16')
  theme.inv.color('#000000', '#143887', '#cb4b16')
  theme.gfx.bg('theme/gamebg.jpg')
  theme.win.font('theme/{Caveat-Regular,Caveat-Bold,Caveat-Regular,Caveat-Bold}.ttf', 28, 0.95)
  theme.inv.font('theme/{Caveat-Regular,Caveat-Bold,Caveat-Regular,Caveat-Bold}.ttf', 28, 0.95)
  theme.win.gfx.up('theme/aup.png', -1, -1)
  theme.win.gfx.down('theme/adown.png', -1, -1)
end

function enable_theme_finale()
  theme.win.geom(130, 20, 670, 490)
  theme.inv.geom(0, 0, 1, 1)
  theme.win.color('#000000', '#143887', '#cb4b16')
  theme.inv.color('#000000', '#143887', '#cb4b16')
  theme.gfx.bg('theme/gamebg.jpg')
  theme.win.font('theme/{Roboto-Regular,Roboto-Bold,Roboto-Italic,Roboto-BoldItalic}.ttf', 20, 0.95)
  theme.inv.font('theme/{Roboto-Regular,Roboto-Bold,Roboto-Italic,Roboto-BoldItalic}.ttf', 20, 0.95)
  theme.win.gfx.up('theme/aup.png', -1, -1)
  theme.win.gfx.down('theme/adown.png', -1, -1)
end

function enable_theme_titles()
  theme.win.geom(150, 20, 650, 450)
  theme.inv.geom(0, 0, 1, 1)
  theme.win.color('#cccccc', '#FFF59D', '#F9A825')
  theme.inv.color('#cccccc', '#FFF59D', '#F9A825')
  theme.gfx.bg('theme/dark.png')
  theme.win.font('theme/{PTF55F,PTF75F,PTF56F,PTF76F}.ttf', 20, 0.95)
  theme.inv.font('theme/{PTF55F,PTF75F,PTF56F,PTF76F}.ttf', 20, 0.95)
  theme.win.gfx.up('theme/aup.png', -1, -1)
  theme.win.gfx.down('theme/adown.png', -1, -1)
end

