room {
  nam = "loc_enter_complex",
  disp = "Entrance To The Complex",
  forcedsc = true,
  noinv = true,
  dsc = function(s, w)
    p[[
      In the corridor, it is quiet and chilly.^
      I go to a small coffee table near the door. On it lay a large folded sheet of paper.
      ]]
  end,
  obj = {
    obj {
      nam = '#paper',
      is_read = false,
      dsc = function(s,w)
        if not s.is_read then
          p [[Driven by curiosity, I {unfold the sheet}.]]
        else
          pn(fmt.em([["Come up to the roof today. It’s very important -- and you know why.]]))
          pn(fmt.em([[P.S. I left a message on your computer, please read it!"^]]))
          pn[[There is no signature. I feel like I have already seen this text somewhere; even the handwriting seems familiar…]]
          pn[[Suddenly the door slams behind me, and I shudder involuntarily. ]]
        end
      end,
      act = function (s,w)
        s.is_read = true
        enable 'cont_complex'
        return true
      end,
    },
    obj {
      nam = "cont_complex", 
      dsc = [[^I put the note back and move further {down the corridor}.]];
      act = function()
        walk 'author_note3'
      end
    }:disable(),
  },
}



room {
  nam = "author_note3";
  disp = "From the Author";
  noinv = true;
  decor = [[
From this moment everything began to fall apart. I had to reveal a shocking truth:
everything that main character was seeing or feeling stemmed from the "pickled"
memories of Nikolai, reproduced in the brain of the protagonist under
the influence of the drug mentioned earlier. 
Anton had to find a camera, develop a film, scan it on a computer and see…  what?
I never managed to think up a good answer to that.^
Having realized that everything happening around him was unreal,
the protagonist had to solve the puzzles in the remaining locations,
find the clue to Nikolai's death (of which Ruslan is guilty, of course),
to emerge victorious from the duel with Ruslan and
return to the real world -- to his girlfriend (does she exist, by the way?),
or remain in trapped within a drug-induced hallucination.
^
But of course, I hadn't written all of this. The game actually ended in the next location.
^ ^
  ]] .. fmt.c('{#next|I suggest you explore it yourself.}');
  enter = function ()
    theme_switch('author')
  end
}:with {
  obj {
    nam = "#next",
    act = function()
      theme_switch('game')
      walk('loc_4f_corridor_a1')
    end
  }
}


room {
  nam = "loc_4f_corridor_a1",
  disp = "Corridor -- Block 4А",
  pic = "gfx/nii-corridors.png",
  dsc = function(s, w)
    pn ()
    p [[ The corridor is illuminated by the pale light of the fluorescent lamps. The rain storm is barely audible here.^
    On the wall, there is the inscription "Block 4A". Next to it, some joker hung "Evacuation plan" with arrows in a circle and a signature "A-A-A-A-A-A !!!".]]
  end,
  obj = {
    obj {
      nam = "corridor_4a_door_blockb4",
      is_seen = false,
      dsc = function(s,w)
        if s.is_seen then
          p [[The {door to Block 4B} is closed.]]
        else
          p [[The {door to the left} seems to be closed.]]
        end
      end,
      act = function(s,w)
        p [["Block 4B" is written on the door in big letters. ]]
        enable 'block_b4_lock'
        s.is_seen = true
      end,
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('corridor_4a_door_blockb4')
          return
        end
        return false
      end,
      obj = {
        obj {
          nam = "block_b4_lock",
          is_processed = 0,
          disp = "Padlock",
          dsc = [[ There is a massive {padlock} on it.]],
          act = "A key is required to open it.",
          used = function(s,w)
            if w^'DEBUGGER' then
              view_source('block_b4_lock')
              return
            elseif w.HIDDEN_name == name_of_rod then
              p [[I try to break the padlock with a metal rod. Useless -- the lock is very durable.]]
              return
            end
            return false
          end
        }:disable()
      },
    }, 
    obj {
      nam = "corridor_4a_door_security",
      is_seen = false,
      dsc = function(s,w)
        pn()
        if s.is_seen then
          p [[Behind the door to the right is the guard post.]]
        else
          p [[On the right is a {metal door} with some kind of sign.]]
        end
      end,
      act = function(s,w)
        p [[The sign on the door reads "Guard post". I checked the door -- it isn't locked.]]
        enable "path_security_room"
        s.is_seen = true
      end,
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('corridor_4a_door_security')
          return
        end
        return false
      end
    },
    obj {
      nam = "corridor_4a_p2",
      is_seen = false,
      dsc = function(s,w)
        p [[^Ahead, at the {end of the corridor}, I can see a few more doors.]]
      end,
      act = function(s,w)
        p [[^That’s where my desk is. I have to visit it.]]
        enable "path_corridor_a2"
        remove(s)
      end,
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('corridor_4a_p2')
          return
        end
        return false
      end
    }
  },
  way = {
    path {"path_corridor_a2", "To the end of the corridor", "loc_4f_corridor_a2" }:disable(),
    path {"path_security_room", "Guard Post", "loc_4f_security" }:disable(),
    path {"path_corridor_b1", "Block 4B", "loc_4f_corridor_b1" }:disable(),
  }
}

room {
  nam = "loc_4f_security",
  disp = "Guard Post",
  -- pic = "gfx/",
  dsc = function(s, w)
    pn ()
    p [[ -- TODO: write a description of the "Guard Post" location.]]
  end,
  obj = {
    obj {
      nam = "divan",
      dsc = "There is a comfortable {sofa} near the wall. ",
      act = "Alas, I have no time to rest.",
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('divan')
          return
        end
        return false
      end
    },
    obj {
      nam = "tv",
      dsc = "Opposite the sofa, there is a {TV} on the table.",
      act = "The TV screen is covered with dust.",
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('tv')
          return
        end
        return false
      end
    }
  },
  way = {
    path {'path_4_corridor', "Exit to the corridor", 'loc_4f_corridor_a1'},
    path {'path_4_window', "Go to the window", 'loc_4f_security_window'}
  }
}

room {
  nam = "loc_4f_security_window",
  disp = "Guard Post -- At The Window",
  -- pic = "gfx/",
  dsc = function(s, w)
    pn()
    p [[ Looking out the window, rain is still coming down hard. Wind gusts rattle the glass. ]]
  end,
  enter = function()
    sound_player('snd/rain.ogg')
  end,
  obj = {
    obj {
      nam = "#journal",
      dsc = "A {list of visit logs} is on the table by the window. ",
      act = "The last log entry was dated May 2002, ten years ago. But where is the new log?",
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('journal')
          return
        end
        return false
      end
    },
    obj {
      nam = "#terminal",
      dsc = "A {terminal} stands nearby.",
      act = "It doesn't turn on. Isn’t anything working around here?",
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('terminal_secwindow')
          return
        end
        return false
      end
    },
    'photo_smena'
  },
  way = {
    path { 'exit_4_window', "Go away from window", 'loc_4f_security' }
  }
}

room {
  nam = "loc_4f_corridor_a2",
  disp = "Corridor -- Block 4A",
  pic = "gfx/nii-corridors.png",
  onenter = function(s,w)
    if s:visits() < 1 then
      p[[I look around in confusion. On one of the doors, there is a sign "Photo Lab." But shouldn’t some other room have been there. No? Why don't I remember?]]
    end
  end,
  dsc = [[
    -- TODO: corridor description.^
    The entrance to our office suite is straight ahead; that is where I work. On the left is the door to the photo lab. 
  ]],
  way = {
    path {'#path_here_1', "Start of the corridor", 'loc_4f_corridor_a1' },
    path {'#path_here_2', "Office hall", 'loc_4f_workspace' },
    path {'#path_here_3', "Photo lab", 'loc_4f_photolab' },
  },
}

room {
  nam = "loc_4f_photolab",
  disp = "Photo Lab",
  dsc = function(s, w)
    pn ()
    p [[The photo lab turns out to be a very small, windowless room. It is a mess -- it seems like no one has been here for a long time.]]
  end,
  decor = function(s,w)
    p [[FIXME: cut and paste new code and objects from "Photo Hunt" game here.]]
  end,
  way = {
    path {'#here_exit', "Exit to the corridor", 'loc_4f_corridor_a2'}
  }
}


room {
  nam = "loc_4f_workspace",
  disp = "Office Hall",
  -- pic = "gfx/",
  dsc = function(s, w)
    pn ()
    p [[ There are about a dozen workstations in the hall and a small area set aside for a kitchen. ]]
  end,
  way = {
    path {'#p_h_4_1', "To the window", 'loc_4f_workspace_window'},
    path {'#p_h_4_2', "To the kitchen", 'loc_4f_workspace_kitchen'},
    path {'#p_h_4_3', "To my desk", 'loc_4f_workspace_myplace'},
    path {'#p_h_4_4', "Exit to the corridor", 'loc_4f_corridor_a2' }
  }
}


room {
  nam = "loc_4f_workspace_kitchen",
  disp = "Office Hall -- Kitchen",
  -- pic = "gfx/",
  dsc = function(s, w)
    pn ()
    p [[ -- TODO: write a description of the kitchen area. ]]
  end,
  obj = {
    obj {
      nam = "Fridge",
      dsc = "There is a big {fridge} in the corner. ",
      act = "The fridge is empty.",
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('freezer')
          return
        end
        return false
      end
    },
    obj {
      nam = "Table",
      dsc = "Near the wall there is a {dining table} and around it, several chairs.",
      act = "Dishes have been tossed haphazardly on the table.",
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('diner_table')
          return
        end
        return false
      end
    }
  },
  way = {
    path {'#loc_exit', "To the door", 'loc_4f_workspace'}
  },
}


room {
  nam = "loc_4f_workspace_window",
  disp = "Office Hall -- At The Window",
  -- pic = "gfx/",
  dsc = "I peer out the window. The rain pours down without any hint of letting up.",
  decor = function(s, w)
    p [[The window is open and there is a large puddle on the floor. Next to the window is a {#02|desk} with a {#03|computer}.]]
  end,
  enter = function()
    sound_player('snd/rain.ogg')
  end,
  obj = {
    obj {
      nam = "#02",
      act = "The drawers of the desk are empty.",
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('writing_desk')
          return
        end
        return false
      end
      },
    obj {
      nam = "#03",
      act = "This piece of junk is ten years old, no less. Where did they get this crap?",
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('broken_computer')
          return
        end
        return false
      end
    },
  },
  way = {
    path {'#loc_exit', "To the door", 'loc_4f_workspace' }
  }
}

room {
  nam = "loc_4f_workspace_myplace",
  disp = "Office Hall -- My Desk",
  -- pic = "gfx/",
  obj = {
    obj {
      nam = "#03",
      dsc = "I worked here behind a comfortable desk with {drawers}. ",
      act = "The drawers of the desk are empty. Where did all my notes go?",
      used = function (s,w)
        if w^'DEBUGGER' then
          view_source('my_desk')
          return
        end
        return false
      end
    },
    obj {
      nam = "workspace_mypc",
      dsc = function (s,w)
        p[[On the desk is my {work computer}. ]]
      end,
      act = function (s,w)
        walk 'loc_mypc'
      end,
      used = function(s,w)
        if w^'DEBUGGER' then
          view_source('workspace_mypc')
          return
        elseif w.HIDDEN_name == name_of_rod then
          p [[Well, no, I need this computer.]]
          return
        end
        return false
      end
    },
    obj {
      nam = "workspace_mfu",
      dsc = function (s,w)
        p[[A three-in-one {printer/scanner/fax} is connected to it.]]
      end,
      act = function (s,w)
        p[[In addition to the usual conveniences, this multi-function printer also has a module to scan film.]]
      end,
      used = function(s,w)
        if w^'DEBUGGER' then
          view_source('workspace_mfu')
          return
        elseif w.HIDDEN_name == name_of_fotoplenka then
          p [[This device can’t scan the undeveloped film.]]
          return
        elseif w.HIDDEN_name == name_of_rod then
          p [[Why should I destroy my employer’s property?]]
          return
        end
        return false
      end
    }
  },
  way = {
    path { '#to_door', "To the door", 'loc_4f_workspace' }
  },
}
