
//Disable Sugar's "history" (can't go back)
Config.saves.autosave = ["autosave"];
//Config.history.maxStates = 1;

State.variables.endings = {GameOver:'GAMEOVER', Vain:'5-6:mediocre', Sacrifice:'5-10:Next-556', Selfish:'5-15:bloodofcursed', Savor:'5dive6'};
forget('achievements')

State.variables.achievements = recall('achievements', {GameOver:0, Vain:0, Sacrifice:0, Selfish:0, Savor:0});

State.variables.pain = 0;
State.variables.replayingEnding = 0;
State.variables.MASTER_VOLUME = 1.0;
State.variables.DEFAULT_BGM_VOLUME = State.variables.BGM_VOLUME = 0.1;
State.variables.DEFAULT_SFX_VOLUME = State.variables.SFX_VOLUME = 0.1;
State.variables.SPEED_1 = '45ms';
State.variables.SPEED_2 = '30ms';
State.variables.SPEED_3 = '5ms';
State.variables.SPEED_4 = '0.0001ms';
State.variables.items = {
	keys:{BrassKey:0, LongKey:0},
	journal:{Herbs:0, Work:0, HolyWater:0, Will:0}, 
	fragments:{Rain:0, Family:0, Beauty:0, Death:0}, 
	books:{Book1:0, Book2:0, Book3:0, Book4:0},
	booksread:{Book1:0, Book2:0, Book3:0, Book4:0},
	rewindtokens:{Book1:0, Book2:0, Book3:0, Book4:0}
};

var itemtxt = {
	books: 'Book', journal: 'Journal Entry', 
	fragments: 'Fragment', rewindtokens: 'Rewind Token', 
	keys: 'Key', rewinds: 'Remaining Rewinds'}

//Config.macros.typeVisitedPassages = false;

//Fragments
//Rain ::2-26:Leave-2226 
//Family ::3-31:magrack 
//Beauty ::4-12:insidegate 
//Death ::5-4:upstairslast 

//Journal
//Herbs ::2-37:Next-298 
//Work ::3-34:helpgram
//HolyWater ::4-17:houseaftercoop
//Will ::5-3:choosegram

//Items
//gatekey ::3-32:checksink
//shedkey ::2-21:TakeKey-5203

//Books
//Books[0] ::2-15:CheckBookcase
//Books[1] ::2-21a:TakeBook-5203
//Books[2] ::4-4:MagazineRack
function playSFX(name, defaultVol){
	//console.log('Playing SFX:'+name);
	var vol = defaultVol?State.variables.DEFAULT_SFX_VOLUME : State.variables.SFX_VOLUME;
	SimpleAudio.tracks.get(name).volume(vol).loop(false).play();
}


Macro.add('resetVars', {
	handler : function() {
    State.variables.items = {
        keys:{BrassKey:0, LongKey:0},
        journal:{Herbs:0, Work:0, HolyWater:0, Will:0}, 
        fragments:{Rain:0, Family:0, Beauty:0, Death:0}, 
        books:{Book1:0, Book2:0, Book3:0},
        booksread:{Book1:0, Book2:0, Book3:0},
        rewindtokens:{Book1:0, Book2:0, Book3:0}
    };
	}
});



Macro.add('playSFX', {
	handler : function() {
		playSFX(this.args[0],true);
	}
});

Macro.add('useRewind', {
	handler : function() {
        
		for (var key in State.variables.items.rewindtokens){
			if (State.variables.items.rewindtokens[key]){
                //console.log('useRewind:',key);
				State.variables.items.rewindtokens[key] = 0;	
				break;
			}
		}
	}
});

Config.saves.onLoad = function () {SimpleAudio.select(":all").stop();}
function playBGM(newbgm){
	//console.log('Playing BGM:'+newbgm);
	if(State.variables.bgm == newbgm) return;
    SimpleAudio.select(":all").stop();
	if(State.variables.bgm != undefined && State.variables.bgm != null)
		SimpleAudio.tracks.get(State.variables.bgm).stop();
	State.variables.bgm = newbgm;
	SimpleAudio.tracks.get(State.variables.bgm).volume(State.variables.BGM_VOLUME).loop(true).play();
}


Macro.add('achievementLink', {
		handler : function() {
			if(this.args[1]){ //achieved
				var out = this.args[0]+'[img[imgs/icons/replay.png]['+State.variables.endings[this.args[0]]+'][$replayingEnding to 1]]';
			}
			else {
				var out ="<div>????</div><a class='emptyicon' style='width:80px;height:80px'/>"
			}
			$(this.output).wiki(out);
		}
});


Macro.add('getAchievement', {
	handler : function() {
		//var sfx = 'lose';
		//if (this.args[0] == 'Sacrifice')
		//	sfx = 'sad';
		//else if (this.args[0] == 'Savor')
		//	sfx = 'good';
		if (this.args[0] != 'Savor')
			playSFX('lose',true);

		if(State.variables.achievements[this.args[0]])
			return; //already got it!
		$(this.output).wiki("<<type $SPEED_4 class 'getitem getitemachievements'>><span>Achievement Unlocked: "+this.args[0]+"</span><</type>>");
		State.variables.achievements[this.args[0]] = 1;
		memorize('achievements',State.variables.achievements);
	}
});


Macro.add('branch', {
	tags : ['/branch'],
	handler : function() {
		$(this.output).wiki("<<type $SPEED_4>><fieldset class='branch'><legend>Choose  with care!</legend>"+this.payload[0].contents+"</fieldset><</type>>");
	}
});

Macro.add('getitem', {
	handler : function() {
		//console.log('getitem'+this.args);		
		if (State.variables.items[this.args[0]][this.args[1]]) //already set
			return

		//Got item!
		State.variables.items[this.args[0]][this.args[1]] = 1;
		var itemwhich = this.args[0] in itemtxt? itemtxt[this.args[0]] : this.args[0];
		$(this.output).wiki('<<type $SPEED_4 class "getitem getitem'+this.args[0]+'">><span>You acquired '+itemwhich+': '+this.args[1]+'</span><</type>>');
	}
});
Macro.add('toggleBGM', {
	handler : function() {
		console.log('toggleBGM');
		State.variables.BGM_VOLUME = State.variables.BGM_VOLUME? 0.0:State.variables.DEFAULT_BGM_VOLUME;
		SimpleAudio.tracks.get(State.variables.bgm).volume(State.variables.BGM_VOLUME).loop(true).play();
		playSFX('knife1', true);
	}
});

Macro.add('toggleSFX', {
	handler : function() {
		console.log('toggleSFX');
		State.variables.SFX_VOLUME = State.variables.SFX_VOLUME? 0.0:State.variables.DEFAULT_SFX_VOLUME;
		playSFX('knife1', true);
	}
});

Macro.add('BGM', {
	handler	:	function () {
		if(State.variables.bgm != undefined && State.variables.bgm != null)
			SimpleAudio.tracks.get(State.variables.bgm).stop();
		State.variables.bgm = this.args[0];
		SimpleAudio.tracks.get(State.variables.bgm).volume(State.variables.BGM_VOLUME).loop(true).play();

	}
});

Macro.add('iconlink', {
	handler: function (){
		var iconclass=''
		if(this.args[0]=='book')
			iconclass=State.variables.items.booksread[this.args[1]]?'openbookicon':'bookicon';
		else
			iconclass = this.args[0]+'icon';
		$(this.output).wiki('<span data-passage="'+this.args[0]+''+this.args[1]+'" class=" fullicon '+iconclass+'" />');
	}
});

Macro.add('sfxtype', {
	skipArgs : false,
	tags : ['/sfxtype'],
	handler  : function () {
		try {
			//console.log('<<sfxtype>>'+this.args[1]);
			$(this.output).wiki('<<type '+this.args[0]+' class "sfxtype" id "'+this.args[1]+'">>'+this.payload[0].contents+'<</type>>');
			//jQuery(this.output).wiki('<<type 130ms>>'+this.content+'<</type>>');
		}
		catch (ex) {
			return this.error('bad conditional expression: ' + ex.message);
		}
	}
});




Macro.add('shake', {
	handler : function () {
		
		var duration;

		if (this.args.length === 0) {
			duration = 1000;
		}
		else {
			try {
				duration = Util.fromCssTime(this.args[0]);
			}
			catch (e) {
				return this.error(e.message);
			}

		}

		
		//VisFX
		var $passage = jQuery(
			this.output.nodeType === Node.ELEMENT_NODE
				? this.output
				: '.passage'
		);

		$passage.addClass('shake');

		if (duration > 0) {
			setTimeout(function () {
				$passage.removeClass('shake');
			}, Engine.minDomActionDelay + duration);
		}
	}
});



Macro.add('VolSlider', {
	handler : function() {
		var out = "<input type='range' min='0' max='100' value='"+(State.variables.MASTER_VOLUME*100)+"' class='slider'>";
		$(this.output).wiki(out);
	}
});



Macro.add('loadGame', {
	handler : function() {
	//memorize('save%d'SAVE_SLOT,{'scene':State.variables.return, 'items':State.variables.items});
	//playSFX('knife1', true);
	//console.log('loadGame:'+this.args[0])
	UI.saves();//ave.slots.load(this.args[0]);
	}
});


postdisplay['fadeIn-text'] = function (taskName) {
	$('.fadeIn').hide().fadeIn(1000);
};


$(document).on(':typingstart', function(ev){
	//$(".sfxtype").on("mousedown", function (ev) { alert('ok'); })
	
	if($(ev.target).hasClass('sfxtype')){
		playSFX(ev.target.id);
	}
	else if($(ev.target).hasClass('fxtype')){
		playFX(ev.target.id);
	}
});


$(document).on(':typingcomplete', function (ev) {
	//Set default selection to first 'choice' item
	$('.link-internal').show()

	State.variables.selectedLink = 0;
	$('.link-internal').eq(State.variables.selectedLink).addClass('selected');
});



$(document).on(':passagestart', function (ev) {
	//console.log('passagestart');
	//auto play bgm based on tag
	tags().forEach(function(tag){
		if(tag.substr(0,3) == 'bgm'){
			playBGM(tag);
			return false;
		}
	});
	

	//Handle return pointer storing (for Menu to get back)
	if (!ev.passage.tags.includes('noreturn')) {
		State.variables.return = ev.passage.title;
	}

	State.variables.selectedLink = -1;
});



State.variables.all_passages = Story.lookup().map(function(p){return p.title});

$(document).on(':passageend', function (ev) {
	//console.log('passageend');
	if(ev.passage.title=='Menu' || ev.passage.title == 'DebugMenu') return;
	//DEBUG: record cross-play history of all passages entered
	State.variables.visited = recall('visited',{});
	State.variables.visited[ev.passage.title] = 1;
	memorize('visited',State.variables.visited);

});

$(document).on(':passagedisplay', function (ev) {
	//console.log(ev.content);
	//$(ev.content).find('a').addClass('selected');
	//$(ev.content).wiki("Go fuck yourself!");
	//$('.link-internal').eq(State.variables.selectedLink).addClass('selected');
	$('.slider').on("input", function(){
				State.variables.MASTER_VOLUME = this.value/100.;
				$.wiki('<<masteraudio volume $MASTER_VOLUME*0.4>>');
			});
});




//Handle keypresses
$(document).keydown(function(ev) {
  if(ev.key=='Escape'){
	if (State.variables.replayingEnding)
		Engine.play('Achievements');
	else if ("AchievementsCreditsControls".indexOf(State.passage) >-1)
		Engine.play('Start');
	else if (State.passage == 'Menu'){
		$.wiki('<<masteraudio volume $MASTER_VOLUME>>');

			/* DEFUNCT --[[links]] now in <<type>>
			$(document).on(":passageend", function(ev) {
				console.log(ev.passage);
				console.log('bla');
				console.log($('.link-internal'));
				$('.link-internal').show();
				});*/

		Engine.play(State.variables.return);

	}
	else { //Open Menu + HACK buttons active
		Engine.play('Menu');
		$('#bgmvol').addClass('active');
		$('#sfxvol').addClass('active');
	}
  }
  else if (ev.key=='l'){
	UI.saves();
  }
  else if (ev.key=='d'){
	Engine.play('DebugMenu');
  }

  else if(State.variables.selectedLink>-1){
		if (ev.key=='ArrowUp' || ev.key=='ArrowDown'){
		  State.variables.selectedLink += (ev.key=='ArrowDown') ? 1:-1;
		  if(State.variables.selectedLink >= $('.link-internal').length)
			  State.variables.selectedLink--;
		  else if(State.variables.selectedLink < 0)
			  State.variables.selectedLink++;

		  $('.link-internal').removeClass('selected');
		  $('.link-internal').eq(State.variables.selectedLink).addClass('selected');
		}
		else if( ev.key==' '){
			var selected_link = $('.link-internal').eq(State.variables.selectedLink);
			if(selected_link.is(":visible"))
				Engine.play(selected_link.attr('data-passage'));
		}
	}
	else if( ev.key==' '){
		//ev.stopImmediatePropagation(); //dont give to <type> after psg change
	}

});

//Disable Sidebar
$('#ui-bar').remove();
$(document.head).find('#style-ui-bar').remove();