/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class Parser {
    public static StringBuilder input = new StringBuilder("");
    public static StringBuilder verb = new StringBuilder("");
    public static StringBuilder noun = new StringBuilder("");
    public static ArrayList<String> sentence = new ArrayList();

    public static void submitInput() {
        ++Data.moves;
        Story.newParagraph();
        Story.printInput();
        Parser.setInput();
        Parser.resetInput();
        if (Parser.validInput()) {
            Parser.eraseSpaces();
            Parser.createSentence();
            Parser.passInput();
            Story.setScrollbar();
        }
    }

    public static void setInput() {
        input.setLength(0);
        input.append(Wabewalker.inputBox.getText().toUpperCase());
    }

    public static void resetInput() {
        Wabewalker.inputBox.setText("");
    }

    private static boolean validInput() {
        int n = 0;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == ' ') continue;
            ++n;
        }
        return n != 0;
    }

    private static void eraseSpaces() {
        int n;
        for (n = 0; n < input.length(); ++n) {
            if (input.charAt(n) != '\"') continue;
            input.setCharAt(n, ' ');
        }
        while (input.charAt(0) == ' ') {
            input.deleteCharAt(0);
        }
        while (input.charAt(input.length() - 1) == ' ') {
            input.deleteCharAt(input.length() - 1);
        }
        for (n = 0; n < input.length() - 1; ++n) {
            if (input.charAt(n) != ' ' || input.charAt(n + 1) != ' ') continue;
            Parser.shiftChars(n);
        }
        input.trimToSize();
    }

    private static void shiftChars(int n) {
        for (int i = n; i < input.length() - 1; ++i) {
            input.setCharAt(i, input.charAt(i + 1));
        }
        input.setLength(input.length() - 1);
        Parser.eraseSpaces();
    }

    private static void createSentence() {
        StringBuilder stringBuilder = new StringBuilder("");
        sentence.clear();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == ' ') {
                sentence.add(Thesaurus.translate(stringBuilder.toString()));
                stringBuilder.setLength(0);
                continue;
            }
            if (i == input.length() - 1) {
                stringBuilder.append(input.charAt(i));
                sentence.add(Thesaurus.translate(stringBuilder.toString()));
                continue;
            }
            stringBuilder.append(input.charAt(i));
        }
        Parser.removeExtraWords();
        sentence.add("");
    }

    private static void removeExtraWords() {
        int n;
        for (n = 0; n < Thesaurus.extraWords.size(); ++n) {
            while (sentence.contains(Thesaurus.extraWords.get(n))) {
                sentence.remove(Thesaurus.extraWords.get(n));
            }
        }
        for (n = 0; n < sentence.size() - 1; ++n) {
            if (!sentence.get(n).equals("ICHIRO") || !sentence.get(n + 1).equals("ICHIRO")) continue;
            sentence.remove(n);
        }
        for (n = 0; n < sentence.size() - 1; ++n) {
            if (!sentence.get(n).equals("CORN") || !sentence.get(n + 1).equals("CORN")) continue;
            sentence.remove(n);
        }
    }

    public static void passInput() {
        if (Story.restartRestoreOrQuit) {
            Story.handleQuestion(sentence.get(0));
        } else if (Data.yesOrNo) {
            Data.yesOrNo(sentence.get(0));
        } else if (Player.facingReaper) {
            NPC.handleReaper(sentence.get(0));
        } else if (sentence.contains("UNUSED")) {
            Story.printUnused();
        } else if (Data.gameOver) {
            Data.handleGameOver(sentence.get(0));
        } else if (Player.onPhone) {
            if (sentence.get(0).equals("HANG")) {
                Action.hang(sentence.get(1).toString());
            } else {
                NPC.handleKimi(sentence.get(0));
            }
        } else if (Player.getLocation().title.equals("Hisachi Ichiro's House")) {
            NPC.handleTod(sentence.get(0));
        } else if (Player.meditating) {
            Meditate.handleMeditating(sentence.get(0));
        } else {
            Parser.handleInput(sentence.get(0));
        }
    }

    public static void handleInput(String string) {
        if (!string.equals("HINT")) {
            Data.hint = 1;
        }
        switch (string) {
            case "HELP": {
                Story.printHelp();
                break;
            }
            case "BRIEF": {
                Story.brief(true);
                break;
            }
            case "VERBOSE": {
                Story.brief(false);
                break;
            }
            case "MEDITATE": {
                Action.meditate();
                break;
            }
            case "NORTH": {
                if (Room.getExits().contains("N")) {
                    Action.goNorth();
                    break;
                }
                Room.noExit("NORTH");
                break;
            }
            case "SOUTH": {
                if (Room.getExits().contains("S")) {
                    Action.goSouth();
                    break;
                }
                Room.noExit("SOUTH");
                break;
            }
            case "EAST": {
                if (Room.getExits().contains("E")) {
                    Action.goEast();
                    break;
                }
                Room.noExit("EAST");
                break;
            }
            case "WEST": {
                if (Room.getExits().contains("W")) {
                    Action.goWest();
                    break;
                }
                Room.noExit("WEST");
                break;
            }
            case "NORTHEAST": {
                if (Room.getExits().contains("NE")) {
                    Action.goNorthEast();
                    break;
                }
                Story.printNoExit();
                break;
            }
            case "SOUTHEAST": {
                if (Room.getExits().contains("SE")) {
                    Action.goSouthEast();
                    break;
                }
                Story.printNoExit();
                break;
            }
            case "NORTHWEST": {
                if (Room.getExits().contains("NW")) {
                    Action.goNorthWest();
                    break;
                }
                Story.printNoExit();
                break;
            }
            case "SOUTHWEST": {
                if (Room.getExits().contains("SW")) {
                    Action.goSouthWest();
                    break;
                }
                Story.printNoExit();
                break;
            }
            case "UP": {
                if (Room.getExits().contains("U")) {
                    Action.goUp();
                    break;
                }
                Story.printNoExit();
                break;
            }
            case "DOWN": {
                if (Room.getExits().contains("D")) {
                    Action.goDown();
                    break;
                }
                Story.printNoExit();
                break;
            }
            case "GO": {
                Action.go(sentence.get(1));
                break;
            }
            case "WAIT": {
                Action.passTime();
                break;
            }
            case "INVENTORY": {
                Action.checkInventory();
                break;
            }
            case "MEMORY": {
                Story.printMemory();
                break;
            }
            case "TAKE": {
                Action.take(sentence.get(1));
                break;
            }
            case "PICK": {
                Action.pick(sentence.get(1));
                break;
            }
            case "DROP": {
                Action.drop(sentence.get(1));
                break;
            }
            case "EXAMINE": {
                Action.attemptToExamine(sentence.get(1));
                break;
            }
            case "OPEN": {
                Action.open(sentence.get(1));
                break;
            }
            case "SHUT": {
                Action.shut(sentence.get(1));
                break;
            }
            case "HANG": {
                Action.hang(sentence.get(1));
                break;
            }
            case "VISUALIZE": {
                Story.printNotMeditating();
                break;
            }
            case "CHANT": {
                Story.printNotMeditating();
                break;
            }
            case "PRESS": {
                Action.press(sentence.get(1));
                break;
            }
            case "PULL": {
                Action.pull(sentence.get(1));
                break;
            }
            case "PUT": {
                Action.put(sentence.get(1));
                break;
            }
            case "SAY": {
                Action.say();
                break;
            }
            case "CAST": {
                Action.cast(sentence.get(1));
                break;
            }
            case "HIDE": {
                Story.print("Despite your best efforts to hide yourself, you end up completely exposed.");
                break;
            }
            case "REWIND": {
                Action.pressRewind();
                break;
            }
            case "FASTFORWARD": {
                Action.pressFastforward();
                break;
            }
            case "PLAY": {
                Action.pressPlay();
                break;
            }
            case "MOVE": {
                Action.move(sentence.get(1));
                break;
            }
            case "DIAL": {
                if (Player.inventory.contains(Item.Phone.getTitle())) {
                    Action.dial(sentence.get(1));
                    break;
                }
                Story.print("You're not holding an item that can do that.");
                break;
            }
            case "FIGHT": {
                Action.fight(sentence.get(1));
                break;
            }
            case "CHEAT": {
                Data.cheat();
                break;
            }
            case "DIE": {
                Story.printHow();
                break;
            }
            case "SIT": {
                Action.sit(sentence.get(1));
                break;
            }
            case "DANCE": {
                Story.printDance();
                break;
            }
            case "SLEEP": {
                Story.print("You're wide awake, and full of energy!");
                break;
            }
            case "EAT": {
                Action.eat(sentence.get(1));
                break;
            }
            case "BACK": {
                Room.checkPreviousLocation();
                break;
            }
            case "EXIT": {
                Action.exit(sentence.get(1));
                break;
            }
            case "ENTER": {
                Action.enter(sentence.get(1));
                break;
            }
            case "DESTROY": {
                Action.destroy(sentence.get(1));
                break;
            }
            case "CREDITS": {
                Story.printCredits();
                break;
            }
            case "HINT": {
                Story.printHint(sentence.get(1));
                break;
            }
            case "KNOCK": {
                Item.door.knock();
                break;
            }
            case "CLIMB": {
                Story.print("You quickly find out that you are a terrible climber.");
                break;
            }
            case "FOLLOW": {
                Story.print("Try using a direction instead. For example, you can type GO NORTH.");
                break;
            }
            case "RESTART": {
                Data.confirmNewGame();
                break;
            }
            case "SAVE": {
                Data.attemptToSaveGame();
                break;
            }
            case "RESTORE": {
                Data.attemptToRestoreGame();
                break;
            }
            default: {
                Story.invalid();
            }
        }
        World.eventAtEnd();
    }
}

