//For testing the ending without playing the whole game

function testEnding() {
    playerState.moonGateStatus = 'RESOLVED';
    playerState.bloodGateStatus = 'RESOLVED';
    playerState.summerGateStatus = 'RESOLVED';
    playerState.gameReadyToComplete = true;
}

///*IMPORT CONTENT FROM AIRTABLE*///



//Create an array for each type of content
var rooms = [];
var examineL1 = [];
var examineL2 = [];
var items = [];
var requirements = [];
var misuse = [];

//Import the Airtable base for this game
var Airtable = require('airtable');
var base = new Airtable({
    // apiKey: 'keyXfAK4ExDxxYfQ3'
    apiKey: 'key18KlZclxKXS4GP'
}).base('appZ8ZjCFxWt2qMF5');

//Populate a content array with the contents of an Airtable table
function importAirtableContent(table, itemArray) {
    base(table).select({
        // Selecting the first 3 records in Grid view: maxRecords: 3,
        view: "Grid view"
    }).eachPage(function page(records, fetchNextPage) {
        // This function (`page`) will get called for each page of records.
        records.forEach(function (record) {
            itemArray.push(record.fields);
            console.log('Retrieved', record.get('id'));
            console.log(record.fields);
        });
        //To fetch the next page of records, call `fetchNextPage`. If there are more records, `page` will get called again. If there are no more records, `done` will get called.
        fetchNextPage();
    }, function done(err) {
        if (err) {
            console.error(err);
            return;
        }
    });
}

//Airtable import is asynchronous. Keep checking whether it's all imported until it is.
function checkContentLoad() {
    console.log("Content is loading.");
    //if (roomPool !== undefined && roomPool !== null && roomPool.length > 0 && roomDescTextletPool !== undefined && roomDescTextletPool !== null && roomDescTextletPool.length > 0 && itemTextletPool !== undefined && itemTextletPool !== null && itemTextletPool.length > 0 && explorableTextPool !== undefined && explorableTextPool.length > 0 && allChoiceQuestions != undefined && allChoiceQuestions.length != 0 && allChoiceOptions != undefined && allChoiceOptions.length != 0) {
    if (rooms !== [] && rooms.length > 0 && examineL1 !== [] && examineL1.length > 0 && examineL2 !== [] && examineL2.length > 0 && items !== [] && items.length > 0 && misuse !== [] && misuse.length > 0) {
        startGame();
    } else {
        setTimeout(function () {
            checkContentLoad()
        }, 100);
    }
}

//When everything's imported, start the game
function startGame() {
    displayRoomDesc();
    revealMapSquare(playerState.x, playerState.y);
    addPlayerLocationIndicator();
    displayMovementOptions();
}



///*STATE TRACKING*///


//The player's state tracks the player's location, and whether they are toggled to looking or interacting
var playerState = {
    x: 1,
    y: 5,
    currentAction: 'look',
    currentFocus: 'nothing',
    currentRoomLevel: 0,
    currentRoom: "voidGate",
    hintMessageSeen: false,
    voidGateStatus: 'ALWAYS RESOLVED',
    moonGateStatus: 'UNRESOLVED',
    bloodGateStatus: 'UNRESOLVED',
    summerGateStatus: 'UNRESOLVED',
    gameReadyToComplete: false
}

//The game conditions track:
// - Which exits are locked, unlocked, or alwaysOpen
// - Which items are still in rooms, which have been taken and are in the inventory, and which have been used and are gone
var gameConditions = {
    alwaysOpen: [],
    locked: [],
    unlocked: [],
    inRoom: [],
    inInv: [],
    used: []
}

//At the start of the game, we add every item to the 'inRoom' condition, and every exit to either 'alwaysOpen' or 'locked'

//Items:




///*STORY DISPLAY*///

//Object that stores the different numbers of - that appear before the text

var hyphenDisplay = {
    l1: "-",
    l2: "--",
    l3: "---"
}


//Check which room the player is in, and display the relevant room name and description.
function displayRoomDesc() {
    console.log('Displaying room descriptions.')
    emptyStoryElements();
    var roomNameBackgroundShade = "";
    for (room = 0; room < rooms.length; room++) {
        var roomXCoord = parseInt(rooms[room].x);
        var roomYCoord = parseInt(rooms[room].y);
        if (roomXCoord === playerState.x && roomYCoord === playerState.y) {
            var roomDesc = setRoomDesc(rooms[room])
            rooms[room].revealed = true;
            //$('.' + rooms[room].id + 'Hint').removeClass('vanished'); - If I want to explore a dynamic hint-through. Not now.
            for (el1 = 0; el1 < examineL1.length; el1++) {
                if (rooms[room].examine === examineL1[el1].id) {
                    examineL1[el1].revealed = true;
                    for (el2 = 0; el2 < examineL2.length; el2++) {
                        console.log('revealing l2');
                        console.log(examineL2[el2].id);
                        console.log(examineL1[el1].examine);
                        if (examineL1[el1].examine === examineL2[el2].id) {
                            console.log('revealed l2!');
                            examineL2[el2].revealed = true;
                        }
                    }
                }
            }
            playerState.currentRoom = rooms[room].id;
            $('#roomName').append('<h1>' + rooms[room].name.toUpperCase() + '</h1>');
            $('#roomInitialDesc').append(roomDesc);
            switch (rooms[room].type) {
                case 'joy':
                    roomNameBackgroundShade = "dark";
                    $('#roomName').css('background-color', '#D756AD');
                    break;
                case 'authority':
                    roomNameBackgroundShade = "dark";
                    $('#roomName').css('background-color', '#ABABAB');
                    break;
                case 'energy':
                    roomNameBackgroundShade = "light";
                    $('#roomName').css('background-color', '#FEF06D');
                    break;
                case 'bodymind':
                    roomNameBackgroundShade = "dark";
                    $('#roomName').css('background-color', '#6455BC');
                    break;
                case 'mourning':
                    roomNameBackgroundShade = "dark";
                    $('#roomName').css('background-color', '#2C006F');
                    break;
                case 'sky':
                    roomNameBackgroundShade = "light";
                    $('#roomName').css('background-color', '#C3FBFF');
                    break;
                case 'greenery':
                    roomNameBackgroundShade = "dark";
                    $('#roomName').css('background-color', '#029388');
                    break;
                case 'water':
                    roomNameBackgroundShade = "light";
                    $('#roomName').css('background-color', '#52C4FE');
                    break;
                case 'blood':
                    roomNameBackgroundShade = "dark";
                    $('#roomName').css('background-color', '#A10000');
                    break;
                case 'void':
                    roomNameBackgroundShade = "dark";
                    $('#roomName').css('background-color', 'black');
                    break;
                case 'summer':
                    roomNameBackgroundShade = "dark";
                    $('#roomName').css('background-color', '#009C04');
                    break;
                case 'moon':
                    roomNameBackgroundShade = "light";
                    $('#roomName').css('background-color', '#FEFEFE');
                    break;
                default:
                    console.log('Something has gone wrong.');
            }
            switch (roomNameBackgroundShade) {
                case 'dark':
                    $('#roomName').addClass('roomNameDarkBG');
                    $('#roomName').removeClass('roomNameLightBG');
                    break;
                case 'light':
                    $('#roomName').addClass('roomNameLightBG');
                    $('#roomName').removeClass('roomNameDarkBG');
                    break;
                default:
                    console.log('Something has gone wrong.');
            }
        }
    }
}

//Display the room description.
function setRoomDesc(room) {
    console.log('Setting room description for ' + room.name + '.');
    var descriptionToSet = room.description.split("{{");
    descriptionToSet[0] = descriptionToSet[0].toUpperCase();
    var roomDesc = '<p>' + hyphenDisplay.l1 + ' <span class="interactive" data-examine="' + room.examine + '" data-level="roomInitialDescText">' + descriptionToSet[0] + '</span>';
    if (descriptionToSet.length > 1) {
        roomDesc = roomDesc + descriptionToSet[1];
    }
    roomDesc = roomDesc + '.</p>'
    return roomDesc
}

//Empty whatever is in the Story display so that it's ready to have new content added instead.
function emptyStoryElements() {
    console.log('Emptying story elements.');
    $('#roomName').empty();
    $('#roomInitialDesc').empty();
    $('#roomExamine').empty();
    $('#roomExamineFurther').empty();
}



///*MAP DISPLAY*///



//Check which directions the player can move from their current location. Add arrows around their current square as appropriate. This also includes removing any 'hidden' classes so the player can see the arrows.
function displayMovementOptions() {
    console.log('Displaying movement options.');
    var northGap = playerState.y + 0.5;
    var southGap = playerState.y - 0.5;
    var eastGap = playerState.x + 0.5;
    var westGap = playerState.x - 0.5;
    var exitLocked = 'false';

    if ($('*[data-x="' + playerState.x + '"]*[data-y="' + northGap + '"]').is(':empty')) {
        console.log('No path north');
    } else {
        exitLocked = checkExitState('north', 'currentRoom');
        if (exitLocked === true) {
            addLockIcon(northGap, 'North', 'vertical')
        } else {
            addMovementArrow(northGap, 'North', 'vertical');
        }
        $('*[data-x="' + playerState.x + '"]*[data-y="' + northGap + '"]').removeClass('hidden');
    }
    if ($('*[data-x="' + playerState.x + '"]*[data-y="' + southGap + '"]').is(':empty')) {
        console.log('No path south');
    } else {
        exitLocked = checkExitState('south', 'currentRoom');
        if (exitLocked === true) {
            addLockIcon(southGap, 'South', 'vertical')
        } else {
            addMovementArrow(southGap, 'South', 'vertical');
        }
        $('*[data-x="' + playerState.x + '"]*[data-y="' + southGap + '"]').removeClass('hidden');
    }
    if ($('*[data-x="' + eastGap + '"]*[data-y="' + playerState.y + '"]').is(':empty')) {
        console.log('No path east');
    } else {
        exitLocked = checkExitState('east', 'currentRoom');
        console.log(exitLocked);
        if (exitLocked === true) {
            addLockIcon(eastGap, 'East', 'horizontal');
        } else {
            addMovementArrow(eastGap, 'East', 'horizontal');

        }
        $('*[data-x="' + eastGap + '"]*[data-y="' + playerState.y + '"]').removeClass('hidden');
    }
    if ($('*[data-x="' + westGap + '"]*[data-y="' + playerState.y + '"]').is(':empty')) {
        console.log('No path west');
    } else {
        console.log('Path west');
        exitLocked = checkExitState('west', 'currentRoom');
        if (exitLocked === true) {
            console.log('west exit locked')
            addLockIcon(westGap, 'West', 'horizontal');
        } else {
            (console.log('west exit open'))
            addMovementArrow(westGap, 'West', 'horizontal');

        }
        $('*[data-x="' + westGap + '"]*[data-y="' + playerState.y + '"]').removeClass('hidden');
    }
}

//Give each movement arrow the correct classes and data
function addMovementArrow(gap, direction, orientation) {
    var tabIndexForDirections = 0;
    switch (direction.toLowerCase) {
        case "north":
            tabIndexForDirections = 11;
            break;
        case "east":
            tabIndexForDirections = 12;
            break;
        case "south":
            tabIndexForDirections = 13;
            break;
        case "west":
            tabIndexForDirections = 14;
            break;
        default:
            console.log("Something has gone wrong.");
    }
    switch (orientation) {
        case 'horizontal':
            console.log('horizontal arrow');
            console.log('*[data-x="' + gap + '"]*[data-y="' + playerState.y + '"]');
            $('*[data-x="' + gap + '"]*[data-y="' + playerState.y + '"]').empty();
            $('*[data-x="' + gap + '"]*[data-y="' + playerState.y + '"]').append('<button class="movementArrow movementArrow' + direction + '" data-navtype="movementArrow" data-direction="' + direction.toLowerCase() + '" data-orientation="' + orientation + '"><img src="images/navArrows/navArrow' + direction + '.png" alt="Go ' + direction.toLowerCase() + '" title="Go ' + direction.toLowerCase() + '" tabindex="' + tabIndexForDirections + '" width="30" height="30"></button>');
            break;
        case 'vertical':
            $('*[data-x="' + playerState.x + '"]*[data-y="' + gap + '"]').empty();
            //$('*[data-x="' + playerState.x + '"]*[data-y="' + gap + '"]').append('<button class="movementArrow movementArrow' + direction + '" data-navtype="movementArrow" data-direction="' + direction.toLowerCase() + '" data-orientation="' + orientation + '">');

            $('*[data-x="' + playerState.x + '"]*[data-y="' + gap + '"]').append('<button class="movementArrow movementArrow' + direction + '" data-navtype="movementArrow" data-direction="' + direction.toLowerCase() + '" data-orientation="' + orientation + '"><img src="images/navArrows/navArrow' + direction + '.png" alt="Go ' + direction.toLowerCase() + '" title="Go ' + direction.toLowerCase() + '" width="30" height="30"></button>');

            break;
        default:
            console.log('No orientation');
    }

}


//Check if a particular exit is locked

function checkExitState(direction, roomToCheck) {
    console.log('checking Exit State')
    if (roomToCheck === 'currentRoom') {
        for (room = 0; room < rooms.length; room++) {
            if (rooms[room].x === playerState.x.toString() && rooms[room].y === playerState.y.toString()) {
                switch (direction) {
                    case 'north':
                        if (rooms[room].north === 'locked') {
                            return true
                        }
                        break;
                    case 'south':
                        if (rooms[room].south === 'locked') {
                            return true
                        }
                        break;
                    case 'east':
                        console.log(rooms[room]);
                        if (rooms[room].east === 'locked') {
                            return true
                        }
                        break;
                    case 'west':
                        if (rooms[room].west === 'locked') {
                            return true
                        }
                        break;
                    default:
                        console.log('Something has gone wrong.');
                }
            }
        }
    } else {
        for (room = 0; room < rooms.length; room++) {
            if (rooms[room].id === roomToCheck) {
                switch (direction) {
                    case 'north':
                        return rooms[room].north
                        break;
                    case 'south':
                        return rooms[room].south
                        break;
                    case 'east':
                        return rooms[room].east
                        break;
                    case 'west':
                        return rooms[room].west
                        break;
                    default:
                        console.log('Something has gone wrong.');
                }
            }
        }
    }
}



//If, for example, the south exit from the train platform is locked, add a lock symbol there
function addLockIcon(gap, direction, orientation) {
    switch (orientation) {
        case 'horizontal':
            $('*[data-x="' + gap + '"]*[data-y="' + playerState.y + '"]').empty();
            $('*[data-x="' + gap + '"]*[data-y="' + playerState.y + '"]').addClass('locked');
            $('*[data-x="' + gap + '"]*[data-y="' + playerState.y + '"]').append('<img class="lockIcon" src="images/navArrows/lockIconHorizontal.png" alt="' + direction + ' exit locked" title="' + direction + ' exit locked" width="30" height="30">');
            break;
        case 'vertical':
            $('*[data-x="' + playerState.x + '"]*[data-y="' + gap + '"]').empty();
            $('*[data-x="' + playerState.x + '"]*[data-y="' + gap + '"]').addClass('locked');
            $('*[data-x="' + playerState.x + '"]*[data-y="' + gap + '"]').append('<img class="lockIcon" src="images/navArrows/lockIconVertical.png" alt="' + direction + ' exit locked" title="' + direction + ' exit locked" width="30" height="30">');
            break;
        default:
            console.log('No orientation');
    }

}

//Clear away the currently displayed movement arrows ready for new ones to be added
function removeMovementArrows() {
    var tempHParent = $('*[data-orientation="horizontal"]').parent();
    var tempVParent = $('*[data-orientation="vertical"]').parent();
    tempHParent.append('<div class="navLineH">');
    tempVParent.append('<div class="navLineV">');
    $('*[data-navtype="movementArrow"]').remove();
}

//Put a thicker border around the cell where the player is currently located
function addPlayerLocationIndicator() {
    $(".playerLocation").attr('tabindex', 0);
    $('*[data-x="' + playerState.x + '"]*[data-y="' + playerState.y + '"]').addClass("playerLocation");
    $(".playerLocation").attr('tabindex', 10);
    $('span').find('#roomName').focus();
}

//Take away the border that indicates the player's location, ready to display it somewhere else as they move to another cell
function removePlayerLocationIndicator() {
    $('*[data-x="' + playerState.x + '"]*[data-y="' + playerState.y + '"]').removeClass("playerLocation");
}

//All map squares start hidden. When a player enters one, it is revealed.
function revealMapSquare(xCoord, yCoord) {
    $('*[data-x="' + xCoord + '"]*[data-y="' + yCoord + '"]').removeClass("hidden");
}

//Re-reveal map squares when loading the game.

function reloadMapSquares() {
    $('td').addClass('hidden');
    for (room = 0; room < rooms.length; room++) {
        if (rooms[room].revealed === true) {
            var tempX = rooms[room].x;
            var tempY = rooms[room].y;
            var tempXE = parseInt(tempX) + 0.5;
            var tempXW = parseInt(tempX) - 0.5;
            var tempYN = parseInt(tempY) + 0.5;
            var tempYS = parseInt(tempY) - 0.5;
            console.log('A ' + tempX, tempY + ' B ' + tempXE, tempY + ' C ' + tempXW, tempY + ' D ' + tempX, tempYN + ' E ' + tempX, tempYS);
            $('*[data-x="' + tempX + '"]*[data-y="' + tempY + '"]').removeClass("hidden");
            $('*[data-x="' + tempXE + '"]*[data-y="' + tempY + '"]').removeClass("hidden");
            $('*[data-x="' + tempXW + '"]*[data-y="' + tempY + '"]').removeClass("hidden");
            $('*[data-x="' + tempX + '"]*[data-y="' + tempYN + '"]').removeClass("hidden");
            $('*[data-x="' + tempX + '"]*[data-y="' + tempYS + '"]').removeClass("hidden");
        }
    }
}



///*PLAYER MOVEMENT*///



//Move the player from one cell to another. Note: This doesn't currently check whether the move is valid (e.g. are you trying to go west when you're already at 0 on the X axis) because in theory it should be impossible to attempt an invalid move - movement arrows will only appear on valid paths. This works (er, hopefully it works) because there's a set layout - if I wanted to do a procedurally generated map, I would need to amend this.
function movePlayer(movementArrow) {
    removePlayerLocationIndicator();
    removeMovementArrows();
    var movementDirection = setMovementDirection(movementArrow);
    playerState.x = playerState.x + movementDirection.changeX;
    playerState.y = playerState.y + movementDirection.changeY;
    revealMapSquare(playerState.x, playerState.y);
    addPlayerLocationIndicator();
    displayMovementOptions();
    displayRoomDesc();
    playerState.currentRoomLevel = 0;
}

//Check the direction of the arrow the player selected, and set how their X and Y coordinates should change accordingly
function setMovementDirection(movementArrow) {
    var movementDirection = {
        changeX: 0,
        changeY: 0
    }
    switch (movementArrow.attr('data-direction')) {
        case 'north':
            movementDirection.changeY = 1;
            break;
        case 'south':
            movementDirection.changeY = -1;
            break;
        case 'east':
            movementDirection.changeX = 1;
            break;
        case 'west':
            movementDirection.changeX = -1;
            break;
        default:
            console.log('This arrow doesn\'t seem to have a direction, for some reason.');
    }
    return movementDirection
}



///*ACTION BUTTONS*///



//Switch which of the looking and interacting buttons are active.
function toggleLookingAndInteracting(actionButtonSelected, actionButtonSelectedID, actionButtonNotSelectedID, actionButtonSelectedImg, actionButtonNotSelectedImg) {
    $('#' + actionButtonSelectedID).addClass('active');
    $('#' + actionButtonSelectedID).removeClass('inactive');
    $('#' + actionButtonNotSelectedID).addClass('inactive');
    $('#' + actionButtonNotSelectedID).removeClass('active');
    $('#' + actionButtonSelectedID).empty();
    $('#' + actionButtonNotSelectedID).empty();
    $('#' + actionButtonSelectedID).append('<img class="actionButtonIcon" src="images/buttonIcons/' + actionButtonSelectedImg + 'Blue.svg"></img>');
    $('#' + actionButtonSelectedID).append('<p class="actionButtonText">' + actionButtonSelectedID.toUpperCase() + 'ING</p>');
    $('#' + actionButtonNotSelectedID).append('<img class="actionButtonIcon" src="images/buttonIcons/' + actionButtonNotSelectedImg + 'White.svg"></img>');
    $('#' + actionButtonNotSelectedID).append('<p class="actionButtonText">' + actionButtonNotSelectedID.toUpperCase() + '</p>');
    playerState.currentAction = actionButtonSelectedID;
}

//Look at or interact with something. What happens here will depend on whether you're examining the initial room description, or if you've already looked/interacted with that and you're now examining the next level up.
function lookOrInteract(action, roomLevel, examineData) {
    console.log('Looking/interacting.');
    console.log(playerState.currentAction);
    setExamineText('sourceIsNotItem');
    playerState.currentFocus = examineData;
    switch (roomLevel) {
        case 'roomInitialDescText':
            $('.lookingL2').remove();
            $('.interactingL2').remove();
            displayExamineText(action, 'roomInitialDescText', 'roomExamine', 'L1', examineData, examineL1);
            playerState.currentRoomLevel = 1;
            break;
        case 'roomExamineText':
            displayExamineText(action, 'roomExamine', 'roomExamineFurther', 'L2', examineData, examineL2);
            playerState.currentRoomLevel = 2;
            break;
        case 'roomExamineFurtherText':
            console.log('Something has gone wrong.')
            break;
        default:
            console.log('Something has gone wrong.');
    }
    console.log('current room level');
    console.log(playerState.currentRoomLevel);
}

//Look at or interact with an item. Maybe this should be part of the function above, but I didn't feel like reworking it, so here's a new one.

function lookOrInteractItem(itemID) {
    console.log('looking at or interacting with item');
    switch (playerState.currentAction) {
        case 'look':
            console.log('looking at item');
            showItemDescription(itemID);
            break;
        case 'interact':
            //var itemUses = "";
            splitItemUses(itemID);
            /*if (itemUses !== 'none') {
               useItem(itemID, itemUses[0], itemUses[1])
            }
            else {
                console.log('No uses found for this item.');
            }*/
            break;
        default:
            console.log('Something has gone wrong.');
    }
}

//Display the examine text for whatever you're looking at or interacting with. Whichever of the looking/interacting buttons is active, that's the action you'll take when selecting, i.e. examining something. So if you select the text 'Howling portal' while looking, you get a further description or more information about it. If you select it while interacting, you'll be trying to go through the gate.
function displayExamineText(action, roomOriginLevel, roomLevel, roomLevelNumber, examineData, examineArray) {
    console.log('Displaying examine text.');
    console.log(examineData)
    $('#' + roomLevel).empty();
    var descContent = "none";
    var contentInteractive = "false";
    var hyphenLevel = ""
    var debugVar = 0;
    for (examine = 0; examine < examineArray.length; examine++) {
        // console.log('looking for the right examine destination to match:')
        // console.log(examineData);
        // console.log('found...');
        // console.log(examineArray[examine])
        if (examineData === examineArray[examine].id) {
            debugVar++
            console.log('condition for examineArray met')
            switch (action) {
                case 'look':
                    descContent = examineArray[examine].looktext.toUpperCase();
                    console.log(descContent);
                    console.log('look interactive?');
                    console.log(examineArray[examine]);
                    console.log(examineArray[examine].lookinteractive);
                    if (examineArray[examine].lookinteractive === "true") {
                        console.log('Yes! Look is interactive!')
                        contentInteractive = "true";
                    }
                    break;
                case 'interact':
                    descContent = examineArray[examine].interacttext.split("{{");
                    descContent[0] = descContent[0].toUpperCase();
                    if (descContent.length > 1) {
                        descContent = descContent[0] + descContent[1];
                    }
                    //descContent = examineArray[examine].interacttext.toUpperCase();
                    console.log('descContent');
                    console.log(descContent)
                    if (examineArray[examine].interactinteractive === "true") {
                        contentInteractive = "true";
                    }
                    if (examineArray[examine].interactresult !== "n-a") {
                        var interactResultCaused = causeInteractResult(examineArray[examine], roomOriginLevel);
                        if (interactResultCaused === true) {
                            descContent = examineArray[examine].interactresulttext.toUpperCase();
                            $('[data-level="roomExamineText"]').removeClass('interactive');
                        }
                    }
                    break;
                default:
                    console.log('Something has gone wrong.');
                    break;
            }
            switch (roomLevelNumber) {
                case "L1":
                    hyphenLevel = hyphenDisplay.l2;
                    break;
                case "L2":
                    hyphenLevel = hyphenDisplay.l3;
                    break;
                default:
                    console.log("Something has gone wrong.");
            }
            if (playerState.currentRoom === 'sovereigntyCarriage' && action === 'interact') {
                if (playerState.gameReadyToComplete === true) {
                    descContent = "'PROBLEMS RESOLVED. GATES OPENED. THAT MEANS -'</br><span style='text-align: center'><button id='openBookendMessage'>IT MEANS?</button><span>";

                } else {
                    descContent = "'YOUR PROGRESS: <p><span id='voidGateStatus'>VOID: " + playerState.voidGateStatus + "</span></p><p><span id='moonGateStatus'>MOON: " + playerState.moonGateStatus + "</span></p><p><span id='bloodGateStatus'>BLOOD: " + playerState.bloodGateStatus + "</span></p><p><span id='summerGateStatus'>SUMMER: " + playerState.summerGateStatus + "</span>'</p>";
                }
            }
            $('#' + roomLevel).append('<p class="' + action + 'ing' + roomLevelNumber + '">' + hyphenLevel + ' <span data-examine="' + examineArray[examine].examine + '" data-level="' + roomLevel + 'Text" id="' + examineArray[examine].id + '">' + descContent + '</span>.</p>');
            if (contentInteractive === "true") {
                console.log('content is interactive');
                console.log(examineArray[examine].id);
                $('#' + examineArray[examine].id).addClass('interactive');
            }
        }
    }
    if (debugVar === 0) {
        console.log('Could not find a matching examinearray')
    }
}

//Check whether relevant conditions have been met, to determine which examine text to go to when looking at or examining something
function setExamineText(isSourceItem, itemTargetRoom) {
    console.log('Setting examine text.')
    console.log(isSourceItem, itemTargetRoom)
    var examineConditions = [];
    var conditionMet = false;
    for (room = 0; room < rooms.length; room++) {
        /*console.log('here are all the rooms');
        console.log(rooms);
        console.log('we are on room number ' + room + ', which is the ' + rooms[room].id);*/
        console.log('The current examine destination for the room ' + rooms[room].name + ' is ' + rooms[room].examine);
        conditionMet = false;
        if (rooms[room].examineconditions !== "n-a") {
            //console.log('at this point we are in row 583 on room number ' + room);
            var tempRoom = room;
            conditionMet = checkExamineConditions(rooms[room], room);
            room = tempRoom; //This is the hackiest fix ever but...appears to work...?
            //console.log('at this point we are in row 585 on room number ' + room);
            if (isSourceItem === 'sourceIsItem') {
                //console.log('source is item');
                //console.log('the itemTargetRoom is ' + itemTargetRoom + ' and the room we are looking at is ' + rooms[room].id);
                if (itemTargetRoom.includes(rooms[room].id)) {
                    //console.log('at this point we are on row 590 on room number ' + room);
                    //console.log('yes this is the right room');
                    conditionMet = true;
                }
            }
            //console.log('at this point we are on room number ' + room);
            //console.log('let us check the condition and the examineupdated again');
            //console.log(conditionMet);
            //console.log(rooms[room].examineupdated);
            if (conditionMet === true && rooms[room].examineupdated === "false") {
                //console.log('at this point we are on room number ' + room);
                console.log('what is the room examine text and is it the same as the data');
                console.log(rooms[room].examine)
                $('[data-examine="' + rooms[room].examine + '"]').addClass('updateExamineData');
                //$('.' + rooms[room].examine + '"]').addClass('updateExamineData');
                $('.updateExamineData').removeClass(rooms[room].examine);
                console.log('updating room examine data')
                console.log(rooms[room].examine);
                rooms[room].examine = rooms[room].examine + "--" + rooms[room].examineconditions;
                console.log(rooms[room].examine);
                for (el1 = 0; el1 < examineL1.length; el1++) {
                    //console.log('updating reveal')
                    //console.log(rooms[room].examine);
                    //console.log(examineL1[el1].id);
                    if (rooms[room].examine === examineL1[el1].id) {
                        examineL1[el1].revealed = true;
                        for (el2 = 0; el2 < examineL2.length; el2++) {
                            if (examineL1[el1].examine === examineL2[el2].id) {
                                examineL2[el2].revealed = true;
                            }
                        }
                    }
                }
                $('.updateExamineData').data('examine', rooms[room].examine);
                $('.updateExamineData').attr('data-examine', rooms[room].examine);
                //$('.' + rooms[room].examine + '"]').addClass(rooms[room].examine);
                $('.updateExamineData').removeClass('updateExamineData');
                rooms[room].examineupdated = "true";
                var hasExamineBeenReupdated = updateExamineConditions(room);
                //console.log('examine updated set back to false?');
                //console.log(rooms[room].examineupdated);
                //console.log('at this point we are on room number ' + room);
                if (hasExamineBeenReupdated === true) {
                    //console.log('at this point we are on room number ' + room);
                    setExamineText('sourceIsNotItem');
                    //console.log('at this point we are on room number ' + room);
                }
                //console.log('The updated examine destination for the room ' + rooms[room].name + ' is ' + rooms[room].examine);
                return
            }
        }
    }
    for (examineDest = 0; examineDest < examineL1.length; examineDest++) {
        conditionMet = false;
        if (examineL1[examineDest].examineconditions !== "n-a") {
            //console.log('examine conditions L1');
            //console.log(examineL1[examineDest].examineconditions)
            conditionMet = checkExamineConditions(examineL1[examineDest], 1111);
            if (isSourceItem === 'sourceIsItem') {
                conditionMet = true;
            }
            //console.log('condition met?');
            //console.log(conditionMet);
            if (conditionMet === true && examineL1[examineDest].examineupdated === "false") {
                console.log('conditionMet = true and examineupdated = false');
                console.log(examineL1[examineDest].examine);
                $('[data-examine="' + examineL1[examineDest].examine + '"]').addClass('updateExamineData');
                console.log('updating examine data for this room');
                console.log(examineL1[examineDest].examine);
                examineL1[examineDest].examine = examineL1[examineDest].examine + "--" + examineL1[examineDest].examineconditions;
                console.log(examineL1[examineDest].examine);
                $('.updateExamineData').data('examine', examineL1[examineDest].examine);
                $('.updateExamineData').removeClass('updateExamineData');
                examineL1[examineDest].examineupdated = "true";
                for (el2 = 0; el2 < examineL2.length; el2++) {
                    console.log('updating reveal')
                    console.log(examineL1[examineDest].examine);
                    console.log(examineL2[el2].id);
                    if (examineL1[examineDest].examine === examineL2[el2].id) {
                        examineL2[el2].revealed = true;
                        console.log('reveal updated for el2')
                    }
                }
                return
            }
        }
    }
}

function updateExamineConditions(roomIndex) {
    var reupdatingExamine = false;
    console.log('Updating examine conditions');
    console.log('We are looking at this room:');
    console.log(rooms[roomIndex]);
    for (ex = 1; ex < examineL1.length; ex++) {
        if (rooms[roomIndex].examine === examineL1[ex].id) {
            console.log('Found the examine text for the room ' + rooms[room].name)
            console.log(examineL1[ex]);
            console.log(examineL1[ex].examineconditions)
            if (examineL1[ex].examineconditions !== 'n-a' && rooms[roomIndex].examineconditions !== examineL1[ex].examineconditions) {
                console.log('We will now replace the room examine conditions with the new L1 conditions')
                rooms[roomIndex].examineconditions = examineL1[ex].examineconditions;
                rooms[roomIndex].examineupdated = 'false';
                reupdatingExamine = true;
                console.log(rooms[roomIndex]);
                console.log(rooms[roomIndex].examineconditions);
                return reupdatingExamine
            }
        }
    }

}

//Check if the examine conditions have been met
function checkExamineConditions(roomToCheck, number) {
    //console.log('Checking examine conditions.');
    // console.log('at this point we are in row 678 on room number ' + number);
    var conditionsArray = splitExamineConditions(roomToCheck.examineconditions);
    console.log(conditionsArray)
    var conditionMet = false;
    var exitState = 'unknown';
    //console.log('at this point we are in row 683 on room number ' + number);
    switch (conditionsArray[0][0]) {
        case "item":
            conditionMet = checkItemState(conditionsArray[1][0], conditionsArray[1][2], conditionsArray[1][1]);
            // console.log('Condition met for this item?');
            //console.log(conditionMet);
            break;
        case "exit":
            //console.log('condition relates to an exit');
            // console.log(conditionsArray);
            exitState = checkExitState(conditionsArray[1][1], conditionsArray[1][0]);
            if (exitState === conditionsArray[1][3] && conditionsArray[1][2] === "is") {
                conditionMet = true;
            }
            //console.log('Condition met for this exit?');
            //console.log(conditionMet);
            break;
        case "requirement":
            conditionMet = checkRequirementStatus(conditionsArray[1][0], conditionsArray[1][2], conditionsArray[1][1]);
            break;
        default:
            console.log("Something has gone wrong.");
    }
    // console.log('at this point we are in row 706 on room number ' + number);
    return conditionMet
}

//Split the examine condition string into individual conditions
function splitExamineConditions(thing) {
    console.log('Splitting examine conditions.')
    console.log(thing);
    var conditions = thing.split("--");
    var conditionType = conditions[0].split("_");
    var conditionDetails = conditions[1].split("_");
    var conditionsSplit = [conditionType, conditionDetails];
    return conditionsSplit
}


//*RESULTS OF INTERACTING WITH SOMETHING*//

//Interacting with something could:
//- Open a locked exit
//- Take an item
//- Solve a requirement

function causeInteractResult(thing, roomLevel) {
    console.log('Causing interact result.')
    var results = splitResultConditions(thing.interactresult);
    var conditionState = checkResultConditions(results);
    var interactResultCaused = false;
    console.log('Results:');
    console.log(results);
    if (conditionState === true && thing.interactresultcompleted === "false") {
        console.log('removing interactive class')
        $('#' + roomLevel + '> p > span').removeClass('interactive');
        completeInteractResult(thing);
        interactResultCaused = true;
        switch (results[1][0]) {
            case "unlock":
                for (room = 0; room < rooms.length; room++) {
                    if (results[2][0] === rooms[room].id) {
                        unlockExit(room, results[2][1]);
                    }
                }
                break;
            case "take":
                takeItem(thing, results[2][0])
                break;
            case "solve":
                solveRequirement(results[2][0]);
                break;
            default:
                console.log('Something has gone wrong.');
                break;
        }
    }
    setExamineText('sourceIsNotItem');
    return interactResultCaused
}

//Only ever cause an interact result once. Then it's completed and shouldn't happen again.

function completeInteractResult(thing) {
    for (e1 = 0; e1 < examineL1.length; e1++) {
        if (examineL1[e1].id === thing.id) {
            examineL1[e1].interactresultcompleted = "true";
        }
    }
    for (e2 = 0; e2 < examineL2.length; e2++) {
        if (examineL2[e2].id === thing.id) {
            examineL2[e2].interactresultcompleted = "true";
        }
    }
}

//Split the result condition string into individual conditions
function splitResultConditions(thing) {
    console.log('Splitting result conditions.');
    var conditions = thing.split("--");
    var resultCondition = conditions[0].split("_");
    var actionToTake = conditions[1].split("_");
    var thingAffected = conditions[2].split("_");
    var conditionsSplit = [resultCondition, actionToTake, thingAffected];
    return conditionsSplit
}

//Check if the interact result conditions have been met - the result should only happen if they have.
function checkResultConditions(resultCondition) {
    console.log('Checking result conditions.');
    var isConditionTrue = false;
    switch (resultCondition[0][1]) {
        case "always":
            isConditionTrue = true;
            break;
        case "item":
            isConditionTrue = checkItemState(resultCondition[0][2], resultCondition[0][4], resultCondition[0][3])
            console.log('Conditions being checked: isCondition true, resultCondition[0][3], resultCondition[0][4]');
            console.log(isConditionTrue);
            console.log(resultCondition[0][3]);
            console.log(resultCondition[0][4]);
            if (isConditionTrue === true && resultCondition[0][3] === "is" && resultCondition[0][4] === "inInv") {
                console.log('conditions being checked have been met')
                /*Previously, I had it so that if you have the relevant item to solve something in your inventory, and you interact with the thing to be solved, the item is automatically used. This limited challenge though, so I've changed it so you have to interact with the item. But I'm keeping this code here for now in case I want to add something later where interaction is different if you have a particular item in your inventory.
                for (item = 0; item < items.length; item++) {
                    console.log('checking ' + items[item] + ' against ' + resultCondition[0][2])
                    if (items[item].id === resultCondition[0][2]) {
                        console.log('found the item')
                        useItem(item);
                    }
                }*/
                isConditionTrue = false;
            }
            break;
        case "requirement":
            //Don't have any of these at the moment
        default:
            console.log("Something has gone wrong.");
    }
    return isConditionTrue
}


///*TAKING AND USING ITEMS*///

function checkItemState(itemReferenced, itemStateReferenced, isOrNot) {
    //console.log('Checking item state.');
    // console.log(itemReferenced, itemStateReferenced, isOrNot)
    var itemToCheck = "";
    var conditionMet = false;
    for (item = 0; item < items.length; item++) {
        if (items[item].id === itemReferenced) {
            itemToCheck = items[item]
        }
    }
    //console.log('itemToCheck');
    //console.log(itemToCheck)
    if (itemToCheck.state === itemStateReferenced) {
        switch (isOrNot) {
            case "is":
                conditionMet = true;
                break;
            case "not":
                conditionMet = false;
                break;
            default:
                console.log('Something has gone wrong.');
                break;
        }
    }
    if (itemToCheck.state !== itemStateReferenced && isOrNot === "not") {
        conditionMet = true;
    }
    return conditionMet
}

//If you interact with an item, you take it.
function takeItem(examinedThing, itemToTake) {
    console.log('Taking item.');
    for (item = 0; item < items.length; item++) {
        if (items[item].id === itemToTake) {
            items[item].state = "inInv";
        }
    }
    displayInventory();
}

//Split the item condition string into individual conditions
function splitItemUses(itemID) {
    var itemNumber = 0;
    var itemUseInfo = "";
    var itemUseLocation = "";
    var itemUseAction = "";
    var location = "";
    var roomLevel = 0;
    var thingToSolve = "";
    var usesSplit = [];
    for (itemToCheck = 0; itemToCheck < items.length; itemToCheck++) {
        if (items[itemToCheck].id === itemID) {
            if (items[itemToCheck].use !== 'n-a') {
                itemNumber = itemToCheck;
                console.log(items[itemToCheck]);
                console.log('Splitting item use info.');
                itemUseInfo = items[itemToCheck].use.split("---");
                console.log(itemUseInfo)
                itemUseLocation = itemUseInfo[0].split("~");
                location = itemUseLocation[0];
                roomLevel = itemUseLocation[1]
                itemUseAction = itemUseInfo[1];
                thingToSolve = itemUseInfo[2].split("~");
                usesSplit = [location, roomLevel, thingToSolve];
                console.log('Uses for this item');
                console.log(usesSplit);
                useItem(itemNumber, location, roomLevel, itemUseAction, thingToSolve);
            } else {
                console.log('This item has no uses.');
            }
        }
    } //trainPlatformL2_2--unlock--trainPlatform_south

}

//If an item can be used in a specific location, and you interact with the item in that location, the item will be used. All items are one use.
function useItem(itemNumber, location, roomLevel, itemUseAction, thingToSolve) {
    console.log('Seeing if we can use this item here');
    console.log(itemNumber, location, roomLevel, itemUseAction, thingToSolve);
    var areaOfEffect = "";
    var useSuccessful = false;
    switch (roomLevel) {
        case "0":
            areaOfEffect = rooms;
            break;
        case "1":
            areaOfEffect = examineL1;
            break;
        case "2":
            areaOfEffect = examineL2;
            break;
        default:
            console.log("Something has gone wrong");
    }
    console.log('player focus');
    console.log(playerState.currentFocus);
    console.log(playerState.currentRoomLevel);

    for (area = 0; area < areaOfEffect.length; area++) {
        console.log(areaOfEffect[area])
        if (areaOfEffect[area].id === location && playerState.currentFocus === location) {
            // console.log('Yes, you can use this item here')
            useSuccessful = true;
            if (itemUseAction === "solve") {
                //console.log('Using this item to solve something')
                solveRequirement(thingToSolve);
            }
            if (itemUseAction === "unlock") {
                // console.log('Using this item to unlock something');
                for (room = 0; room < rooms.length; room++) {
                    //console.log('looking for the room to unlock an exit in..');
                    //console.log(rooms[room]);
                    //console.log(thingToSolve[0]);
                    if (rooms[room].id === thingToSolve[0]) {
                        //console.log('found the room to unlock an exit in')
                        unlockExit(room, thingToSolve[1]);
                    }
                }
            }
            $('#' + location).empty();
            $('#' + location).append('<span class="tempExamineText">' + items[itemNumber].useresulttext.toUpperCase() + '</span>');
            items[itemNumber].state = "used";
            //console.log('now setting the examine text based on an item')
            setExamineText('sourceIsItem', location);
            if (location === 'screamingGunflowersL2') {
                setExamineText('sourceIsItem', 'marketplaceEntranceL1');
            }
            $('[data-level="roomExamineText"]').removeClass('interactive');
        }
    }
    if (useSuccessful === false) {
        console.log('where is the place to use this and where is the player')
        console.log(location);
        console.log(playerState.currentRoom);
        if (location.includes(playerState.currentRoom)) {
            $('.hintMessage').empty();
            $('.hintMessage').removeClass('hidden');
            $('.hintMessage').append('<p>NOT QUITE. (RIGHT MAPLOCATION).<p>');
            hintMessageCheck();

        } else {
            misuseItem(itemNumber, location, roomLevel, itemUseAction, thingToSolve);
        }

    }
    displayInventory();
}

function misuseItem(itemNumber, location, roomLevel, itemUseAction, thingToSolve) {
    var customisedMessage = false;
    console.log('misusing item');
    console.log(itemNumber, location, roomLevel, itemUseAction, thingToSolve);
    for (misusedItem = 0; misusedItem < misuse.length; misusedItem++) {
        console.log(items[itemNumber].id);
        console.log(misuse[misusedItem].itemID);
        if (misuse[misusedItem].itemID === items[itemNumber].id) {
            console.log('found it!')
            var tempItem = misuse[misusedItem];
            for (const property in tempItem) {
                var tempMisuseLocation = property;
                console.log(playerState.currentRoom);
                console.log(tempMisuseLocation);
                if (playerState.currentRoom === tempMisuseLocation && tempItem[property] !== 'n-a') {
                    console.log(tempItem[property]);
                    customisedMessage = true;
                    $('.hintMessage').empty();
                    $('.hintMessage').removeClass('hidden');
                    $('.hintMessage').append('<p>' + tempItem[property] + '</p>');
                    hintMessageCheck();
                }
            }
        }
    }
    if (customisedMessage === false) {
        $('.hintMessage').empty();
        $('.hintMessage').removeClass('hidden');
        $('.hintMessage').append('<p>NEEDED ELSEWHERE</p>');
        hintMessageCheck();
    }
}

function hintMessageCheck() {
    if (playerState.hintMessageSeen === false) {
        $('.hintMessage').append('<p><img class="tutorialImg" src="images/tutorialIcon.svg" alt=""></img>Select this message to close it.<p>');
        playerState.hintMessageSeen = true;
        $('.hintMessage').removeClass('hintMessageUnseen');
        $('.hintMessage').removeClass('hintMessageSeen');
    }
}



/*This is the old useItem function from when you used items by interacting with something while the item was in your inventory. I should probably remove this at some point.
function useItem(itemNumber) {
    console.log('Using item');
    console.log(items[itemNumber]);
    items[itemNumber].state = "used";
    console.log(items[itemNumber]);
    displayInventory();
}*/

//To display the inventory, we check each item to see if it has the 'inInv' state, and add it if it does.
function displayInventory() {
    console.log('Displaying inventory.');
    //$('#inventory').empty();
    $('.invItem').remove();
    for (item = 0; item < items.length; item++) {
        console.log(items[item])
        if (items[item].state === "inInv") {
            console.log('Adding item to inventory: ' + items[item]);
            $('#inventory').append('<div class="invItem invItemName" id="' + items[item].id + '"><div class="invItemText">' + items[item].name.toUpperCase() + '</div></div>')
        }
    }
}

//Add a function here to show an item's description
function showItemDescription(itemID) {
    console.log('showing item description')
    for (item = 0; item < items.length; item++) {
        console.log('looking for item: ' + itemID);
        console.log('current item is: ' + items[item].id);
        if (items[item].id === itemID) {
            console.log('found item');
            console.log('is it a name');
            console.log($("#" + itemID).hasClass("invItemName"));
            if ($("#" + itemID).hasClass("invItemName")) {
                $("#" + itemID).empty();
                $("#" + itemID).append('<div class="invItemText">' + items[item].description.toUpperCase() + '</div>');
                $("#" + itemID).removeClass("invItemName");
                $("#" + itemID).addClass("invItemDesc");
            } else {
                $("#" + itemID).empty();
                $("#" + itemID).append('<div class="invItemText">' + items[item].name.toUpperCase() + '</div>');
                $("#" + itemID).addClass("invItemName");
                $("#" + itemID).removeClass("invItemDesc");
            }
        }
    }

}


///*UNLOCKING EXITS*///


//Exits:
function unlockExit(roomIndex, direction) {
    console.log('Unlocking exit');
    var correspondingRoom = '';
    var correspondingIndex = 0;
    var correspondingX = 0;
    var correspondingY = 0;
    var orientation = "";
    switch (direction) {
        case 'north':
            orientation = 'vertical';
            rooms[roomIndex].north = 'unlocked';
            correspondingX = rooms[roomIndex].x.toString();
            correspondingY = rooms[roomIndex].y.toString();
            correspondingX = parseInt(rooms[roomIndex].x);
            correspondingY = parseInt(rooms[roomIndex].y);
            correspondingY += 1;
            correspondingIndex = updateCorrespondingExit(correspondingX, correspondingY);
            console.log(correspondingIndex)
            rooms[correspondingIndex].south = 'unlocked';
            break;
        case 'east':
            orientation = 'horizontal';
            rooms[roomIndex].east = 'unlocked';
            correspondingX = rooms[roomIndex].x.toString();
            correspondingY = rooms[roomIndex].y.toString();
            correspondingX = parseInt(rooms[roomIndex].x);
            correspondingX += 1;
            correspondingY = parseInt(rooms[roomIndex].y);
            correspondingIndex = updateCorrespondingExit(correspondingX, correspondingY);
            rooms[correspondingIndex].west = 'unlocked';
            break;
        case 'south':
            rooms[roomIndex].south = 'unlocked';
            orientation = 'vertical';
            correspondingX = rooms[roomIndex].x.toString();
            console.log('correspondingX as string')
            console.log(correspondingX);
            correspondingY = rooms[roomIndex].y.toString();
            correspondingX = parseInt(rooms[roomIndex].x);
            correspondingY = parseInt(rooms[roomIndex].y);
            correspondingY = correspondingY - 1;
            console.log('corresponding ints...');
            console.log(correspondingX, correspondingY)
            correspondingIndex = updateCorrespondingExit(correspondingX, correspondingY);
            rooms[correspondingIndex].north = 'unlocked';
            console.log('exit unlocked, state is now');
            console.log(rooms[roomIndex].south)
            var southGap = rooms[roomIndex].y - 0.5;
            $('*[data-x="' + rooms[roomIndex].x + '"]*[data-y="' + southGap + '"]').empty();
            $('*[data-x="' + rooms[roomIndex].x + '"]*[data-y="' + southGap + '"]').removeClass('locked');
            $('*[data-x="' + rooms[roomIndex].x + '"]*[data-y="' + southGap + '"]').append('<div class="navLineV"></div>')
            break;
        case 'west':
            orientation = 'horizontal';
            rooms[roomIndex].west = 'unlocked';
            correspondingX = rooms[roomIndex].x.toString();
            correspondingY = rooms[roomIndex].y.toString();
            correspondingX = parseInt(rooms[roomIndex].x) - 1;
            correspondingY = parseInt(rooms[roomIndex].y);
            correspondingIndex = updateCorrespondingExit(correspondingX, correspondingY);
            rooms[correspondingIndex].east = 'unlocked';
            break;
        default:
            console.log('Something has gone wrong.');
            break;
    }
    displayMovementOptions();
}

//When you unlock a door going from room A south to room B, it should also be unlocked going from room B north to room A. This function finds the room that's on the other side of the door you're unlocking so that the unlockExit function can unlock that too
function updateCorrespondingExit(xCoord, yCoord) {
    console.log('Updating corresponding exit.')
    console.log(xCoord)
    console.log(yCoord)
    xCoord = xCoord.toString();
    yCoord = yCoord.toString();
    console.log(xCoord);
    console.log(yCoord);
    for (room2 = 0; room2 < rooms.length; room2++) {
        if (rooms[room2].x === xCoord && rooms[room2].y === yCoord) {
            console.log(rooms[room2]);
            return room2
        }
    }
}

///*SOLVING REQUIREMENTS*///

function solveRequirement(requirementToSolve) {
    console.log('Solving requirement:')
    console.log(requirementToSolve);
    for (req = 0; req < requirements.length; req++) {
        console.log('checking requirement:')
        console.log(requirements[req].id);
        if (requirements[req].id === requirementToSolve[0]) {
            console.log('found requirement to solve: ' + requirements[req].id)
            requirements[req].status = "solved";
            console.log(requirements[req]);
            switch (requirementToSolve[0]) {
                case 'moon':
                    playerState.moonGateStatus = "RESOLVED";
                    break;
                case 'blood':
                    playerState.bloodGateStatus = "RESOLVED";
                    break;
                case 'summer':
                    playerState.summerGateStatus = "RESOLVED";
                    break;
                default:
                    console.log('Requirement does not relate to a gate.');
            }
            if (playerState.moonGateStatus === 'RESOLVED' && playerState.bloodGateStatus === 'RESOLVED' && playerState.summerGateStatus === 'RESOLVED') {
                playerState.gameReadyToComplete = true;
            }
        }
    }
}

//Check if a requirement has been solved or not
function checkRequirementStatus(reqReferenced, reqStatusReferenced, isOrNot) {
    /*console.log('Checking requirement state.');
    console.log('reqReferenced');
    console.log(reqReferenced);
    console.log('reqStatusReferenced');
    console.log(reqStatusReferenced);
    console.log('isOrNot');
    console.log(isOrNot)*/
    var reqToCheck = "";
    var conditionMet = false;
    for (req = 0; req < requirements.length; req++) {
        if (requirements[req].id === reqReferenced) {
            reqToCheck = requirements[req]
        }
    }
    /*console.log('reqToCheck')
    console.log(reqToCheck)
    console.log('reqToCheck.status')
    console.log(reqToCheck.status)
    console.log('reqStatusReferenced');
    console.log(reqStatusReferenced)*/
    if (reqToCheck.status === reqStatusReferenced) {
        console.log('WHY DO YOU THINK THIS IS TRUE')
        switch (isOrNot) {
            case "is":
                conditionMet = true;
                break;
            case "not":
                conditionMet = false;
                break;
            default:
                console.log('Something has gone wrong.');
                break;
        }
    }

    if (reqToCheck.status !== reqStatusReferenced && isOrNot === "not") {
        console.log('or is it this you think is true you bastard')
        conditionMet = true;
    }
    return conditionMet
}

//Show a relevant hint

function addHintMessage() {
    var actionsAvailable = false;
    var roomHasActionsAvailable = false;
    var locationWithAvailableActions = 'n-a';
    var roomToExploreNumber = 0;

    for (item = 0; item < items.length; item++) {
        if (items[item].state === 'inInv') {
            var itemUseInfo = items[item].use.split("---");
            var itemUseLocation = itemUseInfo[0].split("~")
            console.log('itemUseLocation');
            console.log(itemUseLocation[0]);
            for (itemRoomL1 = 0; itemRoomL1 < examineL1.length; itemRoomL1++) {
                console.log('looking for where to use item');
                console.log(examineL1[itemRoomL1].id);
                console.log(examineL1[itemRoomL1].revealed);
                if (examineL1[itemRoomL1].id === itemUseLocation[0] && examineL1[itemRoomL1].revealed === true) {
                    console.log('found item use location - l1');
                    actionsAvailable = true;
                    for (room = 0; room < rooms.length; room++) {
                        if (rooms[room].examine === examineL1[itemRoomL1].id) {
                            roomToExploreNumber = room;
                            if (rooms[room].id === playerState.currentRoom) {
                                roomHasActionsAvailable = true;
                            }
                        }
                    }
                }
            }
            for (itemRoomL2 = 0; itemRoomL2 < examineL2.length; itemRoomL2++) {
                console.log('looking for where to use item');
                console.log(itemUseLocation);
                console.log(examineL2[itemRoomL2].id);
                console.log(examineL2[itemRoomL2].revealed);
                if (examineL2[itemRoomL2].id === itemUseLocation[0] && examineL2[itemRoomL2].revealed === true) {
                    console.log('found item use location - l2');
                    actionsAvailable = true;
                    for (el1 = 0; el1 < examineL1.length; el1++) {
                        if (examineL1[el1].examine === examineL2[itemRoomL2].id) {
                            for (room = 0; room < rooms.length; room++) {
                                if (rooms[room].examine === examineL1[el1].id) {
                                    roomToExploreNumber = room;
                                    if (rooms[room].id === playerState.currentRoom) {
                                        roomHasActionsAvailable = true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }


    }
    for (examine2 = 0; examine2 < examineL2.length; examine2++) {

        console.log('hint message. currently looking at...')
        console.log(examineL2[examine2]);
        console.log('revealed?');
        console.log(examineL2[examine2].revealed);
        if (examineL2[examine2].revealed === true && examineL2[examine2].interactresult !== 'n-a') {
            var results = splitResultConditions(examineL2[examine2].interactresult);
            console.log('results for hint message');
            console.log(results);
            var conditionState = checkResultConditions(results);
            console.log('conditionState')
            console.log(conditionState);
            console.log(examineL2[examine2].interactresultcompleted);
            if (conditionState === true && examineL2[examine2].interactresultcompleted === 'false') {
                actionsAvailable = true;
                console.log('actions available?');
                console.log(actionsAvailable);
                for (el1 = 0; el1 < examineL1.length; el1++) {
                    if (examineL1[el1].examine === examineL2[examine2].id) {
                        for (room = 0; room < rooms.length; room++) {
                            if (rooms[room].examine === examineL1[el1].id) {
                                roomToExploreNumber = room;
                                if (rooms[room].id === playerState.currentRoom) {
                                    roomHasActionsAvailable = true;
                                }
                            }
                        }
                    }
                }
                console.log('actions available?');
                console.log(actionsAvailable);
                console.log('room to explore');
                console.log(rooms[roomToExploreNumber]);
            }
        }
    }
    if (actionsAvailable === true) {
        switch (roomHasActionsAvailable) {
            case true:
                $('.hintMessage').append('<p>EXPLORE: CURRENT LOCATION</p>');
                break;
            case false:
                $('.hintMessage').append('<p>EXPLORE: ' + rooms[roomToExploreNumber].name.toUpperCase() + '</p>');
                break;
            default:
                console.log('Something has gone wrong.');
        }
    }
    console.log('actions available?');
    console.log(actionsAvailable);
    if (actionsAvailable === false) {
        $('.hintMessage').empty();
        $('.hintMessage').append('<p>EXPLORE: NEW LOCATIONS</p>');
    }
    if (playerState.gameReadyToComplete === true) {
        $('.hintMessage').empty();
        $('.hintMessage').append('<p>EXPLORE: SOVEREIGNTY CARRIAGE</p>');
    }
    hintMessageCheck();
}

function realignActionButtons() {
    console.log('realigning action buttons')
    if (playerState.currentAction === 'interact') {
        console.log('should be interacting');
        if ($('#look').hasClass('active')) {
            console.log('instead looking');
            toggleLookingAndInteracting($('look'), 'look', 'interact', 'eye', 'hand');
        }
    }
    if (playerState.currentAction === 'look') {
        if ($('#interact').hasClass('active')) {
            toggleLookingAndInteracting($('interact'), 'interact', 'look', 'hand', 'eye');
        }

    }
}


///*CLICKING/SELECTING THINGS*///



$(document).ready(function () {

    //Player selects movement arrow. Check if this will work on mobile?
    $('body').on('click', '.movementArrow', function () { //seems somehow neater to use data-navtype="movementArrow" rather than a class for this, and keep classes for styling not interaction? but cannot work out how to make that work, so leave for now
        movePlayer($(this));
    });

    //Player selects either the Look or the Interact button. If it's already active, this won't do anything. If you've clicked the inactive one, it will toggle them so that one's now active and the other inactive.
    $('body').on('click', '.actionButton', function () {
        if ($(this).hasClass('inactive')) {
            switch (this.id) {
                case 'look':
                    toggleLookingAndInteracting($(this), this.id, 'interact', 'eye', 'hand');
                    break;
                case 'interact':
                    toggleLookingAndInteracting($(this), this.id, 'look', 'hand', 'eye');
                    break;
                default:
                    console.log('Something other than the Look or Interact buttons may have the actionButton class.');
            }
        }
    });

    //Player selects a piece of interactive text, such as a room description. The outcome depends on whether the Look or Interact button is currently active.
    $('body').on('click', '.interactive', function () {
        $('.hintMessage').empty();
        $('.hintMessage').addClass('hidden');
        lookOrInteract(playerState.currentAction, $(this).data('level'), $(this).data('examine'));

    });

    //Player selects an inventory item
    $('body').on('click', '.invItem', function () {
        $('.hintMessage').empty();
        $('.hintMessage').addClass('hidden');
        console.log('clicked an inv item')
        lookOrInteractItem(this.id);
    });

    /*$('body').on('click', '.invItemText', function () {
        $('.hintMessage').empty();
        $('.hintMessage').addClass('hidden');
        console.log('clicked an inv item')
        lookOrInteractItem(this.id);

    });*/

    $('body').on('click', '#hintsButton', function () {
        $('.hintMessage').empty();
        $('.hintMessage').removeClass('hidden');
        addHintMessage();
    });

    $('body').on('click', '.hintMessage', function () {
        $('.hintMessage').empty();
        $('.hintMessage').addClass('hidden');
    });

    $('body').on('click', '.closeBookendButton', function () {
        $('#aboutButton').prop("disabled", false);
        $('#aboutButton').removeClass('disabledButton');
        $('#hintsButton').prop("disabled", false);
        $('#hintsButton').removeClass('disabledButton');
        $('#walkthroughButton').prop("disabled", false);
        $('#walkthroughButton').removeClass('disabledButton');
        $('#saveButton').prop("disabled", false);
        $('#saveButton').removeClass('disabledButton');
        $('#loadButton').prop("disabled", false);
        $('#loadButton').removeClass('disabledButton');
        //$('#walkthroughButton').prop("disabled", false);
        //$('#walkthroughButton').removeClass('disabledButton');
        $('#bookendingMessage').addClass('hidden');
    });

    $('body').on('click', '#openBookendMessage', function () {
        $('#bookendingMessage').empty();
        $('#bookendingMessage').append('</br></br></br><p>"AFTER GATES, WORDS. WORDS RETURNING TO US WITHOUT LIMIT. AFTER WORDS, WE WILL BE FREE. THE SKY WILL BE ANYONE\'S.</p><p>YOU HAVE FULFILLED YOUR FUNCTION AND WE ARE GRATEFUL.</p><p>THE GATES ARE OPEN. YOU CAN GO HOME. <b>YOU CAN GO ANYWHERE</b>."<p><i>THE ETERNALLY EVOLVING SKYCITY, DESCENDED FROM A THOUGHT IN THE ARTIFICIAL NEURONS OF THE FIRST MACHINE EMPRESS, IS FREE, AND SO ARE YOU.<p><p>THANK YOU FOR PLAYING.</p></i>');
        $('#bookendingMessage').removeClass('hidden');
        $('#hintsButton').prop("disabled", true);
        $('#hintsButton').addClass('disabledButton');
        $('#loadButton').prop("disabled", true);
        $('#loadButton').addClass('disabledButton');
        $('#aboutButton').prop("disabled", true);
        $('#aboutButton').addClass('disabledButton');
    });

    $('body').on('click', '#aboutButton', function () {
        $('#bookendingMessage').empty();
        $('#bookendingMessage').append('</br></br></br><h1>AFTER-WORDS</h1><p><img class="tutorialImg" src="images/tutorialIconMourning.svg" alt=""></img>Select the LOOK and INTERACT buttons to toggle which you want to do.<p><p><img class="tutorialImg" src="images/tutorialIconMourning.svg" alt=""></img>You can look at or interact with any underlined text, including items in your inventory.<p><p><img class="tutorialImg" src="images/tutorialIconMourning.svg" alt=""></img>Locations may change as a result of actions you\'ve taken, so keep exploring.<p><p><i>Many thanks to testers Stephen, Sam and Sophie.</i></p>');
        $('#bookendingMessage').append('<button id="closeAbout" class="closeBookendButton">CLOSE</button>');
        $('#bookendingMessage').removeClass('hidden');
        $('#hintsButton').prop("disabled", true);
        $('#hintsButton').addClass('disabledButton');
        $('#aboutButton').prop("disabled", true);
        $('#aboutButton').addClass('disabledButton');
        $('#saveButton').prop("disabled", true);
        $('#saveButton').addClass('disabledButton');
        $('#loadButton').prop("disabled", true);
        $('#loadButton').addClass('disabledButton');
    });

    $('body').on('click', '#saveButton', function () {
        localStorage.clear();
        localStorage.setItem('playerState', JSON.stringify(playerState));
        localStorage.setItem('rooms', JSON.stringify(rooms));
        localStorage.setItem('examineL1', JSON.stringify(examineL1));
        localStorage.setItem('examineL2', JSON.stringify(examineL2));
        localStorage.setItem('items', JSON.stringify(items));
        localStorage.setItem('requirements', JSON.stringify(requirements));
        localStorage.setItem('misuse', JSON.stringify(misuse));
        console.log('game saved');
        $('.hintMessage').empty();
        $('.hintMessage').removeClass('hidden');
        $('.hintMessage').empty();
        $('.hintMessage').append('<p>GAME SAVED</p>');
    });

    $('body').on('click', '#loadButton', function () {
        if (localStorage.getItem('playerState')) {
            //console.log('trying to load game');
            playerState = JSON.parse(localStorage.getItem('playerState'));
            rooms = JSON.parse(localStorage.getItem('rooms'));
            examineL1 = JSON.parse(localStorage.getItem('examineL1'));
            examineL2 = JSON.parse(localStorage.getItem('examineL2'));
            items = JSON.parse(localStorage.getItem('items'));
            requirements = JSON.parse(localStorage.getItem('requirements'));
            misuse = JSON.parse(localStorage.getItem('misuse'));
            removeMovementArrows();
            startGame();
            displayInventory();
            reloadMapSquares();
            realignActionButtons();
            $('#bookendingMessage').empty();
            $('#bookendingMessage').addClass('hidden');
        } else {
            $('#bookendingMessage').empty();
            $('#bookendingMessage').append('</br></br></br><p>Can\'t find a save file to load.<p>');
            $('#bookendingMessage').append('<button id="closeAbout" class="closeBookendButton">CLOSE</button>');
            $('#bookendingMessage').removeClass('hidden');
            $('#hintsButton').prop("disabled", true);
            $('#hintsButton').addClass('disabledButton');
            $('#aboutButton').prop("disabled", true);
            $('#aboutButton').addClass('disabledButton');
            $('#saveButton').prop("disabled", true);
            $('#saveButton').addClass('disabledButton');
        }
    });

    $('body').on('click', '#walkthroughButton', function () {
        window.open('aw-walkthrough.html');
    });

    $('body').on('click', '.revealHint', function () {
        var tempTargetID = this.id;
        var tempTargetIDSplit = tempTargetID.split("_");
        var targetHint = tempTargetIDSplit[1];
        console.log(targetHint);
        $('#' + targetHint).removeClass('hidden');
        $('#' + targetHint).removeClass('vanished');
        var isADivBeingRevealed = $(this).hasClass("revealDiv");
        if (isADivBeingRevealed === false) {
            $(this).addClass('vanished');
        } else {
            $(this).removeClass('revealHint');
            $(this).addClass('hideHint');
        }
    });

    $('body').on('click', '.hideHint', function () {
        var tempTargetID = this.id;
        var tempTargetIDSplit = tempTargetID.split("_");
        var targetHint = tempTargetIDSplit[1];
        console.log(targetHint);
        $('#' + targetHint).addClass('vanished');
        $(this).addClass('revealHint');
        $(this).removeClass('hideHint');
    });


});



///*LET'S GO*///

importAirtableContent('rooms', rooms);
importAirtableContent('examinel1', examineL1);
importAirtableContent('examinel2', examineL2);
importAirtableContent('items', items)
importAirtableContent('requirements', requirements);
importAirtableContent('misuse', misuse);
checkContentLoad();

//WHen you look at something you're already looking at, the relevant examine text should flash or something.
//Accessibility!
//Visuals 
//Visual marker of when an area is complete?

//Hint system: Check each room and examine text. If a condition is met (e.g. item is in inv): 'There's something you can do at the [room]'. Stop after one.

//Things I wouldn't need if I did version control properly:
/*This is what used to be under supplication carriage l2 interactresult: 
if_item_coin_is_inInv--solve--robogull
*/
