/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHLHSPrimaryExpression;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHUnaryExpression
extends SimpleNode
implements ParserConstants {
    public int kind;
    public boolean postfix = false;

    BSHUnaryExpression(int n2) {
        super(n2);
    }

    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(0);
        if (simpleNode instanceof BSHLHSPrimaryExpression) {
            return this.lhsUnaryOperation(((BSHLHSPrimaryExpression)simpleNode).toLHS(callStack, interpreter));
        }
        return this.unaryOperation(simpleNode.eval(callStack, interpreter), this.kind);
    }

    private Object lhsUnaryOperation(LHS lHS) throws EvalError {
        Interpreter.debug("lhsUnaryOperation");
        Object object = lHS.getValue();
        Object object2 = this.unaryOperation(object, this.kind);
        Object object3 = this.postfix ? object : object2;
        lHS.assign(object2);
        return object3;
    }

    private Object unaryOperation(Object object, int n2) throws EvalError {
        if (object instanceof Boolean || object instanceof Character || object instanceof Number) {
            return this.primitiveWrapperUnaryOperation(object, n2);
        }
        if (!(object instanceof Primitive)) {
            throw new EvalError("Unary operation " + ParserConstants.tokenImage[n2] + " inappropriate for object", this);
        }
        return Primitive.unaryOperation((Primitive)object, n2);
    }

    private Object primitiveWrapperUnaryOperation(Object object, int n2) throws EvalError {
        Class<?> clazz = object.getClass();
        Object object2 = Primitive.promoteToInteger(object);
        if (object2 instanceof Boolean) {
            return new Boolean(Primitive.booleanUnaryOperation((Boolean)object2, n2));
        }
        if (object2 instanceof Integer) {
            int n3 = Primitive.intUnaryOperation((Integer)object2, n2);
            if (n2 == 89 || n2 == 90) {
                if (clazz == Byte.TYPE) {
                    return new Byte((byte)n3);
                }
                if (clazz == Short.TYPE) {
                    return new Short((short)n3);
                }
                if (clazz == Character.TYPE) {
                    return new Character((char)n3);
                }
            }
            return new Integer(n3);
        }
        if (object2 instanceof Long) {
            return new Long(Primitive.longUnaryOperation((Long)object2, n2));
        }
        if (object2 instanceof Float) {
            return new Float(Primitive.floatUnaryOperation((Float)object2, n2));
        }
        if (object2 instanceof Double) {
            return new Double(Primitive.doubleUnaryOperation((Double)object2, n2));
        }
        throw new InterpreterError("An error occurred.  Please call technical support.");
    }
}

