/*
 * Decompiled with CFR 0.152.
 */
package Adventure.Commands;

import Modules.Consumers.AbstractConsumer;
import Modules.DataStore.IDataStoreXML;
import Modules.Queues.IMessage;
import Modules.Queues.MessageFactory;
import Modules.TextAnalizer.InnerGrammatic;
import Modules.TextAnalizer.InverseToken;
import Modules.TextAnalizer.Phrase;

public class ExCommand
extends AbstractConsumer {
    private String token = "EXAMINE";

    public ExCommand(String name) {
        super(name);
    }

    public ExCommand() {
        super("ExCommand");
    }

    public boolean consumeMessage(IMessage message) {
        if (!message.messageIs(1)) {
            return true;
        }
        Phrase p = (Phrase)message.getAttrib();
        if (p.getVerbToken() != InnerGrammatic.TOKEN(this.token)) {
            return true;
        }
        if (p.getCompNumber() < 1) {
            this.messages.addLast(MessageFactory.Build("COMPNEEDE", (Object)p));
            return false;
        }
        if (InverseToken.InverseToken(p.getCdToken()) == null) {
            this.messages.addLast(MessageFactory.Build("COMPNOTHERE", (Object)p));
            return false;
        }
        IDataStoreXML global = this.registry.getDataStore("GLOBAL");
        String idRoom = global.leerEtiqueta("ROOM");
        IDataStoreXML rooms = this.registry.getDataStore("ROOMS");
        IDataStoreXML room = rooms.buscarEtiqueta("ROOM", idRoom);
        IDataStoreXML objetos = room.leerSeccion("ELEMENTS");
        IDataStoreXML objeto = objetos.buscarEtiqueta("ELEMENT", InverseToken.InverseToken(p.getCdToken()));
        if (objeto == null) {
            this.salida.escribirSalida("No hay nada que decir");
            return false;
        }
        this.salida.escribirSalida(objeto.leerEtiqueta());
        return false;
    }
}

