/*
 * Decompiled with CFR 0.152.
 */
package Modules.TextAnalizer;

import Modules.TextAnalizer.GenericParser;
import Modules.TextAnalizer.GramList;

public class TextAnalizerFactory {
    protected String path;
    protected GramList preposiciones;
    protected GramList verbs;
    protected GramList complementos;

    protected void init(String path) {
        this.path = path;
        this.preposiciones = new GramList();
        this.verbs = new GramList();
        this.complementos = new GramList();
    }

    public TextAnalizerFactory(String path) {
        this.init(path);
    }

    public TextAnalizerFactory(String path, String prep, String verb, String comp) {
        this.init(path);
        this.addPVC(prep, verb, comp);
    }

    public void addPrep(String fileName) {
        this.preposiciones.addGrammar(this.path + fileName);
    }

    public void addPrep(String path, String fileName) {
        this.preposiciones.addGrammar(path + fileName);
    }

    public void addVerb(String fileName) {
        this.verbs.addGrammar(this.path + fileName);
    }

    public void addVerb(String path, String fileName) {
        this.verbs.addGrammar(path + fileName);
    }

    public void addComp(String fileName) {
        this.complementos.addGrammar(this.path + fileName);
    }

    public void addComp(String path, String fileName) {
        this.complementos.addGrammar(path + fileName);
    }

    public void addPVC(String prep, String verb, String comp) {
        if (prep != null) {
            this.addPrep(prep);
        }
        if (verb != null) {
            this.addVerb(verb);
        }
        if (comp != null) {
            this.addComp(comp);
        }
    }

    public GenericParser getTextAnalizer() {
        return new GenericParser(this.preposiciones, this.verbs, this.complementos);
    }
}

