/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.instructions;

import org.zmpp.instructions.AbstractInstruction;
import org.zmpp.instructions.InstructionStaticInfo;
import org.zmpp.instructions.Short1StaticInfo;
import org.zmpp.vm.Machine;
import org.zmpp.vm.ZObject;

public class Short1Instruction
extends AbstractInstruction {
    public Short1Instruction(Machine machine, int n) {
        super(machine, n);
    }

    protected AbstractInstruction.InstructionResult doInstruction() {
        switch (this.getOpcode()) {
            case 0: {
                this.jz();
                break;
            }
            case 1: {
                this.get_sibling();
                break;
            }
            case 2: {
                this.get_child();
                break;
            }
            case 3: {
                this.get_parent();
                break;
            }
            case 4: {
                this.get_prop_len();
                break;
            }
            case 5: {
                this.inc();
                break;
            }
            case 6: {
                this.dec();
                break;
            }
            case 7: {
                this.print_addr();
                break;
            }
            case 9: {
                this.remove_obj();
                break;
            }
            case 10: {
                this.print_obj();
                break;
            }
            case 12: {
                this.jump();
                break;
            }
            case 11: {
                this.ret();
                break;
            }
            case 13: {
                this.print_paddr();
                break;
            }
            case 14: {
                this.load();
                break;
            }
            case 15: {
                if (this.getStoryFileVersion() <= 4) {
                    this.not();
                    break;
                }
                this.call_1n();
                break;
            }
            case 8: {
                this.call_1s();
                break;
            }
            default: {
                this.throwInvalidOpcode();
            }
        }
        return new AbstractInstruction.InstructionResult(1, false);
    }

    public AbstractInstruction.InstructionForm getInstructionForm() {
        return AbstractInstruction.InstructionForm.SHORT;
    }

    public AbstractInstruction.OperandCount getOperandCount() {
        return AbstractInstruction.OperandCount.C1OP;
    }

    protected InstructionStaticInfo getStaticInfo() {
        return Short1StaticInfo.getInstance();
    }

    private void inc() {
        short s = this.getValue(0);
        short s2 = this.getCpu().getVariable(s);
        this.getCpu().setVariable(s, (short)(s2 + 1));
        this.nextInstruction();
    }

    private void dec() {
        short s = this.getValue(0);
        short s2 = this.getCpu().getVariable(s);
        this.getCpu().setVariable(s, (short)(s2 - 1));
        this.nextInstruction();
    }

    private void not() {
        int n = ~this.getUnsignedValue(0);
        this.storeResult((short)(n & 0xFFFF));
        this.nextInstruction();
    }

    private void jump() {
        this.getCpu().incrementProgramCounter(this.getValue(0) + 1);
    }

    private void load() {
        short s = this.getValue(0);
        short s2 = s == 0 ? this.getCpu().getStackTopElement() : this.getCpu().getVariable(s);
        this.storeResult(s2);
        this.nextInstruction();
    }

    private void jz() {
        this.branchOnTest(this.getValue(0) == 0);
    }

    private void get_parent() {
        int n = this.getUnsignedValue(0);
        int n2 = 0;
        if (n > 0) {
            n2 = this.getObjectTree().getObject(n).getParent();
        } else {
            this.getMachine().warn("@get_parent illegal access to object " + n);
        }
        this.storeResult((short)(n2 & 0xFFFF));
        this.nextInstruction();
    }

    private void get_sibling() {
        int n = this.getUnsignedValue(0);
        int n2 = 0;
        if (n > 0) {
            n2 = this.getObjectTree().getObject(n).getSibling();
        } else {
            this.getMachine().warn("@get_sibling illegal access to object " + n);
        }
        this.storeResult((short)(n2 & 0xFFFF));
        this.branchOnTest(n2 > 0);
    }

    private void get_child() {
        int n = this.getUnsignedValue(0);
        int n2 = 0;
        if (n > 0) {
            n2 = this.getObjectTree().getObject(n).getChild();
        } else {
            this.getMachine().warn("@get_child illegal access to object " + n);
        }
        this.storeResult((short)(n2 & 0xFFFF));
        this.branchOnTest(n2 > 0);
    }

    private void print_addr() {
        this.getMachine().getOutput().printZString(this.getUnsignedValue(0));
        this.nextInstruction();
    }

    private void print_paddr() {
        this.getMachine().getOutput().printZString(this.getMachine().getCpu().translatePackedAddress(this.getUnsignedValue(0), false));
        this.nextInstruction();
    }

    private void ret() {
        this.returnFromRoutine(this.getValue(0));
    }

    private void print_obj() {
        int n = this.getUnsignedValue(0);
        if (n > 0) {
            ZObject zObject = this.getObjectTree().getObject(n);
            this.getMachine().getOutput().printZString(zObject.getPropertiesDescriptionAddress());
        } else {
            this.getMachine().warn("@print_obj illegal access to object " + n);
        }
        this.nextInstruction();
    }

    private void remove_obj() {
        int n = this.getUnsignedValue(0);
        if (n > 0) {
            this.getObjectTree().removeObject(n);
        }
        this.nextInstruction();
    }

    private void get_prop_len() {
        int n = this.getUnsignedValue(0);
        short s = (short)this.getObjectTree().getPropertyLength(n);
        this.storeResult(s);
        this.nextInstruction();
    }

    private void call_1s() {
        this.call(0);
    }

    private void call_1n() {
        this.call(0);
    }
}

