/*
 * Decompiled with CFR 0.152.
 */
package org.zmpp.iff;

import org.zmpp.base.DefaultMemoryAccess;
import org.zmpp.base.MemoryAccess;
import org.zmpp.iff.Chunk;

public class DefaultChunk
implements Chunk {
    protected MemoryAccess memaccess;
    private byte[] id;
    private int chunkSize;
    private int address;

    public DefaultChunk(MemoryAccess memoryAccess, int n) {
        this.memaccess = memoryAccess;
        this.address = n;
        this.initBaseInfo();
    }

    public DefaultChunk(byte[] byArray, byte[] byArray2) {
        int n;
        this.id = byArray;
        this.chunkSize = byArray2.length;
        byte[] byArray3 = new byte[this.chunkSize + 8];
        this.memaccess = new DefaultMemoryAccess(byArray3);
        int n2 = 0;
        for (n = 0; n < byArray.length; ++n) {
            this.memaccess.writeByte(n2++, byArray[n]);
        }
        this.memaccess.writeUnsigned32(n2, this.chunkSize);
        n2 += 4;
        for (n = 0; n < byArray2.length; ++n) {
            this.memaccess.writeByte(n2++, byArray2[n]);
        }
    }

    private void initBaseInfo() {
        this.id = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.id[i] = this.memaccess.readByte(i);
        }
        this.chunkSize = (int)this.memaccess.readUnsigned32(4);
    }

    public boolean isValid() {
        return true;
    }

    public byte[] getId() {
        return this.id;
    }

    public int getSize() {
        return this.chunkSize;
    }

    public MemoryAccess getMemoryAccess() {
        return this.memaccess;
    }

    public int getAddress() {
        return this.address;
    }
}

