/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.AGESoundClient;
import eu.irreality.age.MultimediaInputOutputClient;
import eu.irreality.age.Player;
import eu.irreality.age.SoundClient;
import eu.irreality.age.SwingAetheriaGameLoaderInterface;
import eu.irreality.age.SwingEditBoxListener;
import eu.irreality.age.VisualConfiguration;
import eu.irreality.age.swing.FancyAttributeSet;
import eu.irreality.age.swing.FancyJTextField;
import eu.irreality.age.swing.FancyJTextPane;
import eu.irreality.age.swing.IconLoader;
import eu.irreality.age.swing.ImagePanel;
import eu.irreality.age.windowing.AGEClientWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;

public class ColoredSwingClient
implements MultimediaInputOutputClient {
    private FancyJTextField elCampoTexto;
    private FancyJTextPane elAreaTexto;
    private JScrollPane elScrolling;
    private SwingEditBoxListener elEscuchador;
    private Vector gameLog;
    private AGEClientWindow laVentana;
    private Document doc;
    private MutableAttributeSet atributos = new FancyAttributeSet();
    private Color textFieldForeground = Color.black;
    private boolean deactivated = false;
    private String currentInput;
    private Stack back = new Stack();
    private Stack forward = new Stack();
    private VisualConfiguration vc;
    private SoundClient sonido;
    private Hashtable colorCodesTable = new Hashtable();
    private JMenu clientConfigurationMenu = new JMenu("Ver");
    private boolean echoEnabled = true;
    private String echoText = "Tu orden:  ";
    private String keyRequestText = "Pulsa cualquier tecla...";
    private ImagePanel topFrame = null;
    private ImagePanel bottomFrame = null;
    private ImagePanel leftFrame = null;
    private ImagePanel rightFrame = null;
    private boolean processingLog = false;

    public boolean isSoundEnabled() {
        return true;
    }

    public SoundClient getSoundClient() {
        if (this.sonido == null) {
            this.sonido = new AGESoundClient();
        }
        return this.sonido;
    }

    public FancyJTextPane getTextArea() {
        return this.elAreaTexto;
    }

    public boolean isDisconnected() {
        return false;
    }

    public String getColorCode(String colorType) {
        if (colorType == null) {
            return "";
        }
        String code = (String)this.colorCodesTable.get(colorType);
        if (code == null) {
            return "";
        }
        return code;
    }

    public synchronized void exit() {
        this.deactivated = true;
        if (this.getSoundClient() != null) {
            this.getSoundClient().stopAllSound();
            if (this.getSoundClient() instanceof AGESoundClient) {
                ((AGESoundClient)this.getSoundClient()).deactivate();
            }
        }
        this.notifyAll();
    }

    private void reformatAllText() {
        try {
            String text = this.elAreaTexto.getText();
            this.elAreaTexto.getDocument().remove(0, this.elAreaTexto.getDocument().getLength());
            this.write(text);
        }
        catch (BadLocationException ble) {
            System.out.println(ble);
        }
    }

    public void setDefaultConfiguration() {
        this.colorCodesTable.put("description", "%00CC00%");
        this.colorCodesTable.put("important", "%FFFF00%");
        this.colorCodesTable.put("information", "%FFFF00%");
        this.colorCodesTable.put("action", "%9999FF%");
        this.colorCodesTable.put("denial", "%CC0000%");
        this.colorCodesTable.put("error", "%FF0000%");
        this.colorCodesTable.put("story", "%FFFFFF%");
        this.colorCodesTable.put("default", "%FFFFFF%");
        this.colorCodesTable.put("input", "%AAAAAA%");
        this.colorCodesTable.put("reset", "% %");
        this.elAreaTexto.setBackground(Color.black);
        this.laVentana.getMainPanel().setBackground(this.elAreaTexto.getBackground());
        this.elAreaTexto.setForeground(Color.white);
        StyleConstants.setForeground(this.atributos, Color.black);
        StyleConstants.setForeground(this.atributos, Color.white);
        this.elAreaTexto.setFont(SwingAetheriaGameLoaderInterface.font);
        this.elCampoTexto.setFont(SwingAetheriaGameLoaderInterface.font.deriveFont(24.0f));
        this.reformatAllText();
        this.elAreaTexto.repaint();
    }

    public void setPergaminoConfiguration() {
        this.colorCodesTable.put("description", "%006600%");
        this.colorCodesTable.put("important", "%555500%");
        this.colorCodesTable.put("information", "%555500%");
        this.colorCodesTable.put("action", "%0000FF%");
        this.colorCodesTable.put("denial", "%C00000%");
        this.colorCodesTable.put("error", "%800000%");
        this.colorCodesTable.put("story", "%000001%");
        this.colorCodesTable.put("default", "%000001%");
        this.colorCodesTable.put("input", "%555555%");
        this.colorCodesTable.put("reset", " ");
        this.elAreaTexto.setBackground(new Color(255, 255, 211));
        this.laVentana.getMainPanel().setBackground(this.elAreaTexto.getBackground());
        this.elAreaTexto.setForeground(Color.black);
        StyleConstants.setForeground(this.atributos, Color.black);
        String fontName = "Lucida Handwriting Cursiva";
        float fontSize = 16.0f;
        Font laFuente = SwingAetheriaGameLoaderInterface.font;
        laFuente = new Font("Serif", 0, (int)fontSize);
        Font[] fuentes = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int f = 0; f < fuentes.length; ++f) {
            System.out.println("FONT: " + fuentes[f].getFontName());
            if (!fuentes[f].getFontName().equalsIgnoreCase(fontName)) continue;
            laFuente = fuentes[f].deriveFont(fontSize);
            break;
        }
        this.elAreaTexto.setFont(laFuente);
        this.elCampoTexto.setFont(laFuente.deriveFont(24.0f));
        this.reformatAllText();
        this.elAreaTexto.repaint();
    }

    public void setVisualConfiguration(VisualConfiguration c) {
        Enumeration keys = c.getColorKeys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.colorCodesTable.put(key, c.getColorCode(key));
            System.out.println(this.getClass() + " putting " + " " + key + " " + c.getColorCode(key));
        }
        this.elAreaTexto.setBackground(c.getBackgroundColor());
        this.elAreaTexto.setForeground(c.getForegroundColor());
        this.laVentana.getMainPanel().setBackground(c.getBackgroundColor());
        StyleConstants.setForeground(this.atributos, c.getForegroundColor());
        this.elAreaTexto.repaint();
        this.elAreaTexto.setFont(c.getFont());
        this.elCampoTexto.setFont(c.getFont().deriveFont(24.0f));
        this.vc = c;
    }

    public VisualConfiguration getVisualConfiguration() {
        if (this.vc != null) {
            return this.vc;
        }
        return new VisualConfiguration();
    }

    public void addToBackStack(String s) {
        if (this.back.isEmpty() || !s.equalsIgnoreCase((String)this.back.peek())) {
            this.back.push(s);
        }
    }

    public void addToForwardStack(String s) {
        if (this.forward.isEmpty() || !s.equalsIgnoreCase((String)this.back.peek())) {
            this.forward.push(s);
        }
    }

    public void forwardStackIntoBackStack() {
        while (!this.forward.isEmpty()) {
            Object o = this.forward.pop();
            if (o.equals("")) continue;
            this.back.push(o);
        }
    }

    public void goBack() {
        if (!this.back.isEmpty()) {
            this.addToForwardStack(this.elCampoTexto.getText());
            this.elCampoTexto.setText((String)this.back.pop());
        }
    }

    public void goForward() {
        if (!this.forward.isEmpty()) {
            this.addToBackStack(this.elCampoTexto.getText());
            this.elCampoTexto.setText((String)this.forward.pop());
        }
    }

    public void refreshFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ColoredSwingClient.this.elCampoTexto.requestFocus();
            }
        });
    }

    public void escribirTitulo(String s) {
        this.writeTitle(s);
    }

    public void writeTitle(String s) {
        this.laVentana.setTitle(s);
    }

    public void escribirTitulo(String s, int pos) {
        this.writeTitle(s, pos);
    }

    public void writeTitle(String s, int pos) {
        String titAct = this.laVentana.getTitle();
        StringTokenizer st = new StringTokenizer(titAct, "-");
        int npos = 1;
        String result = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            result = npos == pos ? result + s : result + tok.trim();
            ++npos;
            if (!st.hasMoreTokens()) continue;
            result = result + " - ";
        }
        if (npos == pos) {
            result = result + " - " + s;
        }
        this.laVentana.setTitle(result);
    }

    public boolean isColorEnabled() {
        return true;
    }

    public boolean isMemoryEnabled() {
        return true;
    }

    public boolean isLoggingEnabled() {
        return true;
    }

    public boolean isTitleEnabled() {
        return true;
    }

    public ColoredSwingClient(AGEClientWindow window, FancyJTextField nCampo, JScrollPane scrolling, FancyJTextPane nArea, Vector gameLog) {
        this.laVentana = window;
        this.elCampoTexto = nCampo;
        this.elAreaTexto = nArea;
        this.elScrolling = scrolling;
        this.gameLog = gameLog;
        this.elEscuchador = new SwingEditBoxListener(this.elCampoTexto, gameLog, this);
        this.elCampoTexto.addActionListener(this.elEscuchador);
        this.elCampoTexto.addKeyListener(this.elEscuchador);
        this.doc = this.elAreaTexto.getDocument();
        this.setDefaultConfiguration();
        this.initClientMenu(this.laVentana);
    }

    public void uninitClientMenu(final AGEClientWindow window) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doUninitClientMenu(window);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ColoredSwingClient.this.doUninitClientMenu(window);
                        window.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initClientMenu(final AGEClientWindow window) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doInitClientMenu(window);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ColoredSwingClient.this.doInitClientMenu(window);
                        window.repaint();
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void doUninitClientMenu(AGEClientWindow window) {
        JMenuBar mb = window.getTheJMenuBar();
        mb.remove(this.clientConfigurationMenu);
    }

    public void doInitClientMenu(final AGEClientWindow window) {
        JMenu colorConfigurationMenu = new JMenu("Temas de color");
        final JCheckBoxMenuItem fullScreenOption = new JCheckBoxMenuItem("Pantalla completa", window.isFullScreenMode());
        final JCheckBoxMenuItem soundOption = new JCheckBoxMenuItem("Sonido", true);
        JMenuBar mb = window.getTheJMenuBar();
        window.setTheJMenuBar(mb);
        this.clientConfigurationMenu.add(colorConfigurationMenu);
        if (window.supportsFullScreen()) {
            this.clientConfigurationMenu.add(fullScreenOption);
        }
        this.clientConfigurationMenu.add(soundOption);
        JRadioButtonMenuItem itemDefaultJuego = new JRadioButtonMenuItem("Por defecto (juego)", true);
        JRadioButtonMenuItem itemDefault = new JRadioButtonMenuItem("Por defecto (AGE)", false);
        JRadioButtonMenuItem itemPergamino = new JRadioButtonMenuItem("Pergamino", false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(itemDefaultJuego);
        bg.add(itemDefault);
        bg.add(itemPergamino);
        itemDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColoredSwingClient.this.setDefaultConfiguration();
            }
        });
        itemDefaultJuego.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                VisualConfiguration vc;
                if (window.getMundo() != null && (vc = window.getMundo().getVisualConfiguration()) != null) {
                    ColoredSwingClient.this.setVisualConfiguration(vc);
                    ColoredSwingClient.this.reformatAllText();
                }
            }
        });
        itemPergamino.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColoredSwingClient.this.setPergaminoConfiguration();
            }
        });
        fullScreenOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (fullScreenOption.isSelected()) {
                    window.setFullScreenMode(true);
                } else {
                    window.setFullScreenMode(false);
                }
            }
        });
        soundOption.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (soundOption.isSelected()) {
                    AGESoundClient asc = (AGESoundClient)ColoredSwingClient.this.getSoundClient();
                    asc.activate();
                } else {
                    AGESoundClient asc = (AGESoundClient)ColoredSwingClient.this.getSoundClient();
                    asc.deactivate();
                }
            }
        });
        colorConfigurationMenu.add(itemDefaultJuego);
        colorConfigurationMenu.add(itemDefault);
        colorConfigurationMenu.add(itemPergamino);
        mb.add(this.clientConfigurationMenu);
        window.repaint();
    }

    public ColoredSwingClient(AGEClientWindow window, Vector gameLog) {
        this.laVentana = window;
        this.gameLog = gameLog;
        this.laVentana.getMainPanel().setLayout(new BorderLayout());
        this.laVentana.update(this.laVentana.getGraphics());
        this.laVentana.repaint();
        this.laVentana.updateNow();
        this.elAreaTexto = new FancyJTextPane();
        this.laVentana.updateNow();
        this.elScrolling = new JScrollPane(this.elAreaTexto);
        this.elScrolling.setVerticalScrollBarPolicy(22);
        this.elScrolling.setBorder(BorderFactory.createEmptyBorder());
        this.elScrolling.setViewportBorder(BorderFactory.createEmptyBorder());
        this.elAreaTexto.setForeground(Color.white);
        this.elAreaTexto.setBackground(Color.black);
        this.laVentana.getMainPanel().setBackground(Color.black);
        this.elAreaTexto.setFont(SwingAetheriaGameLoaderInterface.font);
        this.elAreaTexto.setMargin(new Insets(20, 20, 10, 20));
        this.elAreaTexto.setVisible(true);
        this.elScrolling.setVisible(true);
        this.laVentana.getMainPanel().add((Component)this.elScrolling, "Center");
        this.elCampoTexto = new FancyJTextField(200);
        this.elCampoTexto.setFont(SwingAetheriaGameLoaderInterface.font.deriveFont(24.0f));
        this.elCampoTexto.setVisible(true);
        this.laVentana.getMainPanel().add((Component)this.elCampoTexto, "South");
        this.elCampoTexto.requestFocus();
        this.elCampoTexto.setCaretColor(Color.red);
        this.laVentana.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent evt) {
                ColoredSwingClient.this.elCampoTexto.requestFocus();
            }

            public void focusLost(FocusEvent evt) {
            }
        });
        this.elAreaTexto.setEditable(false);
        this.elAreaTexto.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                try {
                    Clipboard clipboard = ColoredSwingClient.this.elAreaTexto.getToolkit().getSystemClipboard();
                    String selection = ColoredSwingClient.this.elAreaTexto.getSelectedText();
                    clipboard.setContents(new StringSelection(selection), null);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                ColoredSwingClient.this.elCampoTexto.requestFocus();
            }
        });
        this.laVentana.setVisible(true);
        this.laVentana.repaint();
        this.laVentana.updateNow();
        this.elEscuchador = new SwingEditBoxListener(this.elCampoTexto, gameLog, this);
        this.elCampoTexto.addActionListener(this.elEscuchador);
        this.elCampoTexto.addKeyListener(this.elEscuchador);
        this.elAreaTexto.setText("--");
        this.doc = this.elAreaTexto.getDocument();
        this.initClientMenu(this.laVentana);
        this.laVentana.updateNow();
    }

    public static Color stringToColor(String colorString) {
        try {
            String colorClean = colorString;
            if (colorClean.charAt(0) == '%') {
                colorClean = colorClean.substring(1, colorClean.length() - 1);
            }
            if (colorClean.length() > 0 && colorClean.charAt(0) == '#') {
                colorClean = colorClean.substring(1);
            }
            int ncolor = Integer.parseInt(colorClean, 16);
            return new Color(ncolor);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public static String colorToString(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        return Integer.toString(red, 16) + Integer.toString(green, 16) + Integer.toString(blue, 16);
    }

    public void escribir(String s) {
        this.write(s);
    }

    public void write(String s) {
        boolean iscode;
        if (s == null) {
            this.write("null");
            return;
        }
        StringTokenizer st = new StringTokenizer(s, "%");
        boolean bl = iscode = s.length() > 0 && s.charAt(0) == '%';
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (iscode) {
                if (tok.equalsIgnoreCase("red")) {
                    StyleConstants.setForeground(this.atributos, Color.red);
                } else if (tok.equalsIgnoreCase("green")) {
                    StyleConstants.setForeground(this.atributos, Color.green);
                } else if (tok.equalsIgnoreCase("white")) {
                    StyleConstants.setForeground(this.atributos, Color.white);
                } else if (tok.equalsIgnoreCase("blue")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.equalsIgnoreCase("yellow")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.equalsIgnoreCase("lightgray")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.equalsIgnoreCase("magenta")) {
                    StyleConstants.setForeground(this.atributos, Color.blue);
                } else if (tok.trim().equalsIgnoreCase("")) {
                    System.out.println(this.getColorCode("default"));
                    System.out.println(ColoredSwingClient.stringToColor(this.getColorCode("default")));
                    StyleConstants.setForeground(this.atributos, ColoredSwingClient.stringToColor(this.getColorCode("default")));
                } else {
                    try {
                        String colortok = tok.length() > 0 && tok.charAt(0) == '#' ? tok.substring(1) : tok;
                        int ncolor = Integer.parseInt(colortok, 16);
                        StyleConstants.setForeground(this.atributos, new Color(ncolor));
                    }
                    catch (NumberFormatException nfe) {}
                }
            } else {
                try {
                    this.doc.insertString(this.elAreaTexto.getText().length(), tok, this.atributos);
                }
                catch (Exception ble) {
                    System.out.println(ble);
                }
            }
            iscode = !iscode;
        }
        this.elAreaTexto.setCaretColor(Color.red);
        this.elAreaTexto.setCaretPosition(this.elAreaTexto.getText().length());
        this.elAreaTexto.setVisible(true);
    }

    public void insertIcon(ImageIcon icon) {
        this.elAreaTexto.setSelectionStart(this.elAreaTexto.getText().length());
        this.elAreaTexto.setSelectionEnd(this.elAreaTexto.getText().length());
        System.out.println("Icon Insert.\n");
        this.elAreaTexto.insertIcon(icon);
    }

    public void insertIcon(URL location) {
        this.insertIcon(new ImageIcon(location));
    }

    public void insertIcon(String filename) {
        this.insertIcon(new ImageIcon(filename));
    }

    public void insertCenteredIcon(ImageIcon icon) {
        this.elAreaTexto.setSelectionStart(this.elAreaTexto.getText().length());
        this.elAreaTexto.setSelectionEnd(this.elAreaTexto.getText().length());
        JPanel jp = new JPanel();
        jp.setBackground(this.elAreaTexto.getBackground());
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(1);
        jp.add(new JLabel(icon));
        this.elAreaTexto.insertComponent(jp);
    }

    public void insertCenteredIcon(URL location) {
        if (location == null) {
            return;
        }
        this.insertCenteredIcon(new ImageIcon(location));
    }

    public void insertCenteredIcon(String fileName) {
        if (fileName == null) {
            return;
        }
        this.insertCenteredIcon(new ImageIcon(fileName));
    }

    public boolean isGraphicsEnabled() {
        return true;
    }

    public void loguear(String s) {
        this.gameLog.addElement(s);
    }

    public void forzarEntrada(String s, boolean output_enabled) {
        this.forceInput(s, output_enabled);
    }

    public void forceInput(String s, boolean output_enabled) {
        if (output_enabled) {
            this.gameLog.addElement(s);
        }
        this.elEscuchador.countCommand();
        if (output_enabled) {
            this.write("\n");
            this.write(this.getColorCode("input") + this.echoText + s.trim() + this.getColorCode("reset") + "\n");
        }
    }

    public synchronized void waitKeyPress() {
        if (this.deactivated) {
            return;
        }
        this.elEscuchador.setPressAnyKeyState(true);
        try {
            this.wait();
        }
        catch (InterruptedException intex) {
            System.out.println(intex);
        }
    }

    public synchronized String getInput(Player pl) {
        if (this.deactivated) {
            return null;
        }
        this.showAfterLogLoad();
        this.setTextFieldForeground(this.textFieldForeground);
        try {
            this.wait();
        }
        catch (InterruptedException intex) {
            System.out.println(intex);
        }
        String temp = this.currentInput;
        this.currentInput = null;
        this.setTextFieldForeground(Color.red);
        return temp;
    }

    private void setTextFieldForeground(final Color color) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.elCampoTexto.setForeground(color);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ColoredSwingClient.this.elCampoTexto.setForeground(color);
                    }
                });
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
        }
    }

    public synchronized String getRealTimeInput(Player pl) {
        if (this.deactivated) {
            return null;
        }
        this.showAfterLogLoad();
        String temp = this.currentInput;
        this.setTextFieldForeground(Color.black);
        this.currentInput = null;
        if (temp == null) {
            this.loguear("");
        } else {
            this.setTextFieldForeground(Color.red);
        }
        return temp;
    }

    public synchronized void setInputString(String s) {
        this.currentInput = s;
        this.notify();
    }

    public void borrarPantalla() {
        this.clearScreen();
    }

    public void clearScreen() {
        this.elAreaTexto.setText("");
    }

    public boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public void setEchoEnabled(boolean echoEnabled) {
        this.echoEnabled = echoEnabled;
    }

    public String getEchoText() {
        return this.echoText;
    }

    public void setEchoText(String echoText) {
        this.echoText = echoText;
    }

    public String getKeyRequestText() {
        return this.keyRequestText;
    }

    public void setKeyRequestText(String newText) {
        this.keyRequestText = newText;
    }

    public void removeFrames() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ColoredSwingClient.this.doRemoveFrames();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void doRemoveFrames() {
        this.topFrame = null;
        this.bottomFrame = null;
        this.leftFrame = null;
        this.rightFrame = null;
        Container current = this.elAreaTexto.getParent();
        while (!(current instanceof JPanel)) {
            current = current.getParent();
        }
        this.laVentana.setMainPanel((JPanel)current);
        this.laVentana.getMainPanel().revalidate();
        this.refreshFocus();
    }

    public void addFrame(final int position, final int size) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ColoredSwingClient.this.doAddFrame(position, size);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void doAddFrame(int position, int size) {
        if (position == 0) {
            JPanel newMainPanel = new JPanel();
            this.topFrame = new ImagePanel();
            this.topFrame.setBackground(this.elAreaTexto.getBackground());
            this.topFrame.setPreferredSize(new Dimension(this.laVentana.getMainPanel().getWidth(), size));
            this.topFrame.setMaximumSize(new Dimension(10000, size));
            newMainPanel.setLayout(new BorderLayout());
            newMainPanel.add((Component)this.topFrame, "North");
            newMainPanel.add((Component)this.laVentana.getMainPanel(), "Center");
            this.laVentana.setMainPanel(newMainPanel);
        } else if (position == 1) {
            JPanel newMainPanel = new JPanel();
            this.bottomFrame = new ImagePanel();
            this.bottomFrame.setBackground(this.elAreaTexto.getBackground());
            this.bottomFrame.setPreferredSize(new Dimension(this.laVentana.getMainPanel().getWidth(), size));
            this.bottomFrame.setMaximumSize(new Dimension(10000, size));
            newMainPanel.setLayout(new BorderLayout());
            newMainPanel.add((Component)this.laVentana.getMainPanel(), "Center");
            newMainPanel.add((Component)this.bottomFrame, "South");
            this.laVentana.setMainPanel(newMainPanel);
        } else if (position == 2) {
            JPanel newMainPanel = new JPanel();
            this.leftFrame = new ImagePanel();
            this.leftFrame.setBackground(this.elAreaTexto.getBackground());
            this.leftFrame.setPreferredSize(new Dimension(size, this.laVentana.getMainPanel().getHeight()));
            this.leftFrame.setMaximumSize(new Dimension(size, 100000));
            newMainPanel.setLayout(new BorderLayout());
            newMainPanel.add((Component)this.leftFrame, "West");
            newMainPanel.add((Component)this.laVentana.getMainPanel(), "Center");
            this.laVentana.setMainPanel(newMainPanel);
        } else if (position == 3) {
            JPanel newMainPanel = new JPanel();
            this.rightFrame = new ImagePanel();
            this.rightFrame.setBackground(this.elAreaTexto.getBackground());
            this.rightFrame.setPreferredSize(new Dimension(size, this.laVentana.getMainPanel().getHeight()));
            this.rightFrame.setMaximumSize(new Dimension(size, 100000));
            newMainPanel.setLayout(new BorderLayout());
            newMainPanel.add((Component)this.laVentana.getMainPanel(), "Center");
            newMainPanel.add((Component)this.rightFrame, "East");
            this.laVentana.setMainPanel(newMainPanel);
        }
        this.laVentana.getMainPanel().revalidate();
        this.refreshFocus();
    }

    private ImagePanel getFrame(int position) {
        switch (position) {
            case 0: {
                return this.topFrame;
            }
            case 1: {
                return this.bottomFrame;
            }
            case 2: {
                return this.leftFrame;
            }
            case 3: {
                return this.rightFrame;
            }
        }
        return null;
    }

    public void showImageInFrame(String fileName, int position) {
        this.showImageInFrame(fileName, position, 0);
    }

    public void showImageInFrame(URL location, int position) {
        this.showImageInFrame(location, position, 0);
    }

    public void showImageInFrame(Icon icon, int position, int scalingMode) {
        ImagePanel theFrame = this.getFrame(position);
        if (theFrame == null) {
            this.addFrame(position, 200);
        }
        if (icon == null) {
            System.err.println("Called showImageInFrame on a null image. Tried to open nonexistent image file?");
            return;
        }
        theFrame = this.getFrame(position);
        theFrame.setImage(icon);
        theFrame.setScalingMode(scalingMode);
        theFrame.repaint();
    }

    public void showImageInFrame(String filename, int position, int scalingMode) {
        this.showImageInFrame(new ImageIcon(filename), position, scalingMode);
    }

    public void showImageInFrame(URL location, int position, int scalingMode) {
        this.showImageInFrame(IconLoader.loadIcon(location), position, scalingMode);
    }

    public void showImageInBackground(String fileName) {
        if (fileName == null) {
            this.elAreaTexto.setBackgroundImage(null);
        } else {
            this.elAreaTexto.setBackgroundImage(new ImageIcon(fileName).getImage());
        }
    }

    public void showImageInBackground(URL location) {
        if (location == null) {
            this.elAreaTexto.setBackgroundImage(null);
        } else {
            this.elAreaTexto.setBackgroundImage(new ImageIcon(location).getImage());
        }
    }

    public void useImage(URL url, int mode, int location, int scaling) {
        if (mode == 0) {
            if (location == 2) {
                this.insertIcon(url);
            } else {
                this.insertCenteredIcon(url);
            }
        } else if (mode == 2) {
            this.showImageInBackground(url);
        } else if (mode == 1) {
            this.showImageInFrame(url, location, scaling);
        }
    }

    public void useImage(String fileName, int mode, int location, int scaling) {
        this.useImage(ColoredSwingClient.fileToURL(fileName), mode, location, scaling);
    }

    public void useImage(String fileName, int mode, int location) {
        this.useImage(fileName, mode, location, 0);
    }

    public void useImage(URL url, int mode, int location) {
        this.useImage(url, mode, location, 0);
    }

    public void useImage(String fileName, int mode) {
        this.useImage(ColoredSwingClient.fileToURL(fileName), mode);
    }

    public void useImage(URL url, int mode) {
        if (mode == 1) {
            this.useImage(url, mode, 0);
        } else {
            this.useImage(url, mode, 4);
        }
    }

    public static URL fileToURL(String filename) {
        try {
            return new File(filename).toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setPrompts(final String left, final String right) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    ColoredSwingClient.this.elCampoTexto.setPrompts(left, right);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static Color parseColor(String colorString) {
        String colorHex = colorString.length() > 0 && colorString.charAt(0) == '#' ? colorString.substring(1) : colorString;
        int ncolor = Integer.parseInt(colorHex, 16);
        return new Color(ncolor);
    }

    public void setInputFieldForeground(Color color) {
        this.textFieldForeground = color;
        this.setTextFieldForeground(color);
    }

    public void setInputFieldBackground(final Color color) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.elCampoTexto.setBackground(color);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ColoredSwingClient.this.elCampoTexto.setBackground(color);
                    }
                });
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
        }
    }

    public void setOutputAreaBackground(final Color color) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.elAreaTexto.setBackground(color);
        } else {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ColoredSwingClient.this.elAreaTexto.setBackground(color);
                    }
                });
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
        }
    }

    public void setOutputAreaFont(final Font f) {
        ColoredSwingClient.execInDispatchThread(new Runnable(){

            public void run() {
                ColoredSwingClient.this.elAreaTexto.setFont(f);
            }
        });
    }

    public void setCurrentOutputFont(final Font f) {
        ColoredSwingClient.execInDispatchThread(new Runnable(){

            public void run() {
                ((FancyAttributeSet)ColoredSwingClient.this.atributos).setFont(f);
                StyleConstants.setFontFamily(ColoredSwingClient.this.atributos, f.getFamily());
                StyleConstants.setFontSize(ColoredSwingClient.this.atributos, f.getSize());
            }
        });
    }

    public void setOutputAreaFont(InputStream is, int fontSize) {
        try {
            Font fuente = Font.createFont(0, is);
            this.setOutputAreaFont(fuente.deriveFont((float)fontSize));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setCurrentOutputFont(InputStream is, int fontSize) {
        try {
            Font fuente = Font.createFont(0, is);
            this.setCurrentOutputFont(fuente.deriveFont((float)fontSize));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInputFieldFont(final Font f) {
        ColoredSwingClient.execInDispatchThread(new Runnable(){

            public void run() {
                ColoredSwingClient.this.elCampoTexto.setFont(f);
            }
        });
    }

    public void setInputFieldFont(InputStream is, int fontSize) {
        try {
            Font fuente = Font.createFont(0, is);
            this.setInputFieldFont(fuente.deriveFont((float)fontSize));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInputFieldFont(URL u, int fontSize) {
        try {
            this.setInputFieldFont(u.openStream(), fontSize);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setOutputAreaFont(URL u, int fontSize) {
        try {
            this.setOutputAreaFont(u.openStream(), fontSize);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setCurrentOutputFont(URL u, int fontSize) {
        try {
            this.setCurrentOutputFont(u.openStream(), fontSize);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void execInDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeLater(r);
            }
            catch (Exception ie) {
                ie.printStackTrace();
            }
        }
    }

    public void setMargins(final int top, final int left, final int bottom, final int right) {
        ColoredSwingClient.execInDispatchThread(new Runnable(){

            public void run() {
                ColoredSwingClient.this.elAreaTexto.setMargin(new Insets(top, left, bottom, right));
            }
        });
    }

    public void setInputFieldBackground(String s) {
        this.setInputFieldBackground(ColoredSwingClient.parseColor(s));
    }

    public void setInputFieldForeground(String s) {
        this.setInputFieldForeground(ColoredSwingClient.parseColor(s));
    }

    public void setOutputAreaBackground(String s) {
        this.setOutputAreaBackground(ColoredSwingClient.parseColor(s));
    }

    public void hideForLogLoad() {
        this.processingLog = true;
        if (this.laVentana instanceof JFrame) {
            JPanel glass = new JPanel();
            glass.setBackground(Color.WHITE);
            glass.setOpaque(true);
            ((JFrame)((Object)this.laVentana)).setGlassPane(glass);
            glass.removeAll();
            glass.setLayout(new GridLayout(1, 1));
            glass.setBackground(Color.WHITE);
            JLabel loadingLabel = new JLabel("Cargando log, un momento...", 0);
            loadingLabel.setBorder(BorderFactory.createLineBorder(Color.black, 4));
            loadingLabel.setAlignmentX(0.5f);
            loadingLabel.setAlignmentY(0.5f);
            loadingLabel.setHorizontalTextPosition(0);
            loadingLabel.setVerticalTextPosition(0);
            loadingLabel.setFont(loadingLabel.getFont().deriveFont(25.0f));
            glass.add(loadingLabel);
            glass.setVisible(true);
        }
    }

    public void showAfterLogLoad() {
        if (this.processingLog) {
            this.processingLog = false;
            if (this.laVentana instanceof JFrame) {
                JPanel glass = (JPanel)((JFrame)((Object)this.laVentana)).getGlassPane();
                glass.setVisible(false);
            }
        }
    }
}

