/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import eu.irreality.age.IrcCommand;
import eu.irreality.age.IrcDccChatSocket;
import eu.irreality.age.IrcDccListener;
import eu.irreality.age.IrcListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class IrcSocket
extends Thread {
    BufferedReader fromServer;
    PrintStream toServer;
    IrcListener ircListener;
    static final char X_DELIM = '\u0001';
    static final short DCC_ANY = 0;

    public IrcSocket(String server, int port, IrcListener ircListener) throws Exception {
        Socket socket = new Socket(InetAddress.getByName(server), port);
        this.toServer = new PrintStream(socket.getOutputStream());
        this.fromServer = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.ircListener = ircListener;
        this.start();
    }

    public void joinChannel(String channel) {
        this.toServer.println("JOIN " + channel);
    }

    public void partChannel(String channel) {
        this.toServer.println("PART " + channel);
    }

    public void sendChannel(String channel, String line) {
        this.toServer.println("PRIVMSG " + channel + " :" + line);
    }

    public void setChannelTopic(String channel, String topic) {
        this.toServer.println("TOPIC " + channel + " :" + topic);
    }

    public void sendPrivate(String nick, String line) {
        this.toServer.println("PRIVMSG " + nick + " :" + line);
    }

    public void setNick(String nick) {
        this.toServer.println("NICK " + nick);
    }

    public void sendPing(String nick) {
        this.toServer.println("PING " + nick);
    }

    public void sendPong(String nick) {
        this.toServer.println("PONG :" + nick);
    }

    public void sendCtcpPing(String nick, String args) {
        this.toServer.println("PRIVMSG " + nick + " :" + '\u0001' + "PING " + args + '\u0001');
    }

    public void login(String nick, String realName) {
        this.setNick(nick);
        this.toServer.println("USER " + nick + " <host> <server> :" + realName);
    }

    public void setMode(String channel, String target, String mode) {
        this.toServer.println("MODE " + channel + " " + mode + " " + target);
    }

    public void setAway(String reason) {
        this.toServer.println("AWAY " + reason);
    }

    public void quit(String reason) {
        this.toServer.println("QUIT :" + reason);
    }

    public IrcDccChatSocket sendDccChatRequest(String nick, short port, IrcDccListener idl) throws IOException {
        long addressAsLong = 0L;
        ServerSocket dccSocket = new ServerSocket(port);
        InetAddress ia = InetAddress.getLocalHost();
        byte[] b = ia.getAddress();
        for (int i = 0; i < b.length; ++i) {
            addressAsLong <<= 8;
            addressAsLong += b[i] >= 0 ? (long)b[i] : (long)(256 + b[i]);
            System.out.println(" " + b[i]);
        }
        this.toServer.println("PRIVMSG " + nick + " :" + '\u0001' + "DCC CHAT CHAT " + addressAsLong + " " + dccSocket.getLocalPort() + '\u0001');
        return new IrcDccChatSocket(dccSocket, idl, nick);
    }

    public IrcDccChatSocket acceptDccChatRequest(String nick, InetAddress addr, short port, IrcDccListener idl) throws IOException {
        return new IrcDccChatSocket(addr, port, idl, nick);
    }

    /*
     * Loose catch block
     */
    public void run() {
        block24: while (true) {
            while (true) {
                IrcCommand c = new IrcCommand(this.fromServer.readLine());
                switch (c.type) {
                    case 12: {
                        this.ircListener.noticeMsg(c.from, c.content);
                        continue block24;
                    }
                    case 13: {
                        this.ircListener.changeMode(c.from, c.to, c.content);
                        continue block24;
                    }
                    case 4: {
                        this.ircListener.quitMsg(c.from, c.content);
                        continue block24;
                    }
                    case 7: {
                        this.ircListener.channelTopic(c.channel, c.content);
                        continue block24;
                    }
                    case 6: {
                        this.ircListener.channelJoin(c.channel, c.from);
                        continue block24;
                    }
                    case 5: {
                        this.ircListener.channelPart(c.channel, c.from);
                        continue block24;
                    }
                    case 3: {
                        this.ircListener.nickChange(c.from, c.content);
                        continue block24;
                    }
                    case 1: {
                        this.ircListener.ping(c.content);
                        this.sendPong(c.content);
                        continue block24;
                    }
                    case 14: {
                        this.ircListener.kick(c.channel, c.from, c.to, c.content);
                        continue block24;
                    }
                    case 9: {
                        this.ircListener.nickList(c.channel, c.content);
                        continue block24;
                    }
                    case 128: {
                        this.ircListener.unknownMsg(c.command);
                        continue block24;
                    }
                    case 10: {
                        this.ircListener.serverMsg(c.content);
                        continue block24;
                    }
                    case 17: {
                        this.ircListener.notOnChannel(c.channel);
                        continue block24;
                    }
                    case 16: {
                        this.ircListener.notChannelOp(c.channel);
                        continue block24;
                    }
                    case 8: {
                        this.ircListener.topicChange(c.channel, c.from, c.content);
                        continue block24;
                    }
                    case 11: {
                        this.ircListener.topicSetBy(c.channel, c.from, c.content);
                        continue block24;
                    }
                    case 2: {
                        StringTokenizer st = new StringTokenizer(c.content, "\u0001", true);
                        boolean terminamos = false;
                        boolean extended = false;
                        while (true) {
                            if (!st.hasMoreTokens()) continue block24;
                            String tok = st.nextToken();
                            if (tok.equals("\u0001")) {
                                extended = !extended;
                                continue;
                            }
                            if (!extended) {
                                if (c.to.charAt(0) == '#') {
                                    this.ircListener.channelMsg(c.from, c.to, tok);
                                    continue;
                                }
                                this.ircListener.privateMsg(c.from, tok);
                                continue;
                            }
                            String even_content = tok;
                            StringTokenizer extTok = new StringTokenizer(even_content);
                            if (!extTok.hasMoreTokens()) continue;
                            String command = extTok.nextToken();
                            String arguments = this.concatTokenizedString(extTok);
                            if (command.equalsIgnoreCase("ACTION")) {
                                if (c.to.charAt(0) == '#') {
                                    this.ircListener.channelAction(c.from, c.to, arguments);
                                    continue;
                                }
                                this.ircListener.privateAction(c.from, arguments);
                                continue;
                            }
                            if (command.equalsIgnoreCase("DCC")) {
                                StringTokenizer argTok = new StringTokenizer(arguments);
                                if (!argTok.hasMoreTokens()) continue;
                                try {
                                    String type = argTok.nextToken();
                                    if (type.equalsIgnoreCase("CHAT")) {
                                        String arg = argTok.nextToken();
                                        String addr = argTok.nextToken();
                                        String port = argTok.nextToken();
                                        System.out.println("Argument: " + arg);
                                        System.out.println("Address: " + addr);
                                        System.out.println("Port: " + port);
                                        long iaddr = Long.valueOf(addr);
                                        System.out.println("Iaddr is " + iaddr);
                                        String s = "";
                                        for (int i = 0; i < 4; ++i) {
                                            System.out.println("Byte: " + new Long(iaddr % 256L));
                                            System.out.println("Casted byte: " + new Long(iaddr % 256L).byteValue());
                                            s = "." + s;
                                            s = String.valueOf(iaddr % 256L >= 0L ? iaddr % 256L : 256L + iaddr % 256L) + s;
                                            iaddr >>= 8;
                                        }
                                        System.out.println("Stringed address: " + s.substring(0, s.length() - 1));
                                        InetAddress ia = InetAddress.getByName(s.substring(0, s.length() - 1));
                                        short dccport = Short.valueOf(port);
                                        this.ircListener.dccChatRequest(c.from, ia, dccport);
                                        System.out.println("Converted address: " + ia);
                                        continue;
                                    }
                                    System.out.println("Type is unknown");
                                    this.ircListener.unknownMsg(even_content);
                                }
                                catch (Exception e) {
                                    System.out.println("Wrong format");
                                    this.ircListener.unknownMsg(even_content);
                                }
                                continue;
                            }
                            if (!command.equalsIgnoreCase("PING")) continue;
                            this.ircListener.ctcpPing(c.from, arguments);
                            this.sendCtcpPing(c.from, arguments);
                        }
                    }
                    case 15: {
                        if (c.to.charAt(0) == '#') {
                            this.ircListener.channelAwayMsg(c.to, c.from, c.content);
                            continue block24;
                        }
                        this.ircListener.privateAwayMsg(c.from, c.content);
                        continue block24;
                    }
                }
                System.out.println("*** Not catched event type " + c.type + ":" + c.command);
            }
            break;
        }
        catch (Exception exception) {
            return;
        }
    }

    String concatTokenizedString(StringTokenizer st) {
        String s = st.nextToken();
        while (st.hasMoreTokens()) {
            s = s + " " + st.nextToken();
        }
        return s;
    }
}

