/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age;

import bsh.TargetError;
import eu.irreality.age.Effect;
import eu.irreality.age.EffectList;
import eu.irreality.age.Entity;
import eu.irreality.age.Mobile;
import eu.irreality.age.ObjectCode;
import eu.irreality.age.PropertyEntry;
import eu.irreality.age.ReturnValue;
import eu.irreality.age.SupportingCode;
import eu.irreality.age.World;
import eu.irreality.age.XMLtoWorldException;
import eu.irreality.age.debug.Debug;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Spell
extends Entity
implements SupportingCode {
    private String spellType;
    private int idnumber;
    private int inheritsFrom;
    protected String title;
    private int isInstanceOf;
    protected ObjectCode itsCode;
    private Random aleat;
    long minimalUsage;
    String[] involvedSkills;
    double[] involvedSkillRelevance;
    double castProbabilitySteepness;
    double castStartingTime;
    double castTimeSteepness;
    double durationStartingTime;
    double durationTimeSteepness;
    double manaCostSteepness;
    double startingManaCost;
    double intensitySteepness;
    double startingIntensity;
    EffectList effects;
    List intensities;
    private static int USAGE_CORRECTOR = 100;

    public void cast(Entity caster, Entity target) {
        boolean ejecutado = false;
        try {
            ejecutado = this.execCode("beforeCast", new Object[]{caster, target});
        }
        catch (TargetError bshte) {
            // empty catch block
        }
        if (ejecutado) {
            return;
        }
        if (this.effects != null) {
            for (int i = 0; i < this.effects.size(); ++i) {
                Effect ef = this.effects.elementAt(i);
                ef.enable(caster, target, (Integer)this.intensities.get(i), (int)this.getTypicalDuration((Mobile)caster));
            }
        }
        try {
            ejecutado = this.execCode("afterCast", new Object[]{caster, target});
        }
        catch (TargetError bshte) {
            // empty catch block
        }
    }

    public void fail(Entity caster, Entity target) {
        boolean ejecutado = false;
        try {
            ejecutado = this.execCode("beforeFail", new Object[]{caster, target});
        }
        catch (TargetError bshte) {
            // empty catch block
        }
        if (ejecutado) {
            return;
        }
        if (this.effects != null) {
            for (int i = 0; i < this.effects.size(); ++i) {
                Effect ef = this.effects.elementAt(i);
                ef.fail(caster, target, (Integer)this.intensities.get(i));
            }
        }
        try {
            ejecutado = this.execCode("afterFail", new Object[]{caster, target});
        }
        catch (TargetError bshte) {
            // empty catch block
        }
    }

    private double getTypicalTime(long usage, double starting, long minusage, double steepness) {
        if (usage < minusage) {
            return 0.0;
        }
        return starting / Math.pow(((double)usage - (double)minusage) / (double)USAGE_CORRECTOR + 1.0, Math.exp(steepness));
    }

    public long getUsage(Mobile m) {
        double theUsage = 0.0;
        for (int i = 0; i < this.involvedSkills.length; ++i) {
            Debug.println("Skill: " + this.involvedSkills[i]);
            Debug.println("Relevance: " + this.involvedSkillRelevance[i]);
            Debug.println("Mobile: " + m);
            Debug.println("Traits: " + m.caracteristicas);
            Debug.println("Skill for mobile: " + m.getSkill(this.involvedSkills[i]));
            theUsage += this.involvedSkillRelevance[i] * (double)m.getSkill(this.involvedSkills[i]);
        }
        Debug.println("Usage: " + theUsage);
        return (long)theUsage;
    }

    public double getTypicalCastTime(Mobile m) {
        return this.getTypicalTime(this.getUsage(m), this.castStartingTime, this.minimalUsage, this.castTimeSteepness);
    }

    public double getTypicalCastProbability(Mobile m) {
        return 1.0 - this.getTypicalTime(this.getUsage(m), 1.0, this.minimalUsage, this.castProbabilitySteepness);
    }

    public double getTypicalManaCost(Mobile m) {
        return this.getTypicalTime(this.getUsage(m), this.startingManaCost, this.minimalUsage, this.manaCostSteepness);
    }

    public double getTypicalDuration(Mobile m) {
        Debug.println("STARTING: " + this.durationStartingTime);
        if (this.durationStartingTime == 0.0) {
            Debug.println("RET 0");
            return 0.0;
        }
        Debug.println("RET 1.0/" + this.getTypicalTime(this.getUsage(m), 1.0 / this.durationStartingTime, this.minimalUsage, this.durationTimeSteepness));
        return 1.0 / this.getTypicalTime(this.getUsage(m), 1.0 / this.durationStartingTime, this.minimalUsage, this.durationTimeSteepness);
    }

    public double getTypicalIntensity(Mobile m) {
        if (this.startingIntensity == 0.0) {
            return 0.0;
        }
        return 1.0 / this.getTypicalTime(this.getUsage(m), 1.0 / this.startingIntensity, this.minimalUsage, this.intensitySteepness);
    }

    public int getID() {
        return this.idnumber;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean execCode(String routine, Object[] args) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args);
        }
        return false;
    }

    public boolean execCode(String routine, Object[] args, ReturnValue retval) throws TargetError {
        if (this.itsCode != null) {
            return this.itsCode.run(routine, this, args, retval);
        }
        return false;
    }

    public void changeState(World mundo) {
    }

    public boolean update(PropertyEntry pe, World mundo) {
        return true;
    }

    public void setID(int newid) {
        this.idnumber = newid < 50000000 ? newid + 50000000 : newid;
    }

    public void loadNumberGenerator(World mundo) {
        this.aleat = mundo.getRandom();
    }

    public Random getRandom() {
        return this.aleat;
    }

    public Node getXMLRepresentation(Document doc) {
        Element suElemento = doc.createElement("Spell");
        suElemento.setAttribute("id", String.valueOf(this.idnumber));
        suElemento.setAttribute("name", String.valueOf(this.title));
        suElemento.setAttribute("extends", String.valueOf(this.inheritsFrom));
        suElemento.setAttribute("clones", String.valueOf(this.isInstanceOf));
        suElemento.setAttribute("type", String.valueOf(this.spellType));
        suElemento.setAttribute("minUsage", String.valueOf(this.minimalUsage));
        suElemento.appendChild(this.getPropListXMLRepresentation(doc));
        suElemento.appendChild(this.getRelationshipListXMLRepresentation(doc));
        Element attackElement = suElemento;
        Element castProbabilityElement = doc.createElement("CastProbability");
        castProbabilityElement.setAttribute("steepness", String.valueOf(this.castProbabilitySteepness));
        attackElement.appendChild(castProbabilityElement);
        Element castTimeElement = doc.createElement("CastTime");
        castTimeElement.setAttribute("steepness", String.valueOf(this.castTimeSteepness));
        castTimeElement.setAttribute("starting", String.valueOf(this.castStartingTime));
        attackElement.appendChild(castTimeElement);
        Element durationTimeElement = doc.createElement("Duration");
        durationTimeElement.setAttribute("steepness", String.valueOf(this.durationTimeSteepness));
        durationTimeElement.setAttribute("starting", String.valueOf(this.durationStartingTime));
        attackElement.appendChild(durationTimeElement);
        Element attackSkillsElement = doc.createElement("InvolvedSkills");
        if (this.involvedSkills != null) {
            for (int i = 0; i < this.involvedSkills.length; ++i) {
                Element thisSkillElement = doc.createElement("Skill");
                thisSkillElement.setAttribute("name", this.involvedSkills[i]);
                thisSkillElement.setAttribute("relevance", String.valueOf(this.involvedSkillRelevance[i]));
                attackSkillsElement.appendChild(thisSkillElement);
            }
        }
        attackElement.appendChild(attackSkillsElement);
        Element manaCostElement = doc.createElement("ManaCost");
        manaCostElement.setAttribute("steepness", String.valueOf(this.manaCostSteepness));
        manaCostElement.setAttribute("starting", String.valueOf(this.startingManaCost));
        attackElement.appendChild(manaCostElement);
        Element intensityElement = doc.createElement("Intensity");
        intensityElement.setAttribute("steepness", String.valueOf(this.intensitySteepness));
        intensityElement.setAttribute("starting", String.valueOf(this.startingIntensity));
        attackElement.appendChild(intensityElement);
        if (this.effects != null) {
            suElemento.appendChild(this.effects.getXMLRepresentation(doc, this.intensities));
        }
        if (this.itsCode != null) {
            suElemento.appendChild(this.itsCode.getXMLRepresentation(doc));
        }
        return suElemento;
    }

    public Spell() {
    }

    public static Spell getInstance(World mundo, Node n) throws XMLtoWorldException {
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Spell node not Element");
        }
        Element e = (Element)n;
        Spell ourNewSpell = !e.hasAttribute("type") ? new Spell(mundo, n) : new Spell(mundo, n);
        return ourNewSpell;
    }

    public Spell(World mundo, Node n) throws XMLtoWorldException {
        this.constructSpell(mundo, n, true, "none");
    }

    public void constructSpell(World mundo, Node n, boolean allowInheritance, String spelltype) throws XMLtoWorldException {
        NodeList codeNodes;
        Element atProb;
        NodeList nl;
        if (!(n instanceof Element)) {
            throw new XMLtoWorldException("Spell node not Element");
        }
        Element e = (Element)n;
        this.spellType = spelltype;
        if (e.hasAttribute("extends") && !e.getAttribute("extends").equals("0") && allowInheritance) {
            this.constructSpell(mundo, mundo.getSpellNode(e.getAttribute("extends")), true, spelltype);
            this.constructSpell(mundo, n, false, spelltype);
            return;
        }
        if (e.hasAttribute("clones") && !e.getAttribute("clones").equals("0") && allowInheritance) {
            this.constructSpell(mundo, mundo.getSpellNode(e.getAttribute("clones")), true, spelltype);
            this.constructSpell(mundo, n, false, spelltype);
            return;
        }
        if (!e.hasAttribute("name")) {
            throw new XMLtoWorldException("Spell node lacks attribute name");
        }
        try {
            if (e.hasAttribute("id")) {
                this.idnumber = Integer.valueOf(e.getAttribute("id"));
            }
        }
        catch (NumberFormatException nfe) {
            throw new XMLtoWorldException("Bad number format at attribute id in spell node");
        }
        this.title = e.getAttribute("name");
        this.readPropListFromXML(mundo, n);
        if (e.hasAttribute("minUsage")) {
            try {
                this.minimalUsage = Long.valueOf(e.getAttribute("minUsage"));
            }
            catch (NumberFormatException nfe) {
                throw new XMLtoWorldException("Number format error at minimalUsage");
            }
        } else {
            this.minimalUsage = 0L;
        }
        NodeList nl1 = e.getElementsByTagName("InvolvedSkills");
        if (nl1.getLength() > 0) {
            Element invsk = (Element)nl1.item(0);
            NodeList skillnodes = invsk.getElementsByTagName("Skill");
            this.involvedSkills = new String[skillnodes.getLength()];
            this.involvedSkillRelevance = new double[skillnodes.getLength()];
            for (int i = 0; i < skillnodes.getLength(); ++i) {
                Element skillNode = (Element)skillnodes.item(i);
                if (!skillNode.hasAttribute("name")) {
                    throw new XMLtoWorldException("Skill node lacking attribute name");
                }
                if (!skillNode.hasAttribute("relevance")) {
                    this.involvedSkillRelevance[i] = 1.0;
                }
                try {
                    if (skillNode.hasAttribute("relevance")) {
                        this.involvedSkillRelevance[i] = Double.valueOf(skillNode.getAttribute("relevance"));
                    }
                    this.involvedSkills[i] = skillNode.getAttribute("name");
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Wrong number format for relevance attribute at weapon's attack skill node");
                }
            }
        }
        if ((nl = e.getElementsByTagName("CastProbability")).getLength() > 0) {
            atProb = (Element)nl.item(0);
            if (atProb.hasAttribute("steepness")) {
                try {
                    this.castProbabilitySteepness = Double.valueOf(atProb.getAttribute("steepness"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at attackProbabilitySteepness");
                }
            } else {
                this.castProbabilitySteepness = 0.0;
            }
        }
        if ((nl = e.getElementsByTagName("CastTime")).getLength() > 0) {
            atProb = (Element)nl.item(0);
            if (atProb.hasAttribute("steepness")) {
                try {
                    this.castTimeSteepness = Double.valueOf(atProb.getAttribute("steepness"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at castTimeSteepness");
                }
            } else {
                this.castTimeSteepness = 0.0;
            }
            if (atProb.hasAttribute("starting")) {
                try {
                    this.castStartingTime = Double.valueOf(atProb.getAttribute("starting"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at castStartingTime");
                }
            } else {
                this.castStartingTime = 30.0;
            }
        }
        if ((nl = e.getElementsByTagName("Duration")).getLength() > 0) {
            atProb = (Element)nl.item(0);
            if (atProb.hasAttribute("steepness")) {
                try {
                    this.durationTimeSteepness = Double.valueOf(atProb.getAttribute("steepness"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at durationTimeSteepness");
                }
            } else {
                this.durationTimeSteepness = 0.0;
            }
            if (atProb.hasAttribute("starting")) {
                try {
                    this.durationStartingTime = Double.valueOf(atProb.getAttribute("starting"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at durationStartingTime");
                }
            } else {
                this.durationStartingTime = 0.0;
            }
        }
        if ((nl = e.getElementsByTagName("ManaCost")).getLength() > 0) {
            atProb = (Element)nl.item(0);
            if (atProb.hasAttribute("steepness")) {
                try {
                    this.manaCostSteepness = Double.valueOf(atProb.getAttribute("steepness"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at manaCostSteepness");
                }
            } else {
                this.manaCostSteepness = 0.0;
            }
            if (atProb.hasAttribute("starting")) {
                try {
                    this.startingManaCost = Double.valueOf(atProb.getAttribute("starting"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at startingManaCost");
                }
            } else {
                this.startingManaCost = 30.0;
            }
        }
        if ((nl = e.getElementsByTagName("Intensity")).getLength() > 0) {
            atProb = (Element)nl.item(0);
            if (atProb.hasAttribute("steepness")) {
                try {
                    this.intensitySteepness = Double.valueOf(atProb.getAttribute("steepness"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at intensitySteepness");
                }
            } else {
                this.intensitySteepness = 0.0;
            }
            if (atProb.hasAttribute("starting")) {
                try {
                    this.startingIntensity = Double.valueOf(atProb.getAttribute("starting"));
                }
                catch (NumberFormatException nfe) {
                    throw new XMLtoWorldException("Number format error at startingManaCost");
                }
            } else {
                this.startingIntensity = 30.0;
            }
        }
        if ((nl = e.getElementsByTagName("EffectList")).getLength() > 0) {
            Element effectListNode = (Element)nl.item(0);
            this.effects = new EffectList(mundo, effectListNode);
            NodeList nl2 = effectListNode.getElementsByTagName("EffectRef");
            this.intensities = new Vector();
            for (int r = 0; r < nl2.getLength(); ++r) {
                Element h = (Element)nl2.item(r);
                if (h.hasAttribute("intensity")) {
                    this.intensities.add(new Integer(h.getAttribute("intensity")));
                    continue;
                }
                this.intensities.add(new Integer(0));
            }
        }
        if ((codeNodes = e.getElementsByTagName("Code")).getLength() > 0) {
            try {
                this.itsCode = new ObjectCode(mundo, codeNodes.item(0));
            }
            catch (XMLtoWorldException ex) {
                throw new XMLtoWorldException("Exception at Code node: " + ex.getMessage());
            }
        }
        if (this.getID() < 10000000) {
            this.idnumber += 50000000;
        }
    }

    public int matchesCommand(String commandArgs, boolean pluralOrSingular) {
        return commandArgs.trim().equalsIgnoreCase(this.getTitle()) ? 1 : 0;
    }

    public void incrementUsage(Mobile m) {
        for (int i = 0; i < this.involvedSkills.length; ++i) {
            if (!(m.getRandom().nextDouble() < this.involvedSkillRelevance[i])) continue;
            m.incSkill(this.involvedSkills[i]);
        }
    }

    public ObjectCode getAssociatedCode() {
        return this.itsCode;
    }
}

