/*
 * Decompiled with CFR 0.152.
 */
package eu.irreality.age.swing.mdi;

import eu.irreality.age.GameChoosingInternalFrame;
import eu.irreality.age.ServerConfigurationWindow;
import eu.irreality.age.SwingAetheriaGameLoader;
import eu.irreality.age.SwingAetheriaGameLoaderInterface;
import eu.irreality.age.SwingImageDrawingThread;
import eu.irreality.age.server.ServerHandler;
import eu.irreality.age.swing.config.AGEConfiguration;
import eu.irreality.age.swing.mdi.MDIMenuBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.plaf.metal.MetalIconFactory;

public class SwingAetheriaGUI
extends JFrame {
    JDesktopPane panel;
    JMenuBar menuBar;
    Vector padre1;
    Vector padre2;
    int i = 0;
    int j = 0;
    private static SwingAetheriaGUI instance;
    public static WindowListener standaloneWindowListener;
    public static WindowListener nonStandaloneWindowListener;

    public static SwingAetheriaGUI getInstance() {
        return instance;
    }

    public JDesktopPane getPanel() {
        return this.panel;
    }

    public void closeSubWindows() {
        JInternalFrame[] frames = this.panel.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof SwingAetheriaGameLoader)) continue;
            ((SwingAetheriaGameLoader)frames[i]).exitNow();
        }
    }

    private void maximizeIfPossible() {
        int state = this.getExtendedState();
        this.setExtendedState(state |= 6);
    }

    public void saveWindowCoordinates() {
        try {
            if ((this.getExtendedState() & 6) != 6) {
                AGEConfiguration.getInstance().setProperty("mdiWindowWidth", String.valueOf(this.getWidth()));
                AGEConfiguration.getInstance().setProperty("mdiWindowHeight", String.valueOf(this.getHeight()));
                AGEConfiguration.getInstance().setProperty("mdiWindowMaximized", "false");
                AGEConfiguration.getInstance().setProperty("mdiWindowLocationX", String.valueOf(this.getX()));
                AGEConfiguration.getInstance().setProperty("mdiWindowLocationY", String.valueOf(this.getY()));
            } else {
                AGEConfiguration.getInstance().setProperty("mdiWindowMaximized", "true");
            }
            AGEConfiguration.getInstance().storeProperties();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public SwingAetheriaGUI() {
        super("Aetheria Game Engine, v 1.1.1");
        instance = this;
        this.setDefaultCloseOperation(3);
        this.addWindowListener(standaloneWindowListener);
        this.setSize(AGEConfiguration.getInstance().getIntegerProperty("mdiWindowWidth"), AGEConfiguration.getInstance().getIntegerProperty("mdiWindowHeight"));
        this.setLocation(AGEConfiguration.getInstance().getIntegerProperty("mdiWindowLocationX"), AGEConfiguration.getInstance().getIntegerProperty("mdiWindowLocationY"));
        if (AGEConfiguration.getInstance().getBooleanProperty("mdiWindowMaximized")) {
            this.maximizeIfPossible();
        }
        try {
            Image iconito = this.getToolkit().getImage(this.getClass().getClassLoader().getResource("images/intficon.gif"));
            this.setIconImage(iconito);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingImageDrawingThread imthread = new SwingImageDrawingThread("images/agelogo.jpg", 1000L, this);
        imthread.start();
        ServerConfigurationWindow.setMadre(this);
        Image logo = this.getToolkit().createImage(this.getClass().getClassLoader().getResource("images/agelogo.jpg"));
        this.panel = new JDesktopPane();
        this.panel.setBackground(Color.black);
        JPanel general = new JPanel();
        general.setLayout(new BorderLayout());
        general.add((Component)this.panel, "Center");
        JPanel botones = new JPanel();
        botones.setLayout(new GridLayout(1, 7));
        JButton botonNuevo = new JButton("Nuevo");
        botones.add(botonNuevo);
        botones.add(new JButton(MetalIconFactory.getFileChooserNewFolderIcon()));
        botones.add(new JButton(MetalIconFactory.getFileChooserNewFolderIcon()));
        this.panel.setVisible(true);
        this.setContentPane(general);
        this.setJMenuBar(new MDIMenuBar(this.panel, this));
        this.setVisible(true);
        SwingAetheriaGameLoaderInterface.loadFont();
        this.panel.add(new GameChoosingInternalFrame(this.panel));
        ServerHandler sh = ServerHandler.getInstance(this.panel);
        if (sh.getServerConfigurationOptions().initOnStartup()) {
            sh.initPartidasDedicadas(this.panel);
        }
    }

    static {
        standaloneWindowListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SwingAetheriaGUI.getInstance().saveWindowCoordinates();
                System.exit(0);
            }
        };
        nonStandaloneWindowListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SwingAetheriaGUI.getInstance().saveWindowCoordinates();
                ((SwingAetheriaGUI)e.getWindow()).setVisible(false);
                ((SwingAetheriaGUI)e.getWindow()).closeSubWindows();
            }
        };
    }
}

