/*
 * Decompiled with CFR 0.152.
 */
package micromod;

import micromod.Mixer;
import micromod.Module;
import micromod.Sequencer;
import micromod.Synthesizer;
import micromod.WaveScaler;
import micromod.WaveShaper;
import micromod.output.HasAvailableOutputDevice;
import micromod.output.OutputDevice;
import micromod.output.PCM16StreamOutputDevice;
import micromod.resamplers.Resampler;

public class MicroMod {
    public static final String MICROMOD_VERSION = "0.98kX!";
    protected OutputDevice output;
    protected Sequencer sequencer;
    protected Synthesizer synthesizer;
    protected Resampler resampler;
    protected Mixer mixer;
    public static final int MAX_SAMPLES_PER_TICK = 8192;
    protected static final int LOG2_VOL_RAMP_SAMPLES = 4;
    protected static final int VOL_RAMP_SAMPLES = 16;
    protected short[] volRampLeftBuffer;
    protected short[] volRampRightBuffer;
    protected short[] leftOutBuffer;
    protected short[] rightOutBuffer;
    protected int tickLength;
    protected int currentTick;

    public MicroMod(Module module, PCM16StreamOutputDevice output, Resampler resampler) {
        System.out.println("  _   _            _   _");
        System.out.println(" / \\_/ \\() __ _ _ / \\_/ \\ _  _|");
        System.out.println(" \\_\\ /_/|||_ | |_|\\_\\ /_/|_||_|");
        System.out.println("  =MuMart2002==========0.98kX!=");
        System.out.println();
        System.out.println(" MicroMod ProTracker replay (C)2002 Martin Cameron.");
        System.out.println(" Free Software licenced under the GNU LGPL.");
        System.out.println();
        if (!(output instanceof PCM16StreamOutputDevice)) {
            throw new IllegalArgumentException("The specified output device is not supported!");
        }
        this.output = output;
        this.setResampler(resampler);
        this.synthesizer = new Synthesizer(module, output.getSamplingRate());
        this.mixer = new Mixer(this.synthesizer, null, null);
        this.sequencer = new Sequencer(module, this.synthesizer);
        this.currentTick = this.tickLength = this.synthesizer.getCiaTickSamples();
        this.volRampLeftBuffer = new short[16];
        this.volRampRightBuffer = new short[16];
        this.leftOutBuffer = new short[8192];
        this.rightOutBuffer = new short[8192];
    }

    public synchronized void setModule(Module module) {
        this.synthesizer.setModule(module);
        this.sequencer.setModule(module);
        this.currentTick = this.tickLength = this.synthesizer.getCiaTickSamples();
    }

    public synchronized void setOutputDevice(PCM16StreamOutputDevice output) {
        this.output = output;
        this.synthesizer.setSamplingRate(output.getSamplingRate());
    }

    public synchronized void setResampler(Resampler resampler) {
        this.resampler = resampler;
    }

    public synchronized void setWaveShaper(WaveShaper waveShaper) {
        this.mixer.setWaveShaper(waveShaper);
    }

    public synchronized void setWaveScaler(WaveScaler waveScaler) {
        this.mixer.setWaveScaler(waveScaler);
    }

    public synchronized void usePAL(boolean pal) {
        this.synthesizer.usePAL(pal);
    }

    public synchronized boolean isPAL() {
        return this.synthesizer.isPAL();
    }

    public synchronized void setGain(int gain) {
        this.mixer.setGain(gain);
    }

    public synchronized int getSongLengthPatterns() {
        return this.sequencer.getSongLengthPatterns();
    }

    public synchronized int getCurrentPatternPos() {
        return this.sequencer.getSequencePosition();
    }

    public synchronized void setCurrentPatternPos(int pos) {
        if (pos == 0) {
            this.sequencer.reset();
            this.synthesizer.reset();
            this.currentTick = this.tickLength = this.synthesizer.getCiaTickSamples();
        } else {
            this.sequencer.setSequencePosition(pos);
        }
    }

    public synchronized int getSequenceLoopCount() {
        return this.sequencer.getSequenceCounter();
    }

    public synchronized void doRealTimePlayback() {
        if (!(this.output instanceof HasAvailableOutputDevice)) {
            throw new UnsupportedOperationException("The specified OutputDevice does not support real-time operation!");
        }
        int bufferAvailable = ((HasAvailableOutputDevice)this.output).framesAvailable();
        if (bufferAvailable < 16) {
            return;
        }
        if (this.currentTick < this.tickLength) {
            if (bufferAvailable < this.currentTick) {
                if (this.currentTick - bufferAvailable >= 16) {
                    this.writeAudio(bufferAvailable, false, false);
                    this.currentTick -= bufferAvailable;
                    bufferAvailable = 0;
                }
            } else {
                this.writeAudio(this.currentTick, false, true);
                bufferAvailable -= this.currentTick;
                this.sequencer.update();
                this.currentTick = this.tickLength = this.synthesizer.getCiaTickSamples();
            }
        }
        while (bufferAvailable >= this.tickLength) {
            this.writeAudio(this.tickLength, true, true);
            bufferAvailable -= this.tickLength;
            this.sequencer.update();
            this.currentTick = this.tickLength = this.synthesizer.getCiaTickSamples();
        }
        if (bufferAvailable >= 16 && this.currentTick - bufferAvailable >= 16) {
            this.writeAudio(bufferAvailable, true, false);
            this.currentTick -= bufferAvailable;
        }
    }

    public synchronized void doPlayback() {
        if (this.currentTick < this.tickLength) {
            this.writeAudio(this.currentTick, false, true);
            this.sequencer.update();
            this.currentTick = this.tickLength = this.synthesizer.getCiaTickSamples();
        }
        this.writeAudio(this.tickLength, true, true);
        this.sequencer.update();
        this.currentTick = this.tickLength = this.synthesizer.getCiaTickSamples();
    }

    protected void writeAudio(int length, boolean ramp, boolean updateRamp) {
        this.mixer.output(this.leftOutBuffer, this.rightOutBuffer, length, this.resampler, false);
        if (ramp) {
            this.volumeRamp(this.leftOutBuffer, this.rightOutBuffer);
        }
        ((PCM16StreamOutputDevice)this.output).write(this.leftOutBuffer, this.rightOutBuffer, length);
        if (updateRamp) {
            this.mixer.output(this.volRampLeftBuffer, this.volRampRightBuffer, 16, this.resampler, true);
        }
    }

    protected void volumeRamp(short[] leftBuffer, short[] rightBuffer) {
        for (int x = 0; x < 16; ++x) {
            int y = 16 - x;
            leftBuffer[x] = (short)(leftBuffer[x] * x + this.volRampLeftBuffer[x] * y >> 4);
            rightBuffer[x] = (short)(rightBuffer[x] * x + this.volRampRightBuffer[x] * y >> 4);
        }
    }
}

