/*
 * Decompiled with CFR 0.152.
 */
package micromod;

import micromod.Channel;
import micromod.Modulator;
import micromod.Module;

public class Synthesizer {
    public static final int CBM_AMIGA_PAL_CLOCK = 7093789;
    public static final int CBM_AMIGA_NTSC_CLOCK = 7159090;
    protected Module module;
    protected Modulator[] modulators;
    protected Channel[] channels;
    protected int numberOfChannels;
    protected int samplingRate;
    protected int ciaTickSamples;
    protected int ciaPreCalc;
    protected boolean pal;

    public Synthesizer(Module mod, int mixingRate) {
        this.samplingRate = mixingRate;
        this.setModule(mod);
    }

    public void setModule(Module mod) {
        this.module = mod;
        this.numberOfChannels = mod.getSequence().getNumberOfChannels();
        this.modulators = new Modulator[this.numberOfChannels];
        this.channels = new Channel[this.numberOfChannels];
        for (int n = 0; n < this.numberOfChannels; ++n) {
            this.channels[n] = new Channel(8000, false);
            this.modulators[n] = new Modulator(this.channels[n], mod.allowsPanning());
        }
        this.usePAL(mod.isPAL());
        this.setSamplingRate(this.samplingRate);
        this.reset();
    }

    public void setSamplingRate(int rate) {
        this.samplingRate = rate;
        for (int n = 0; n < this.numberOfChannels; ++n) {
            this.channels[n].configure(rate, this.pal);
        }
    }

    public void usePAL(boolean p) {
        this.pal = p;
        for (int n = 0; n < this.numberOfChannels; ++n) {
            this.channels[n].configure(this.samplingRate, this.pal);
        }
        int ciaClock = 715909;
        if (this.pal) {
            ciaClock = 709378;
        }
        this.ciaPreCalc = 2128136400 / ciaClock;
    }

    public boolean isPAL() {
        return this.pal;
    }

    public void reset() {
        int low = 0;
        int high = 65536;
        int decider = 0;
        if (!this.module.allowsPanning()) {
            low = 13107;
            high = 52428;
        }
        for (int n = 0; n < this.numberOfChannels; ++n) {
            this.modulators[n].reset();
            this.channels[n].reset();
            decider = n & 3;
            if (decider == 0 || decider == 3) {
                this.channels[n].setPanning(high, low);
                continue;
            }
            this.channels[n].setPanning(low, high);
        }
    }

    public void setBPM(int bpm) {
        this.ciaTickSamples = this.ciaPreCalc * this.samplingRate / (bpm * 1200);
    }

    public int getCiaTickSamples() {
        return this.ciaTickSamples;
    }

    public int getNumberOfChannels() {
        return this.numberOfChannels;
    }

    public Channel getChannel(int channel) {
        return this.channels[channel];
    }

    public void initialiseFX(int channel, int period, int instrument, int effectCommand, int effectValue) {
        this.modulators[channel].initialiseFX(period, this.module.getInstrument(instrument), effectCommand, effectValue);
    }

    public void updateFX() {
        for (int n = 0; n < this.numberOfChannels; ++n) {
            this.modulators[n].updateFX();
        }
    }
}

