/*
 * Decompiled with CFR 0.152.
 */
package micromod.output;

import micromod.output.PCM16;
import micromod.output.StreamOutputDevice;
import micromod.output.converters.AudioFormatConverter;

public abstract class PCM16StreamOutputDevice
implements StreamOutputDevice,
PCM16 {
    protected static int CONVERT_BUFFER_FRAMES = 1024;
    protected byte[] convertBuffer;
    protected int bytesPerFrame;
    protected AudioFormatConverter converter;

    protected void initialise(AudioFormatConverter converter) {
        this.converter = converter;
        this.bytesPerFrame = converter.getBytesPerFrame();
        this.convertBuffer = new byte[CONVERT_BUFFER_FRAMES * this.bytesPerFrame];
    }

    public void write(short[] leftBuffer, short[] rightBuffer, int length) {
        int outputLen;
        for (int position = 0; position < length; position += outputLen) {
            outputLen = length - position;
            if (outputLen > CONVERT_BUFFER_FRAMES) {
                outputLen = CONVERT_BUFFER_FRAMES;
            }
            this.converter.convert(leftBuffer, rightBuffer, position, this.convertBuffer, outputLen);
            this.write(this.convertBuffer, outputLen * this.bytesPerFrame);
        }
    }
}

