/*
 * Decompiled with CFR 0.152.
 */
package micromod.resamplers;

import micromod.resamplers.Resampler;

public class FIRResampler
implements Resampler {
    protected static final int FIXED_POINT_SHIFT = 12;
    protected static final int FIXED_POINT_ONE = 4096;
    protected static final int FIXED_POINT_BITMASK = 4095;
    protected static final int FIXED_POINT_CONV = 4;
    protected int points;
    protected short[] sinc;

    public FIRResampler(int numPoints) {
        this.points = numPoints >> 1;
        if (this.points < 1) {
            this.points = 1;
        }
        this.genSinc();
        System.out.println(" Multipoint FIR Resampler 0.3 Initialised. Using " + (this.points << 1) + " points.");
    }

    public void resample(short[] inputBuf, int samplePos, int subSamplePos, int step, int subStep, short[] outputBuf, int position, int length) {
        int end = position + length;
        if (step == 0) {
            subSamplePos >>= 4;
            subStep >>= 4;
            while (position < end) {
                int amp = 0;
                int issp = 4096 - subSamplePos;
                int spos = samplePos - this.points + 1;
                int n = this.points - 1;
                while (n >= 0) {
                    amp += inputBuf[spos] * this.sinc[(n << 12) + subSamplePos] >> 15;
                    --n;
                    ++spos;
                }
                n = 0;
                while (n < this.points) {
                    amp += inputBuf[spos] * this.sinc[(n << 12) + issp] >> 15;
                    ++n;
                    ++spos;
                }
                outputBuf[position++] = (short)amp;
                samplePos += (subSamplePos += subStep) >> 12;
                subSamplePos &= 0xFFF;
            }
        } else {
            while (position < end) {
                outputBuf[position++] = inputBuf[samplePos];
                samplePos += step + ((subSamplePos += subStep) >> 12);
                subSamplePos &= 0xFFF;
            }
        }
    }

    public int getCushionSize() {
        return this.points;
    }

    protected void genSinc() {
        double gain = 0.6;
        int len = (this.points << 12) + 1;
        this.sinc = new short[len];
        this.sinc[0] = (short)(32767.0 * gain);
        for (int n = 1; n < len; ++n) {
            double t = (double)n / 4096.0;
            double pit = Math.PI * t;
            double wpit = pit / (double)this.points;
            this.sinc[n] = (short)(Math.sin(pit) / pit * (0.42 + 0.5 * Math.cos(wpit) + 0.08 * Math.cos(2.0 * wpit)) * 32767.0 * gain);
        }
    }

    protected static void zero(short[] buffer, int start, int end) {
        for (int n = start; n < end; ++n) {
            buffer[n] = 0;
        }
    }
}

